/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.view;

import com.google.common.collect.ImmutableMap;
import com.infernostats.InfernoStatsConfig;
import com.infernostats.model.NPC;
import com.infernostats.model.Wave;
import com.infernostats.view.TimeFormatting;
import com.infernostats.view.WaveImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveStatsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(WaveStatsPanel.class);
    private Wave wave;
    private String baseURL;
    private String waveURL;
    private JLabel waveNumber;
    private JLabel duration;
    private JLabel damageTaken;
    private JLabel damageDealt;
    private JLabel prayerDrain;
    private JLabel idleTicks;
    private WaveImage imageLabel;
    private JPanel textPanel;
    private InfernoStatsConfig config;
    private static final Border normalBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 4, 0, ColorScheme.DARK_GRAY_COLOR), new EmptyBorder(4, 6, 4, 6));
    private static final Border hoverBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 4, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_HOVER_COLOR), new EmptyBorder(3, 5, 3, 5)));

    public WaveStatsPanel(InfernoStatsConfig config, Wave wave) {
        this.config = config;
        this.wave = wave;
        this.baseURL = config.url().base;
        this.waveURL = this.generateURL();
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(normalBorder);
        JPanel wavePanel = new JPanel();
        wavePanel.setLayout(new BoxLayout(wavePanel, 1));
        wavePanel.setBackground(null);
        JPanel wavePanelTop = new JPanel();
        wavePanelTop.setLayout(new BoxLayout(wavePanelTop, 1));
        wavePanelTop.setBackground(null);
        JPanel waveNumberLine = new JPanel();
        waveNumberLine.setLayout(new BorderLayout());
        waveNumberLine.setBackground(null);
        this.waveNumber = new JLabel();
        if (wave.isSplit()) {
            this.waveNumber.setText("Wave " + wave.getId() + " - " + TimeFormatting.getSplitTime(wave));
        } else {
            this.waveNumber.setText("Wave " + wave.getId());
        }
        this.waveNumber.setHorizontalAlignment(0);
        this.waveNumber.setForeground(Color.WHITE);
        waveNumberLine.add(this.waveNumber);
        JPanel wavePanelBottom = new JPanel();
        wavePanelBottom.setLayout(new BoxLayout(wavePanelBottom, 0));
        wavePanelBottom.setBackground(null);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BoxLayout(this.textPanel, 1));
        this.textPanel.setBackground(null);
        JPanel durationLine = new JPanel();
        durationLine.setLayout(new BorderLayout());
        durationLine.setBackground(null);
        this.duration = new JLabel();
        this.duration.setText("Time: 00:00");
        this.duration.setForeground(Color.WHITE);
        durationLine.add((Component)this.duration, "West");
        JPanel damageTakenLine = new JPanel();
        damageTakenLine.setLayout(new BorderLayout());
        damageTakenLine.setBackground(null);
        this.damageTaken = new JLabel();
        this.damageTaken.setText("Damage Taken: 0");
        this.damageTaken.setForeground(Color.WHITE);
        damageTakenLine.add((Component)this.damageTaken, "West");
        JPanel damageDealtLine = new JPanel();
        damageDealtLine.setLayout(new BorderLayout());
        damageDealtLine.setBackground(null);
        this.damageDealt = new JLabel();
        this.damageDealt.setText("Damage Dealt: 0");
        this.damageDealt.setForeground(Color.WHITE);
        damageDealtLine.add((Component)this.damageDealt, "West");
        JPanel prayerDrainLine = new JPanel();
        prayerDrainLine.setLayout(new BorderLayout());
        prayerDrainLine.setBackground(null);
        this.prayerDrain = new JLabel();
        this.prayerDrain.setText("Prayer Drain: 0");
        this.prayerDrain.setForeground(Color.WHITE);
        prayerDrainLine.add((Component)this.prayerDrain, "West");
        JPanel idleTicksLine = new JPanel();
        idleTicksLine.setLayout(new BorderLayout());
        idleTicksLine.setBackground(null);
        this.idleTicks = new JLabel();
        this.idleTicks.setText("Idle Ticks: 0");
        this.idleTicks.setForeground(Color.WHITE);
        idleTicksLine.add((Component)this.idleTicks, "West");
        this.textPanel.add(durationLine);
        this.textPanel.add(damageTakenLine);
        this.textPanel.add(damageDealtLine);
        this.textPanel.add(prayerDrainLine);
        if (config.showIdleTicksInSidePanel()) {
            this.textPanel.add(idleTicksLine);
        }
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(new BoxLayout(imagePanel, 1));
        imagePanel.setBackground(null);
        this.imageLabel = new WaveImage();
        imagePanel.add(this.imageLabel);
        wavePanelTop.add(waveNumberLine);
        wavePanelBottom.add(this.textPanel);
        wavePanelBottom.add(imagePanel);
        wavePanel.add((Component)wavePanelTop, "North");
        wavePanel.add((Component)wavePanelBottom, "South");
        this.add((Component)wavePanel, "North");
        MouseAdapter waveStatsMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WaveStatsPanel.this.setBackground(ColorScheme.DARK_GRAY_COLOR);
                for (Component c : WaveStatsPanel.this.getComponents()) {
                    c.setBackground(ColorScheme.DARK_GRAY_COLOR);
                }
                WaveStatsPanel.this.setBorder(hoverBorder);
                WaveStatsPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WaveStatsPanel.this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                for (Component c : WaveStatsPanel.this.getComponents()) {
                    c.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                }
                WaveStatsPanel.this.setBorder(normalBorder);
                WaveStatsPanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                LinkBrowser.browse((String)WaveStatsPanel.this.waveURL);
            }
        };
        this.addMouseListener(waveStatsMouseListener);
    }

    public void RedrawWaveSpawn() {
        Map<String, ArrayList<ArrayList<Integer>>> mobs = this.remapNPCs();
        ImmutableMap mob_sizes = new ImmutableMap.Builder().put((Object)"Jal-MejRah", (Object)2).put((Object)"Jal-Ak", (Object)3).put((Object)"Jal-ImKot", (Object)4).put((Object)"Jal-Xil", (Object)3).put((Object)"Jal-Zek", (Object)4).build();
        ImmutableMap mob_colors = new ImmutableMap.Builder().put((Object)"Jal-MejRah", (Object)Color.GRAY).put((Object)"Jal-Ak", (Object)Color.YELLOW).put((Object)"Jal-ImKot", (Object)Color.ORANGE).put((Object)"Jal-Xil", (Object)Color.GREEN).put((Object)"Jal-Zek", (Object)Color.RED).build();
        for (Map.Entry<String, ArrayList<ArrayList<Integer>>> entry : mobs.entrySet()) {
            String name = entry.getKey();
            int size = (Integer)mob_sizes.get((Object)name);
            ArrayList<ArrayList<Integer>> spawnTiles = entry.getValue();
            for (ArrayList<Integer> spawnTile : spawnTiles) {
                int x = spawnTile.get(0);
                int y = spawnTile.get(1);
                this.imageLabel.drawSpawn(x, y, size, (Color)mob_colors.get((Object)name));
            }
        }
        this.imageLabel.revalidate();
        this.imageLabel.repaint();
    }

    public String generateURL() {
        Map<String, ArrayList<ArrayList<Integer>>> mobs = this.remapNPCs();
        ImmutableMap npc_names = new ImmutableMap.Builder().put((Object)"Jal-MejRah", (Object)"bat").put((Object)"Jal-Ak", (Object)"blob").put((Object)"Jal-ImKot", (Object)"melee").put((Object)"Jal-Xil", (Object)"ranger").put((Object)"Jal-Zek", (Object)"mager").build();
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseURL);
        for (Map.Entry<String, ArrayList<ArrayList<Integer>>> entry : mobs.entrySet()) {
            sb.append((String)npc_names.get((Object)entry.getKey()));
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("&");
        }
        sb.append("copyable");
        return sb.toString().replaceAll("\\s", "");
    }

    private Map<String, ArrayList<ArrayList<Integer>>> remapNPCs() {
        HashMap<String, ArrayList<ArrayList<Integer>>> mobs = new HashMap<String, ArrayList<ArrayList<Integer>>>();
        for (NPC npc : this.wave.getNpcs()) {
            int xOffset = 17;
            int yOffset = 46;
            int x = npc.getTile().getRegionX() - 17;
            int y = 46 - npc.getTile().getRegionY();
            mobs.computeIfAbsent(npc.getName(), k -> new ArrayList());
            ((ArrayList)mobs.get(npc.getName())).add(new ArrayList<Integer>(Arrays.asList(x, y)));
        }
        return mobs;
    }

    public void update() {
        switch (this.getWave().getState()) {
            case FINISHED: 
            case STARTED: {
                this.getWaveNumber().setForeground(Color.WHITE);
                break;
            }
            case SUCCESS: {
                this.getWaveNumber().setForeground(Color.GREEN);
                break;
            }
            case FAILED: {
                this.getWaveNumber().setForeground(Color.RED);
            }
        }
        this.waveURL = this.generateURL();
        this.duration.setText("Time: " + TimeFormatting.getCurrentWaveTime(this.wave));
        this.damageTaken.setText("Damage Taken: " + this.wave.getDamageTaken());
        this.damageDealt.setText("Damage Dealt: " + this.wave.getDamageDealt());
        this.prayerDrain.setText("Prayer Drain: " + this.wave.getPrayerDrain());
        this.idleTicks.setText("Idle Ticks: " + this.wave.getIdleTicks());
        this.RedrawWaveSpawn();
    }

    public Wave getWave() {
        return this.wave;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getWaveURL() {
        return this.waveURL;
    }

    public JLabel getWaveNumber() {
        return this.waveNumber;
    }

    public JLabel getDuration() {
        return this.duration;
    }

    public JLabel getDamageTaken() {
        return this.damageTaken;
    }

    public JLabel getDamageDealt() {
        return this.damageDealt;
    }

    public JLabel getPrayerDrain() {
        return this.prayerDrain;
    }

    public JLabel getIdleTicks() {
        return this.idleTicks;
    }

    public WaveImage getImageLabel() {
        return this.imageLabel;
    }

    public JPanel getTextPanel() {
        return this.textPanel;
    }

    public InfernoStatsConfig getConfig() {
        return this.config;
    }

    public void setWave(Wave wave) {
        this.wave = wave;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public void setWaveURL(String waveURL) {
        this.waveURL = waveURL;
    }

    public void setWaveNumber(JLabel waveNumber) {
        this.waveNumber = waveNumber;
    }

    public void setDuration(JLabel duration) {
        this.duration = duration;
    }

    public void setDamageTaken(JLabel damageTaken) {
        this.damageTaken = damageTaken;
    }

    public void setDamageDealt(JLabel damageDealt) {
        this.damageDealt = damageDealt;
    }

    public void setPrayerDrain(JLabel prayerDrain) {
        this.prayerDrain = prayerDrain;
    }

    public void setIdleTicks(JLabel idleTicks) {
        this.idleTicks = idleTicks;
    }

    public void setImageLabel(WaveImage imageLabel) {
        this.imageLabel = imageLabel;
    }

    public void setTextPanel(JPanel textPanel) {
        this.textPanel = textPanel;
    }

    public void setConfig(InfernoStatsConfig config) {
        this.config = config;
    }
}

