/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.view;

import com.infernostats.model.Wave;
import com.infernostats.view.TimeFormatting;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveSplitsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(WaveSplitsPanel.class);
    private final JLabel titleLabel = new JLabel();
    private ArrayList<Wave> waves = null;

    @Inject
    public WaveSplitsPanel() {
        this.setBorder(new EmptyBorder(2, 8, 2, 8));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.titleLabel.setText("Copy Wave Splits to Clipboard");
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setForeground(Color.WHITE);
        this.add(this.titleLabel);
        MouseAdapter waveStatsMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WaveSplitsPanel.this.setUnderline(WaveSplitsPanel.this.titleLabel);
                WaveSplitsPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WaveSplitsPanel.this.unsetUnderline(WaveSplitsPanel.this.titleLabel);
                WaveSplitsPanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(WaveSplitsPanel.this.WaveSplitTimes()), null);
            }
        };
        this.addMouseListener(waveStatsMouseListener);
    }

    private void setUnderline(JLabel label) {
        Font font = label.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        label.setFont(font.deriveFont(attributes));
    }

    private void unsetUnderline(JLabel label) {
        Font font = label.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, -1);
        label.setFont(font.deriveFont(attributes));
    }

    public String WaveSplitTimes() {
        StringBuilder splits = new StringBuilder();
        Wave prev = null;
        for (Wave wave : this.waves) {
            if (!wave.isSplit()) continue;
            splits.append("Wave: ").append(wave.getId()).append(", ").append("Split: ").append(TimeFormatting.getSplitTime(wave)).append(" ").append("(+").append(TimeFormatting.getSplitDelta(wave, prev)).append(")").append("\n");
            prev = wave;
        }
        if (this.waves.isEmpty()) {
            splits.append("Duration (Not Started): N/a");
            return splits.toString();
        }
        Wave wave = this.waves.get(this.waves.size() - 1);
        String duration = TimeFormatting.getCurrentTotalTime(wave);
        switch (wave.getState()) {
            case FINISHED: 
            case STARTED: {
                splits.append("Duration (Unfinished): ").append(duration);
                break;
            }
            case SUCCESS: {
                splits.append("Duration (Success): ").append(duration);
                break;
            }
            case FAILED: {
                splits.append("Duration (Failed): ").append(duration);
            }
        }
        return splits.toString();
    }

    public void setWaves(ArrayList<Wave> waves) {
        this.waves = waves;
    }
}

