/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.view;

import com.infernostats.model.WaveSpawn;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.runelite.client.util.ImageUtil;

public class WaveImage
extends JLabel {
    private final ArrayList<WaveSpawn> spawns;

    public WaveImage() {
        int IMAGE_SCALE = 2;
        BufferedImage image = ImageUtil.loadImageResource(this.getClass(), (String)"/inferno-base.png");
        Image scaledImage = image.getScaledInstance(image.getWidth() * IMAGE_SCALE, image.getHeight() * IMAGE_SCALE, 1);
        this.setIcon(new ImageIcon(scaledImage));
        this.spawns = new ArrayList();
    }

    public void drawSpawn(int x, int y, int size, Color color) {
        this.spawns.add(new WaveSpawn(x, y, size, color));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (WaveSpawn spawn : this.spawns) {
            g.setColor(spawn.getColor());
            g.fillRect(spawn.getX() * 2, spawn.getY() * 2, spawn.getSize(), spawn.getSize());
        }
    }
}

