/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.view;

import com.infernostats.model.Wave;
import java.time.Duration;

public class TimeFormatting {
    public static String getCurrentWaveTime(Wave wave) {
        return TimeFormatting.formatGameTicks(wave.getDuration());
    }

    public static String getCurrentTotalTime(Wave wave) {
        return TimeFormatting.formatGameTicks(wave.getStart() + wave.getDuration());
    }

    public static String getSplitTime(Wave wave) {
        return TimeFormatting.formatGameTicks(wave.getStart());
    }

    public static String getSplitDelta(Wave wave, Wave prev) {
        if (prev == null) {
            return TimeFormatting.getSplitTime(wave);
        }
        return TimeFormatting.formatDuration(wave.start().minus(prev.start()));
    }

    public static String getCurrentWaveTimeCSV(Wave wave) {
        return TimeFormatting.formatGameTicksCSV(wave.getDuration());
    }

    public static String getSplitTimeCSV(Wave wave) {
        return TimeFormatting.formatGameTicksCSV(wave.getStart());
    }

    public static String getSplitDeltaCSV(Wave wave, Wave prev) {
        if (prev == null) {
            return TimeFormatting.getSplitTimeCSV(wave);
        }
        return TimeFormatting.formatDurationCSV(wave.start().minus(prev.start()));
    }

    public static String formatGameTicks(long gameTicks) {
        long seconds = Duration.ofMillis(gameTicks * 600L).getSeconds();
        return String.format("%02d:%02d", seconds / 60L, seconds % 60L);
    }

    public static String formatDuration(Duration duration) {
        long seconds = duration.toMillis() / 1000L;
        return String.format("%02d:%02d", seconds / 60L, seconds % 60L);
    }

    public static String formatGameTicksCSV(long gameTicks) {
        long s = Duration.ofMillis(gameTicks * 600L).getSeconds();
        return String.format("%02d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    public static String formatDurationCSV(Duration duration) {
        long s = duration.toMillis() / 1000L;
        return String.format("%02d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
    }
}

