/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.model;

import com.google.common.collect.ImmutableMap;
import com.infernostats.InfernoStatsConfig;
import com.infernostats.model.Wave;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WaveSplit {
    private static final Logger log = LoggerFactory.getLogger(WaveSplit.class);
    private static ArrayList<String> targetSplits;
    public static final ImmutableMap<Integer, Split> WaveSplitMap;
    private static final Duration[][] splits;

    public static void UpdateTargetSplits(InfernoStatsConfig config) {
        targetSplits = new ArrayList<String>(Arrays.asList(config.targetWave9Split(), config.targetWave18Split(), config.targetWave25Split(), config.targetWave35Split(), config.targetWave42Split(), config.targetWave50Split(), config.targetWave57Split(), config.targetWave60Split(), config.targetWave63Split(), config.targetWave66Split(), config.targetWave67Split(), config.targetWave68Split(), config.targetWave69Split()));
    }

    private static Duration ParseConfigSplit(Split split) {
        int seconds;
        int minutes;
        String targetSplit = targetSplits.get(split.ordinal());
        if (targetSplit.equals("")) {
            return null;
        }
        String[] time = targetSplit.split(":");
        if (time.length != 2) {
            return null;
        }
        if (time[0].length() > 4 || time[1].length() != 2) {
            return null;
        }
        try {
            minutes = Integer.parseInt(time[0]);
            seconds = Integer.parseInt(time[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return Duration.ofMinutes(minutes).plusSeconds(seconds);
    }

    public static String GoalDifference(Wave wave) {
        Split split = (Split)((Object)WaveSplitMap.get((Object)wave.getId()));
        Duration configSplit = WaveSplit.ParseConfigSplit(split);
        if (configSplit == null) {
            return "";
        }
        long waveSplitSeconds = wave.start().toMillis() / 1000L;
        long configSplitSeconds = configSplit.toMillis() / 1000L;
        int comparison = configSplit.compareTo(wave.start());
        if (comparison > 0) {
            long difference = configSplitSeconds - waveSplitSeconds;
            String minutes = String.valueOf(difference / 60L);
            String seconds = String.format("%02d", difference % 60L);
            return " (-" + minutes + ":" + seconds + ")";
        }
        if (comparison < 0) {
            long difference = waveSplitSeconds - configSplitSeconds;
            String minutes = String.valueOf(difference / 60L);
            String seconds = String.format("%02d", difference % 60L);
            return " (+" + minutes + ":" + seconds + ")";
        }
        return " (-0)";
    }

    public static Duration PredictedTime(Wave wave) {
        long waveStartMillis = wave.getStart() * 600L;
        float percentComplete = WaveSplit.percentOfAvgTime(wave, WaveSplit.checkPace(wave));
        return Duration.ofMillis((long)((float)waveStartMillis * (1.0f / percentComplete)));
    }

    private static Pace checkPace(Wave wave) {
        Split split = (Split)((Object)WaveSplitMap.get((Object)wave.getId()));
        for (Pace pace : Pace.values()) {
            Duration wavePace = splits[split.ordinal()][pace.ordinal()];
            if (wave.start().compareTo(wavePace) <= 0) continue;
            return pace;
        }
        return Pace.SUB45;
    }

    private static float percentOfAvgTime(Wave wave, Pace pace) {
        Split split = (Split)((Object)WaveSplitMap.get((Object)wave.getId()));
        return (float)splits[split.ordinal()][pace.ordinal()].toMillis() / (float)splits[Split.FINISH.ordinal()][pace.ordinal()].toMillis();
    }

    private static Duration splitTime(int minutes, int seconds, int fractMillis) {
        int milliseconds = fractMillis / 60 * 1000;
        return Duration.ofMinutes(minutes).plusSeconds(seconds).plusMillis(milliseconds);
    }

    static {
        WaveSplitMap = ImmutableMap.builder().put((Object)9, (Object)Split.SPLIT9).put((Object)18, (Object)Split.SPLIT18).put((Object)25, (Object)Split.SPLIT25).put((Object)35, (Object)Split.SPLIT35).put((Object)42, (Object)Split.SPLIT42).put((Object)50, (Object)Split.SPLIT50).put((Object)57, (Object)Split.SPLIT57).put((Object)60, (Object)Split.SPLIT60).put((Object)63, (Object)Split.SPLIT63).put((Object)66, (Object)Split.SPLIT66).put((Object)67, (Object)Split.SPLIT67).put((Object)68, (Object)Split.SPLIT68).put((Object)69, (Object)Split.SPLIT69).build();
        splits = new Duration[][]{{WaveSplit.splitTime(3, 12, 57), WaveSplit.splitTime(2, 48, 45), WaveSplit.splitTime(2, 38, 42), WaveSplit.splitTime(2, 34, 59), WaveSplit.splitTime(2, 21, 0)}, {WaveSplit.splitTime(8, 6, 12), WaveSplit.splitTime(7, 9, 58), WaveSplit.splitTime(6, 32, 1), WaveSplit.splitTime(6, 21, 27), WaveSplit.splitTime(5, 43, 0)}, {WaveSplit.splitTime(12, 38, 5), WaveSplit.splitTime(11, 10, 54), WaveSplit.splitTime(10, 20, 25), WaveSplit.splitTime(9, 59, 32), WaveSplit.splitTime(8, 51, 0)}, {WaveSplit.splitTime(19, 59, 27), WaveSplit.splitTime(17, 51, 11), WaveSplit.splitTime(16, 18, 36), WaveSplit.splitTime(15, 49, 34), WaveSplit.splitTime(14, 1, 0)}, {WaveSplit.splitTime(26, 4, 23), WaveSplit.splitTime(23, 13, 13), WaveSplit.splitTime(21, 10, 40), WaveSplit.splitTime(20, 31, 8), WaveSplit.splitTime(18, 9, 0)}, {WaveSplit.splitTime(34, 44, 58), WaveSplit.splitTime(30, 42, 4), WaveSplit.splitTime(27, 57, 20), WaveSplit.splitTime(27, 0, 28), WaveSplit.splitTime(23, 50, 0)}, {WaveSplit.splitTime(43, 6, 49), WaveSplit.splitTime(37, 53, 26), WaveSplit.splitTime(34, 21, 23), WaveSplit.splitTime(33, 5, 17), WaveSplit.splitTime(29, 8, 0)}, {WaveSplit.splitTime(46, 49, 1), WaveSplit.splitTime(41, 5, 58), WaveSplit.splitTime(37, 11, 41), WaveSplit.splitTime(35, 53, 1), WaveSplit.splitTime(31, 35, 0)}, {WaveSplit.splitTime(51, 29, 49), WaveSplit.splitTime(44, 57, 13), WaveSplit.splitTime(40, 36, 18), WaveSplit.splitTime(39, 2, 40), WaveSplit.splitTime(34, 28, 0)}, {WaveSplit.splitTime(56, 2, 37), WaveSplit.splitTime(48, 36, 32), WaveSplit.splitTime(43, 53, 21), WaveSplit.splitTime(42, 6, 38), WaveSplit.splitTime(37, 13, 0)}, {WaveSplit.splitTime(56, 52, 39), WaveSplit.splitTime(49, 27, 4), WaveSplit.splitTime(44, 40, 34), WaveSplit.splitTime(42, 51, 37), WaveSplit.splitTime(37, 56, 0)}, {WaveSplit.splitTime(58, 6, 13), WaveSplit.splitTime(50, 28, 47), WaveSplit.splitTime(45, 37, 21), WaveSplit.splitTime(43, 43, 28), WaveSplit.splitTime(38, 41, 0)}, {WaveSplit.splitTime(61, 14, 23), WaveSplit.splitTime(53, 3, 33), WaveSplit.splitTime(48, 11, 44), WaveSplit.splitTime(46, 9, 11), WaveSplit.splitTime(40, 53, 0)}, {WaveSplit.splitTime(67, 6, 6), WaveSplit.splitTime(57, 39, 56), WaveSplit.splitTime(51, 42, 17), WaveSplit.splitTime(49, 15, 59), WaveSplit.splitTime(43, 43, 0)}};
    }

    private static enum Pace {
        SUB75,
        SUB60,
        SUB55,
        SUB50,
        SUB45;

    }

    private static enum Split {
        SPLIT9,
        SPLIT18,
        SPLIT25,
        SPLIT35,
        SPLIT42,
        SPLIT50,
        SPLIT57,
        SPLIT60,
        SPLIT63,
        SPLIT66,
        SPLIT67,
        SPLIT68,
        SPLIT69,
        FINISH;

    }
}

