/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.model;

import com.google.common.collect.ImmutableSet;
import com.infernostats.model.Location;
import com.infernostats.model.NPC;
import com.infernostats.model.WaveState;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import net.runelite.api.coords.WorldPoint;

public class Wave {
    private final int id;
    private ArrayList<NPC> npcs;
    private final long start;
    private long duration;
    private int damageTaken;
    private int damageDealt;
    private int prayerDrain;
    private int idleTicks;
    private WaveState state;
    private Duration pace;
    private Location location;
    private static final Set<Integer> SPLIT_WAVES = ImmutableSet.of((Object)9, (Object)18, (Object)25, (Object)35, (Object)42, (Object)50, (Object[])new Integer[]{57, 60, 63, 66, 67, 68, 69});
    private static final Set<Integer> FIGHT_CAVE_SPLIT_WAVES = ImmutableSet.of((Object)7, (Object)15, (Object)31, (Object)46, (Object)53, (Object)61, (Object[])new Integer[]{62, 63});

    public Wave(int id, long start) {
        this.id = id;
        this.start = start;
        this.duration = 0L;
        this.damageTaken = 0;
        this.damageDealt = 0;
        this.prayerDrain = 0;
        this.idleTicks = 0;
        this.state = WaveState.STARTED;
        this.npcs = new ArrayList();
        this.pace = null;
    }

    public void addNPC(String name, WorldPoint spawnTile) {
        this.npcs.add(new NPC(name, spawnTile));
    }

    public boolean isSplit() {
        switch (this.location) {
            case FIGHT_CAVES: {
                return FIGHT_CAVE_SPLIT_WAVES.contains(this.getId());
            }
        }
        return SPLIT_WAVES.contains(this.getId());
    }

    public Duration duration() {
        return Duration.ofMillis(this.duration * 600L);
    }

    public Duration start() {
        return Duration.ofMillis(this.start * 600L);
    }

    public int getId() {
        return this.id;
    }

    public ArrayList<NPC> getNpcs() {
        return this.npcs;
    }

    public long getStart() {
        return this.start;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public int getDamageDealt() {
        return this.damageDealt;
    }

    public int getPrayerDrain() {
        return this.prayerDrain;
    }

    public int getIdleTicks() {
        return this.idleTicks;
    }

    public WaveState getState() {
        return this.state;
    }

    public Duration getPace() {
        return this.pace;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setNpcs(ArrayList<NPC> npcs) {
        this.npcs = npcs;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setDamageTaken(int damageTaken) {
        this.damageTaken = damageTaken;
    }

    public void setDamageDealt(int damageDealt) {
        this.damageDealt = damageDealt;
    }

    public void setPrayerDrain(int prayerDrain) {
        this.prayerDrain = prayerDrain;
    }

    public void setIdleTicks(int idleTicks) {
        this.idleTicks = idleTicks;
    }

    public void setState(WaveState state) {
        this.state = state;
    }

    public void setPace(Duration pace) {
        this.pace = pace;
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

