/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.controller;

import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.controller.TimerHandler;
import com.infernostats.events.WaveFinishedEvent;
import com.infernostats.events.WaveStartedEvent;
import com.infernostats.model.Location;
import com.infernostats.model.Wave;
import com.infernostats.model.WaveState;
import com.infernostats.view.TimeFormatting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveHandler {
    private static final Logger log = LoggerFactory.getLogger(WaveHandler.class);
    private Wave wave;
    private Location location;
    private final ArrayList<Wave> waves;
    private int prayer;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;

    @Inject
    protected WaveHandler(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.wave = null;
        this.waves = new ArrayList();
    }

    @Subscribe
    protected void onGameTick(GameTick e) {
        if (!this.plugin.isInInferno() && !this.plugin.isInFightCaves() || this.wave == null) {
            return;
        }
        if (this.wave.getState() != WaveState.STARTED) {
            return;
        }
        if (this.plugin.getTimerState() == TimerHandler.TimerState.RUNNING) {
            this.wave.setDuration(this.wave.getDuration() + 1L);
        }
        this.prayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (!this.plugin.isInInferno() && !this.plugin.isInFightCaves() || this.wave == null) {
            return;
        }
        if (this.wave.getState() != WaveState.STARTED) {
            return;
        }
        if (event.getSkill() != Skill.PRAYER) {
            return;
        }
        if (event.getBoostedLevel() == this.prayer - 1) {
            this.wave.setPrayerDrain(this.wave.getPrayerDrain() + 1);
        }
    }

    @Subscribe(priority=1.0f)
    protected void onWaveStartedEvent(WaveStartedEvent e) {
        if (this.plugin.isInInferno()) {
            this.setLocation(Location.INFERNO);
        } else if (this.plugin.isInFightCaves()) {
            this.setLocation(Location.FIGHT_CAVES);
        }
        this.wave = e.getWave();
        if (this.wave.getId() == 1) {
            this.waves.clear();
        }
        this.waves.add(this.wave);
    }

    @Subscribe(priority=1.0f)
    protected void onWaveFinishedEvent(WaveFinishedEvent e) {
        this.wave.setState(e.getState());
    }

    @Subscribe
    protected void onNpcSpawned(NpcSpawned e) {
        NPC npc = e.getNpc();
        Actor npcActor = e.getActor();
        WorldPoint spawnTile = npcActor.getWorldLocation();
        int npcId = npc.getId();
        if (!this.plugin.isInInferno() || this.wave == null) {
            return;
        }
        if (npcId == 7709 || npcId == 7710) {
            return;
        }
        if (npcId == 7691 || npcId == 7700 || npcId == 7706) {
            return;
        }
        if (this.wave.duration().compareTo(Duration.ofSeconds(1L)) > 0) {
            return;
        }
        this.wave.addNPC(npc.getName(), spawnTile);
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        Actor target = event.getActor();
        Hitsplat hitsplat = event.getHitsplat();
        if (!this.plugin.isInInferno() && !this.plugin.isInFightCaves() || this.wave == null) {
            return;
        }
        if (!hitsplat.isMine()) {
            return;
        }
        if (target == this.client.getLocalPlayer()) {
            this.wave.setDamageTaken(this.wave.getDamageTaken() + hitsplat.getAmount());
        } else {
            this.wave.setDamageDealt(this.wave.getDamageDealt() + hitsplat.getAmount());
        }
    }

    public void WriteWaves() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        String time = formatter.format(LocalDateTime.now());
        if (this.config.saveWaveTimes()) {
            switch (this.config.splitsFileType()) {
                case TEXT: {
                    this.toFile(player.getName(), this.fileName(time, false), this.toText(false));
                    break;
                }
                case CSV: {
                    this.toFile(player.getName(), this.fileName(time, false), this.toCSV(false));
                }
            }
        }
        if (this.config.saveSplitTimes()) {
            switch (this.config.splitsFileType()) {
                case TEXT: {
                    this.toFile(player.getName(), this.fileName(time, true), this.toText(true));
                    break;
                }
                case CSV: {
                    this.toFile(player.getName(), this.fileName(time, true), this.toCSV(true));
                }
            }
        }
    }

    private void toFile(String username, String filename, String contents) {
        try {
            Path path = null;
            switch (this.wave.getLocation()) {
                case FIGHT_CAVES: {
                    path = Files.createDirectories(Paths.get(RuneLite.RUNELITE_DIR.getPath(), "inferno-stats", username, "fight-caves"), new FileAttribute[0]);
                    break;
                }
                case INFERNO: {
                    path = Files.createDirectories(Paths.get(RuneLite.RUNELITE_DIR.getPath(), "inferno-stats", username, "inferno"), new FileAttribute[0]);
                }
            }
            Files.write(path.resolve(filename), contents.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            log.debug("Error writing file: {}", (Object)ex.getMessage());
        }
    }

    private String toText(boolean splitWaves) {
        StringBuilder text = new StringBuilder();
        ArrayList<Wave> waves = this.getWaves();
        if (splitWaves) {
            Object prev = null;
            for (Wave wave : waves) {
                if (!wave.isSplit()) continue;
                text.append("Wave: ").append(wave.getId()).append(", ").append("Split: ").append(TimeFormatting.getSplitTime(wave)).append(" ").append("(+").append(TimeFormatting.getSplitDelta(wave, prev)).append(")").append("\n");
                prev = wave;
            }
        } else {
            for (Wave wave : waves) {
                text.append("Wave: ").append(wave.getId()).append(", ").append("Split: ").append(TimeFormatting.getSplitTime(wave)).append("\n");
            }
        }
        if (waves.isEmpty()) {
            text.append("Duration (Not Started): N/a");
            return text.toString();
        }
        String duration = TimeFormatting.getCurrentTotalTime(this.wave);
        switch (this.wave.getState()) {
            case FINISHED: 
            case STARTED: {
                text.append("Duration (Unfinished): ").append(duration);
                break;
            }
            case SUCCESS: {
                text.append("Duration (Success): ").append(duration);
                break;
            }
            case FAILED: {
                text.append("Duration (Failed): ").append(duration);
            }
        }
        return text.toString();
    }

    private String toCSV(boolean splitWaves) {
        StringBuilder csv = new StringBuilder();
        if (splitWaves) {
            csv.append("wave,split,time,delta,idle\n");
            Wave prev = null;
            for (Wave wave : this.waves) {
                if (!wave.isSplit()) continue;
                csv.append(wave.getId()).append(",").append(TimeFormatting.getSplitTimeCSV(wave)).append(",").append(TimeFormatting.getCurrentWaveTimeCSV(wave)).append(",").append(TimeFormatting.getSplitDeltaCSV(wave, prev)).append(",").append(wave.getIdleTicks()).append("\n");
                prev = wave;
            }
        } else {
            csv.append("wave,split,time,idle\n");
            for (Wave wave : this.waves) {
                csv.append(wave.getId()).append(",").append(TimeFormatting.getSplitTimeCSV(wave)).append(",").append(TimeFormatting.getCurrentWaveTimeCSV(wave)).append(",").append(wave.getIdleTicks()).append("\n");
            }
        }
        return csv.toString();
    }

    private String fileName(String time, boolean splitWaves) {
        String wavesText = (splitWaves ? "Splits" : "Full") + this.getExtension();
        switch (this.wave.getState()) {
            case SUCCESS: {
                return time + " Successful KC on Wave " + this.wave.getId() + ", " + wavesText;
            }
        }
        return time + " Failed KC on Wave " + this.wave.getId() + ", " + wavesText;
    }

    private String getExtension() {
        switch (this.config.splitsFileType()) {
            case CSV: {
                return ".csv";
            }
        }
        return ".txt";
    }

    public Wave getWave() {
        return this.wave;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ArrayList<Wave> getWaves() {
        return this.waves;
    }
}

