/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.controller;

import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.events.TimerPausedEvent;
import com.infernostats.events.TimerStartedEvent;
import com.infernostats.events.TimerStoppedEvent;
import javax.inject.Inject;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerHandler {
    private static final Logger log = LoggerFactory.getLogger(TimerHandler.class);
    private long duration;
    private TimerState state;
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;

    @Inject
    protected TimerHandler(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.duration = 0L;
        this.state = TimerState.STOPPED;
    }

    @Subscribe
    protected void onTimerStartedEvent(TimerStartedEvent e) {
        this.duration = this.state == TimerState.STOPPED ? (long)e.getOffset() : (this.duration += (long)e.getOffset());
        this.state = TimerState.RUNNING;
        this.config.tzhaarTimerState(this.state);
    }

    @Subscribe
    protected void onTimerPausedEvent(TimerPausedEvent e) {
        this.state = TimerState.PAUSED;
        this.config.tzhaarTimerState(this.state);
        this.config.tzhaarDuration(this.duration);
    }

    @Subscribe
    protected void onTimerStoppedEvent(TimerStoppedEvent e) {
        this.state = TimerState.STOPPED;
        this.config.tzhaarTimerState(this.state);
        this.config.tzhaarDuration(this.duration);
    }

    @Subscribe
    protected void onGameTick(GameTick e) {
        if (this.state == TimerState.RUNNING) {
            ++this.duration;
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public TimerState getState() {
        return this.state;
    }

    public InfernoStatsPlugin getPlugin() {
        return this.plugin;
    }

    public InfernoStatsConfig getConfig() {
        return this.config;
    }

    public static enum TimerState {
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

