/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.controller;

import com.google.common.collect.Sets;
import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.events.WaveStartedEvent;
import com.infernostats.model.Wave;
import com.infernostats.model.WaveState;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickLossHandler {
    private static final Logger log = LoggerFactory.getLogger(TickLossHandler.class);
    private Wave wave;
    private int magicXp;
    private int tickDelay;
    private int currChinCount;
    private int prevChinCount;
    private Animation currAnim;
    private Animation prevAnim;
    private Set<Integer> attackableNpcs;
    private static final int SPELLBOOK_VARBIT = 4070;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;

    @Inject
    protected TickLossHandler(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.magicXp = -1;
        this.tickDelay = 0;
        this.currChinCount = -1;
        this.prevChinCount = -1;
        this.currAnim = Animation.UNKNOWN;
        this.prevAnim = Animation.UNKNOWN;
        this.attackableNpcs = new HashSet<Integer>();
    }

    @Subscribe
    protected void onWaveStartedEvent(WaveStartedEvent e) {
        this.wave = e.getWave();
    }

    @Subscribe
    public void onStatChanged(StatChanged e) {
        if (e.getSkill() != Skill.MAGIC) {
            return;
        }
        int newMagicXp = e.getXp();
        if (newMagicXp == this.magicXp) {
            return;
        }
        this.magicXp = newMagicXp;
        if (this.client.getVarbitValue(4070) != 1) {
            return;
        }
        if (this.prevAnim == Animation.BLOWPIPE) {
            this.tickDelay += 5;
        }
    }

    @Subscribe
    protected void onGameTick(GameTick e) {
        Sets.SetView intersection;
        if (this.tickDelay > 0) {
            --this.tickDelay;
        }
        if (this.isCooldownActive() || !this.isWaveActive()) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return;
        }
        int weapon = composition.getEquipmentId(KitType.WEAPON);
        this.prevAnim = this.currAnim;
        this.currAnim = Animation.valueOf(player.getAnimation());
        if (this.prevAnim != Animation.BLOWPIPE && this.currAnim == Animation.BLOWPIPE) {
            this.tickDelay = 2;
        } else if (this.prevAnim == Animation.BLOWPIPE && this.currAnim == Animation.BLOWPIPE && player.getAnimationFrame() == 0) {
            this.tickDelay = 2;
        }
        this.tickDelay += this.getAnimationDelay(this.currAnim, weapon);
        Set<Integer> prevNpcs = this.attackableNpcs;
        this.attackableNpcs = this.getNearbyAttackableNpcs();
        if (prevNpcs.size() != 0 && (intersection = Sets.intersection(prevNpcs, this.attackableNpcs)).size() > 0 && this.tickDelay == 0) {
            this.wave.setIdleTicks(this.wave.getIdleTicks() + 1);
        }
    }

    private boolean isCooldownActive() {
        return this.tickDelay > 1;
    }

    private boolean isWaveActive() {
        return this.wave != null && this.wave.getState() == WaveState.STARTED;
    }

    private Set<Integer> getNearbyAttackableNpcs() {
        HashSet<Integer> result = new HashSet<Integer>();
        if (!this.client.getNpcs().isEmpty()) {
            this.client.getNpcs().stream().filter(npc -> !npc.isDead() && this.isAttackable((NPC)npc)).forEach(npc -> result.add(npc.getIndex()));
        }
        return result;
    }

    private boolean isAttackable(NPC npc) {
        for (int i = 0; i < npc.getComposition().getActions().length; ++i) {
            String action = npc.getComposition().getActions()[i];
            if (action == null || !action.equals("Attack")) continue;
            return true;
        }
        return false;
    }

    private int getAnimationDelay(Animation animation, int weapon) {
        switch (animation) {
            case IDLE: 
            case THRALL: 
            case DEATH_CHARGE: 
            case BLOWPIPE: {
                switch (weapon) {
                    case 9976: 
                    case 9977: 
                    case 10033: 
                    case 10034: 
                    case 11959: {
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
                if (itemContainer == null) {
                    return 0;
                }
                this.prevChinCount = this.currChinCount;
                this.currChinCount = itemContainer.count(weapon);
                if (this.prevChinCount > this.currChinCount) {
                    return 3;
                }
                return 0;
            }
            case EVENT_RPG: 
            case CHINCHOMPA: 
            case TRIDENT_SANG: {
                return 3;
            }
            case BOW: {
                switch (weapon) {
                    case 20997: {
                        return 5;
                    }
                    case 25865: 
                    case 25867: 
                    case 25884: 
                    case 25886: 
                    case 25888: 
                    case 25890: 
                    case 25892: 
                    case 25894: 
                    case 25896: {
                        return 4;
                    }
                }
                return 3;
            }
            case SURGE: {
                return weapon == 24423 ? 4 : 5;
            }
            case STAFF_BASH: {
                switch (weapon) {
                    case 6908: 
                    case 6910: 
                    case 6912: 
                    case 6914: 
                    case 12422: 
                    case 21006: {
                        return 4;
                    }
                }
                return 5;
            }
            case CLAW_SCRATCH: 
            case CLAW_SPEC: 
            case RAPIER: 
            case INQ_MACE: {
                return 4;
            }
            case DINHS: 
            case STRIKE_BOLT: 
            case BURST_BLITZ: 
            case CROSSBOW: 
            case SCYTHE: 
            case BARRAGE: {
                return 5;
            }
            case CHALLY_JAB: 
            case CHALLY_SWIPE: 
            case CHALLY_SPEC: {
                return 7;
            }
        }
        return 0;
    }

    private static enum Animation {
        UNKNOWN(-2),
        IDLE(-1),
        CLAW_SCRATCH(393),
        STAFF_BASH(414),
        PUNCH(422),
        KICK(423),
        BOW(426),
        CHALLY_JAB(428),
        CHALLY_SWIPE(440),
        MSB_SPEC(1074),
        STRIKE_BOLT(1162),
        TRIDENT_SANG(1167),
        CHALLY_SPEC(1203),
        BURST_BLITZ(1379),
        BARRAGE(1979),
        EVENT_RPG(2323),
        INQ_MACE(4503),
        BLOWPIPE(5061),
        DINHS(7511),
        CLAW_SPEC(7514),
        CROSSBOW(7552),
        CHINCHOMPA(7618),
        SURGE(7855),
        SCYTHE(8056),
        RAPIER(8145),
        DEATH_CHARGE(8970),
        THRALL(8973);

        private final int id;

        public static Animation valueOf(int id) {
            return Arrays.stream(Animation.values()).filter(anim -> anim.id == id).findFirst().orElse(UNKNOWN);
        }

        public int getId() {
            return this.id;
        }

        private Animation(int id) {
            this.id = id;
        }
    }
}

