/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats.controller;

import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.controller.TimerHandler;
import com.infernostats.events.RunCompletedEvent;
import com.infernostats.events.TimerPausedEvent;
import com.infernostats.events.TimerStartedEvent;
import com.infernostats.events.TimerStoppedEvent;
import com.infernostats.events.WaveFinishedEvent;
import com.infernostats.events.WaveStartedEvent;
import com.infernostats.model.Location;
import com.infernostats.model.Wave;
import com.infernostats.model.WaveSplit;
import com.infernostats.model.WaveState;
import com.infernostats.view.TimeFormatting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatHandler {
    private static final Logger log = LoggerFactory.getLogger(ChatHandler.class);
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;
    private static final Pattern TZHAAR_WAVE_MESSAGE = Pattern.compile("Wave: (\\d+)");
    private static final String TZHAAR_WAVE_COMPLETED_MESSAGE = "Wave completed!";
    private static final String TZHAAR_DEFEATED_MESSAGE = "You have been defeated!";
    private static final Pattern TZHAAR_COMPLETED_MESSAGE = Pattern.compile("Your (?:TzTok-Jad|TzKal-Zuk) kill count is:");
    private static final Pattern TZHAAR_PAUSED_MESSAGE = Pattern.compile("The (?:Inferno|Fight Cave) has been paused. You may now log out.");

    @Inject
    protected ChatHandler(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        String message = e.getMessage();
        if (e.getType() != ChatMessageType.SPAM && e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (message.equals(TZHAAR_DEFEATED_MESSAGE)) {
            this.eventBus.post((Object)new RunCompletedEvent(WaveState.FAILED));
            this.eventBus.post((Object)new TimerStoppedEvent());
            return;
        }
        if (TZHAAR_COMPLETED_MESSAGE.matcher(message).find()) {
            this.eventBus.post((Object)new RunCompletedEvent(WaveState.SUCCESS));
            this.eventBus.post((Object)new TimerStoppedEvent());
            return;
        }
        if (TZHAAR_PAUSED_MESSAGE.matcher(message).find()) {
            this.eventBus.post((Object)new TimerPausedEvent());
            return;
        }
        if (message.equals(TZHAAR_WAVE_COMPLETED_MESSAGE)) {
            String waveMessage;
            this.eventBus.post((Object)new WaveFinishedEvent(WaveState.FINISHED));
            if (this.config.showIdleTicksInChatbox()) {
                waveMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Idle Ticks: " + this.plugin.getCurrentWave().getIdleTicks()).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(waveMessage).build());
            }
            if (this.config.waveTimes()) {
                waveMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Wave Completed in: " + TimeFormatting.getCurrentWaveTime(this.plugin.getCurrentWave())).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(waveMessage).build());
            }
            return;
        }
        Matcher matcher = TZHAAR_WAVE_MESSAGE.matcher(message);
        if (matcher.find()) {
            int waveId = Integer.parseInt(matcher.group(1));
            Wave wave = new Wave(waveId, this.plugin.getRunDuration());
            if (wave.getId() == 1) {
                wave.setDuration(0L);
                if (this.plugin.isInInferno()) {
                    this.eventBus.post((Object)new TimerStartedEvent(10));
                } else if (this.plugin.isInFightCaves()) {
                    this.eventBus.post((Object)new TimerStartedEvent(0));
                }
            } else if (this.config.tzhaarTimerState() == TimerHandler.TimerState.PAUSED) {
                this.eventBus.post((Object)new TimerStartedEvent(0));
            }
            if (this.plugin.isInInferno()) {
                wave.setLocation(Location.INFERNO);
            } else if (this.plugin.isInFightCaves()) {
                wave.setLocation(Location.FIGHT_CAVES);
            }
            this.eventBus.post((Object)new WaveStartedEvent(wave));
            if (this.config.splitTimes() && wave.isSplit()) {
                ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Wave Split: ").append(TimeFormatting.formatDuration(wave.start()));
                if (this.config.showTargetSplitTimes()) {
                    chatMessageBuilder.append(WaveSplit.GoalDifference(wave));
                }
                String splitMessage = chatMessageBuilder.build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(splitMessage).build());
            }
            if (this.config.predictedCompletionTime() && wave.isSplit()) {
                if (wave.getLocation() == Location.FIGHT_CAVES) {
                    return;
                }
                wave.setPace(WaveSplit.PredictedTime(wave));
                String predictedMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Predicted Time: " + TimeFormatting.formatDuration(wave.getPace())).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(predictedMessage).build());
            }
        }
    }
}

