/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.google.inject.Provides;
import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsOverlay;
import com.infernostats.InfernoStatsPanel;
import com.infernostats.InfernoStatsTimer;
import com.infernostats.controller.ChatHandler;
import com.infernostats.controller.TickLossHandler;
import com.infernostats.controller.TimerHandler;
import com.infernostats.controller.WaveHandler;
import com.infernostats.events.RunCompletedEvent;
import com.infernostats.events.TimerPausedEvent;
import com.infernostats.events.TimerStartedEvent;
import com.infernostats.events.TimerStoppedEvent;
import com.infernostats.events.WaveFinishedEvent;
import com.infernostats.events.WaveStartedEvent;
import com.infernostats.model.Wave;
import com.infernostats.model.WaveSplit;
import com.infernostats.model.WaveState;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inferno Stats", description="Track restoration specials during an inferno attempt.", tags={"combat", "npcs", "overlay"})
public class InfernoStatsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfernoStatsPlugin.class);
    private static final int INFERNO_REGION_ID = 9043;
    private static final int FIGHT_CAVES_REGION_ID = 9551;
    private InfernoStatsPanel panel;
    private NavigationButton navButton;
    @Inject
    private ChatHandler chatHandler;
    @Inject
    private TimerHandler timerHandler;
    @Inject
    private WaveHandler waveHandler;
    @Inject
    private TickLossHandler tickLossHandler;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfernoStatsOverlay overlay;
    @Inject
    private InfernoStatsConfig config;

    @Provides
    InfernoStatsConfig getConfig(ConfigManager configManager) {
        return (InfernoStatsConfig)configManager.getConfig(InfernoStatsConfig.class);
    }

    protected void startUp() {
        this.panel = (InfernoStatsPanel)((Object)this.injector.getInstance(InfernoStatsPanel.class));
        this.navButton = NavigationButton.builder().tooltip("Inferno Stats").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/blob-square.png")).priority(6).panel((PluginPanel)this.panel).build();
        if (this.isInInferno() || !this.config.hide()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        if (this.config.splitsOverlay()) {
            this.overlayManager.add((Overlay)this.overlay);
        }
        WaveSplit.UpdateTargetSplits(this.config);
        this.eventBus.register((Object)this.waveHandler);
        this.eventBus.register((Object)this.timerHandler);
        this.eventBus.register((Object)this.chatHandler);
        this.eventBus.register((Object)this.tickLossHandler);
        this.eventBus.register(TimerStartedEvent.class);
        this.eventBus.register(TimerPausedEvent.class);
        this.eventBus.register(TimerStoppedEvent.class);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientToolbar.removeNavigation(this.navButton);
        this.eventBus.unregister(TimerStartedEvent.class);
        this.eventBus.unregister(TimerPausedEvent.class);
        this.eventBus.unregister(TimerStoppedEvent.class);
        this.eventBus.unregister((Object)this.tickLossHandler);
        this.eventBus.unregister((Object)this.chatHandler);
        this.eventBus.unregister((Object)this.timerHandler);
        this.eventBus.unregister((Object)this.waveHandler);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("InfernoConfig")) {
            return;
        }
        switch (event.getKey()) {
            case "hide": {
                this.resetNav();
                break;
            }
            case "showInfernoTimer": 
            case "showFightCavesTimer": {
                this.createTimer();
                break;
            }
            case "splitsOverlay": {
                if (this.config.splitsOverlay()) {
                    this.overlayManager.add((Overlay)this.overlay);
                    break;
                }
                this.overlayManager.remove((Overlay)this.overlay);
            }
        }
        WaveSplit.UpdateTargetSplits(this.config);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case LOADING: {
                if (this.timerHandler.getState() == TimerHandler.TimerState.RUNNING && !this.isInFightCaves() && !this.isInInferno()) {
                    this.eventBus.post((Object)new TimerStoppedEvent());
                    this.eventBus.post((Object)new RunCompletedEvent(WaveState.FAILED));
                }
                this.resetNav();
                break;
            }
            case LOGIN_SCREEN: 
            case HOPPING: {
                if (this.timerHandler.getState() != TimerHandler.TimerState.RUNNING) break;
                this.eventBus.post((Object)new TimerPausedEvent());
            }
        }
    }

    @Subscribe
    protected void onGameTick(GameTick e) {
        if (this.isInInferno() || this.isInFightCaves()) {
            this.panel.UpdateWave();
        }
    }

    @Subscribe
    protected void onWaveStartedEvent(WaveStartedEvent e) {
        Wave wave = e.getWave();
        if (wave.getId() == 1) {
            this.panel.ClearWaves();
        }
        this.panel.AddWave(wave);
    }

    @Subscribe
    protected void onWaveFinishedEvent(WaveFinishedEvent e) {
        this.panel.UpdateWave();
    }

    @Subscribe
    protected void onRunCompletedEvent(RunCompletedEvent e) {
        Wave wave = this.getCurrentWave();
        wave.setState(e.getState());
        this.panel.UpdateWave();
        this.waveHandler.WriteWaves();
    }

    @Subscribe
    protected void onTimerStartedEvent(TimerStartedEvent e) {
        this.createTimer();
    }

    @Subscribe
    protected void onTimerStoppedEvent(TimerStoppedEvent e) {
        this.removeTimer();
        this.overlay.reset();
    }

    private void resetNav() {
        if (this.isInInferno() || !this.config.hide()) {
            this.clientToolbar.addNavigation(this.navButton);
        } else {
            this.clientToolbar.removeNavigation(this.navButton);
        }
    }

    private void createTimer() {
        this.removeTimer();
        if (this.config.showFightCavesTimer() && this.isInFightCaves()) {
            this.infoBoxManager.addInfoBox((InfoBox)new InfernoStatsTimer((BufferedImage)this.itemManager.getImage(6570), this));
        } else if (this.config.showInfernoTimer() && this.isInInferno()) {
            this.infoBoxManager.addInfoBox((InfoBox)new InfernoStatsTimer((BufferedImage)this.itemManager.getImage(21295), this));
        }
    }

    private void removeTimer() {
        this.infoBoxManager.removeIf(InfernoStatsTimer.class::isInstance);
    }

    public Wave getCurrentWave() {
        return this.waveHandler.getWave();
    }

    public ArrayList<Wave> getWaves() {
        return this.waveHandler.getWaves();
    }

    public TimerHandler.TimerState getTimerState() {
        return this.timerHandler.getState();
    }

    public long getRunDuration() {
        return this.timerHandler.getDuration();
    }

    public boolean isInInferno() {
        return this.client.getMapRegions() != null && ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9043);
    }

    public boolean isInFightCaves() {
        return this.client.getMapRegions() != null && ArrayUtils.contains((int[])this.client.getMapRegions(), (int)9551);
    }

    InfernoStatsPanel getPanel() {
        return this.panel;
    }

    NavigationButton getNavButton() {
        return this.navButton;
    }
}

