/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.model.Wave;
import com.infernostats.view.TitlePanel;
import com.infernostats.view.WaveListContainer;
import com.infernostats.view.WaveListPanel;
import com.infernostats.view.WaveSplitsPanel;
import com.infernostats.view.WaveStatsPanel;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;

public class InfernoStatsPanel
extends PluginPanel {
    private WaveStatsPanel waveStatsPanel;
    private final TitlePanel titlePanel = new TitlePanel();
    private final WaveSplitsPanel waveSplitsPanel = new WaveSplitsPanel();
    private final WaveListPanel waveListPanel = new WaveListPanel();
    private final WaveListContainer waveListContainer = new WaveListContainer(this.waveListPanel);
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;

    @Inject
    private InfernoStatsPanel(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.add(this.titlePanel, "North", 0);
        this.add(this.waveSplitsPanel, "Center", 1);
        this.add(this.waveListContainer, "South", 2);
        this.waveSplitsPanel.setWaves(this.plugin.getWaves());
    }

    void AddWave(Wave wave) {
        SwingUtilities.invokeLater(() -> {
            this.waveStatsPanel = new WaveStatsPanel(this.config, wave);
            this.waveListPanel.add((Component)this.waveStatsPanel, 0);
            this.updateUI();
        });
    }

    void UpdateWave() {
        if (this.waveStatsPanel == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.waveStatsPanel.update());
    }

    public void ClearWaves() {
        this.waveListPanel.removeAll();
        this.waveListPanel.validate();
        this.waveListPanel.repaint();
    }

    WaveStatsPanel getWaveStatsPanel() {
        return this.waveStatsPanel;
    }

    TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    WaveSplitsPanel getWaveSplitsPanel() {
        return this.waveSplitsPanel;
    }

    WaveListPanel getWaveListPanel() {
        return this.waveListPanel;
    }

    WaveListContainer getWaveListContainer() {
        return this.waveListContainer;
    }

    InfernoStatsPlugin getPlugin() {
        return this.plugin;
    }

    InfernoStatsConfig getConfig() {
        return this.config;
    }
}

