/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.infernostats.InfernoStatsConfig;
import com.infernostats.InfernoStatsPlugin;
import com.infernostats.controller.TimerHandler;
import com.infernostats.model.Location;
import com.infernostats.model.Wave;
import com.infernostats.view.TimeFormatting;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class InfernoStatsOverlay
extends OverlayPanel {
    private Wave prevSplitWave;
    private final InfernoStatsPlugin plugin;
    private final InfernoStatsConfig config;

    @Inject
    private InfernoStatsOverlay(InfernoStatsPlugin plugin, InfernoStatsConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.prevSplitWave = null;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInInferno() && !this.plugin.isInFightCaves()) {
            return null;
        }
        this.panelComponent.getChildren().clear();
        Wave wave = this.plugin.getCurrentWave();
        if (wave == null) {
            return null;
        }
        if (this.plugin.getTimerState() != TimerHandler.TimerState.RUNNING) {
            return null;
        }
        String header = "Current Wave: " + wave.getId();
        LinkedHashMap<String, String> contents = new LinkedHashMap<String, String>();
        if (wave.isSplit()) {
            this.prevSplitWave = wave;
        }
        if (this.prevSplitWave != null) {
            if (this.config.splitTimes()) {
                contents.put("Wave " + this.prevSplitWave.getId() + " Split: ", TimeFormatting.getSplitTime(this.prevSplitWave));
            }
            if (this.prevSplitWave.getLocation() == Location.INFERNO && this.config.predictedCompletionTime() && this.prevSplitWave.getPace() != null) {
                contents.put("Predicted Time: ", TimeFormatting.formatDuration(this.prevSplitWave.getPace()));
            }
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text(header).color(ColorScheme.BRAND_ORANGE).build());
        this.panelComponent.setPreferredSize(new Dimension(this.getMaxWidth(graphics, contents, header) + 10, 0));
        for (Map.Entry<String, String> pair : contents.entrySet()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(pair.getKey()).right(pair.getValue()).build());
        }
        return super.render(graphics);
    }

    private int getMaxWidth(Graphics2D graphics, HashMap<String, String> contents, String header) {
        if (contents.isEmpty()) {
            return graphics.getFontMetrics().stringWidth(header);
        }
        Map.Entry longestPair = Collections.max(contents.entrySet(), Comparator.comparingInt(this::keyValueLength));
        return graphics.getFontMetrics().stringWidth((String)longestPair.getKey()) + graphics.getFontMetrics().stringWidth((String)longestPair.getValue());
    }

    private int keyValueLength(Map.Entry<String, String> entry) {
        return entry.getKey().length() + entry.getValue().length();
    }

    public void reset() {
        this.prevSplitWave = null;
    }
}

