/*
 * Decompiled with CFR 0.152.
 */
package com.osrskillboard;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.osrskillboard.OsrsKillboardClient;
import com.osrskillboard.OsrsKillboardConfig;
import com.osrskillboard.OsrsKillboardItem;
import com.osrskillboard.OsrsKillboardPanel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="OsrsKillboard", description="Tracks loot from killing players", tags={"drops", "pvp"}, enabledByDefault=true)
public class OsrsKillboardPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(OsrsKillboardPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OsrsKillboardConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    private OsrsKillboardPanel panel;
    private NavigationButton navButton;
    private boolean chestLooted;
    @Inject
    private OsrsKillboardClient osrsKillboardClient;

    @Provides
    OsrsKillboardConfig provideConfig(ConfigManager configManager) {
        return (OsrsKillboardConfig)configManager.getConfig(OsrsKillboardConfig.class);
    }

    private static Collection<ItemStack> stack(Collection<ItemStack> items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            int quantity = 0;
            for (ItemStack i : list) {
                if (i.getId() != item.getId()) continue;
                quantity = i.getQuantity();
                list.remove(i);
                break;
            }
            if (quantity > 0) {
                list.add(new ItemStack(item.getId(), item.getQuantity() + quantity, item.getLocation()));
                continue;
            }
            list.add(item);
        }
        return list;
    }

    protected void startUp() {
        log.info("OsrsKillboard started!");
        this.panel = new OsrsKillboardPanel(this, this.itemManager, this.config);
        this.spriteManager.getSpriteAsync(439, 0, this.panel::loadHeaderIcon);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("OsrsKillboard").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        log.info("OsrsKillboard stopped!");
        this.clientToolbar.removeNavigation(this.navButton);
        this.chestLooted = false;
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) throws IOException {
        if (this.isPlayerInSafeMinigame()) {
            return;
        }
        Player victim = playerLootReceived.getPlayer();
        Collection items = playerLootReceived.getItems();
        String victimName = victim.getName();
        int victimCombat = victim.getCombatLevel();
        OsrsKillboardItem[] victimLoot = this.buildEntries(OsrsKillboardPlugin.stack(items));
        JsonObject killJson = this.buildKillJson(victim, victimLoot);
        this.osrsKillboardClient.submitPk(killJson, this.panel, victimName, victimCombat, victimLoot);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING && !this.client.isInInstancedRegion()) {
            this.chestLooted = false;
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        ItemContainer container;
        String event;
        Object metadata = null;
        switch (widgetLoaded.getGroupId()) {
            case 742: {
                if (this.chestLooted) {
                    return;
                }
                event = "Loot Chest";
                container = this.client.getItemContainer(InventoryID.WILDERNESS_LOOT_CHEST);
                this.chestLooted = true;
                break;
            }
            default: {
                return;
            }
        }
        if (container == null) {
            return;
        }
        Collection items = Arrays.stream(container.getItems()).filter(item -> item.getId() > 0).map(item -> new ItemStack(item.getId(), item.getQuantity(), this.client.getLocalPlayer().getLocalLocation())).collect(Collectors.toList());
        OsrsKillboardItem[] chestLoot = this.buildEntries(OsrsKillboardPlugin.stack(items));
        if (items.isEmpty()) {
            log.debug("No items to find for Event: {} | Container: {}", (Object)event, (Object)container);
            return;
        }
        JsonObject keyJson = this.buildKeyJson(chestLoot);
        this.osrsKillboardClient.submitKeyLoot(keyJson, this.panel, chestLoot);
    }

    private JsonObject buildKillJson(Player victim, OsrsKillboardItem[] lootItems) {
        JsonObject killJson = new JsonObject();
        Player pker = this.client.getLocalPlayer();
        OffsetDateTime utc = OffsetDateTime.now(ZoneOffset.UTC);
        killJson.addProperty("time", DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        killJson.addProperty("world", (Number)this.client.getWorld());
        killJson.addProperty("worldType", this.client.getWorldType().toString());
        killJson.addProperty("localLocation", pker.getLocalLocation().toString());
        killJson.addProperty("worldLocation", pker.getWorldLocation().toString());
        killJson.addProperty("pkerName", pker.getName());
        killJson.addProperty("pkerAccountType", this.client.getAccountType().toString());
        killJson.addProperty("pkerCombatLevel", (Number)pker.getCombatLevel());
        killJson.add("pkerItemsEquipped", (JsonElement)this.getEquippedGearForPlayer(pker));
        killJson.addProperty("pkerIsSkulled", Boolean.valueOf(this.isPlayerSkulled(pker)));
        killJson.add("pkerCombatStats", (JsonElement)this.getPlayerSkillsList());
        killJson.addProperty("victimName", victim.getName());
        killJson.addProperty("victimCombatLevel", (Number)victim.getCombatLevel());
        killJson.add("victimItemsEquipped", (JsonElement)this.getEquippedGearForPlayer(victim));
        killJson.addProperty("victimIsSkulled", Boolean.valueOf(this.isPlayerSkulled(victim)));
        killJson.add("loot", (JsonElement)this.getLootAsJson(lootItems));
        killJson.addProperty("lootValue", (Number)this.getLootValue(lootItems));
        killJson.addProperty("victimIsFriend", Boolean.valueOf(victim.isFriend()));
        killJson.addProperty("victimIsClanMember", Boolean.valueOf(victim.isFriendsChatMember()));
        return killJson;
    }

    private JsonObject buildKeyJson(OsrsKillboardItem[] lootItems) {
        JsonObject keyJson = new JsonObject();
        Player pker = this.client.getLocalPlayer();
        OffsetDateTime utc = OffsetDateTime.now(ZoneOffset.UTC);
        keyJson.addProperty("time", DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        keyJson.addProperty("world", (Number)this.client.getWorld());
        keyJson.addProperty("worldType", this.client.getWorldType().toString());
        keyJson.addProperty("localLocation", pker.getLocalLocation().toString());
        keyJson.addProperty("worldLocation", pker.getWorldLocation().toString());
        keyJson.addProperty("pkerName", pker.getName());
        keyJson.addProperty("pkerAccountType", this.client.getAccountType().toString());
        keyJson.add("loot", (JsonElement)this.getLootAsJson(lootItems));
        keyJson.addProperty("lootValue", (Number)this.getLootValue(lootItems));
        return keyJson;
    }

    private boolean isPlayerSkulled(Player player) {
        boolean isSkulled = false;
        if (player.getSkullIcon() != null) {
            isSkulled = true;
        }
        return isSkulled;
    }

    private JsonObject getPlayerSkillsList() {
        JsonObject skillJson = new JsonObject();
        skillJson.addProperty("attack", (Number)this.client.getRealSkillLevel(Skill.ATTACK));
        skillJson.addProperty("strength", (Number)this.client.getRealSkillLevel(Skill.STRENGTH));
        skillJson.addProperty("defence", (Number)this.client.getRealSkillLevel(Skill.DEFENCE));
        skillJson.addProperty("hitpoints", (Number)this.client.getRealSkillLevel(Skill.HITPOINTS));
        skillJson.addProperty("prayer", (Number)this.client.getRealSkillLevel(Skill.PRAYER));
        skillJson.addProperty("magic", (Number)this.client.getRealSkillLevel(Skill.MAGIC));
        skillJson.addProperty("ranged", (Number)this.client.getRealSkillLevel(Skill.RANGED));
        return skillJson;
    }

    private JsonArray getLootAsJson(OsrsKillboardItem[] lootItems) {
        JsonArray lootArray = new JsonArray();
        for (OsrsKillboardItem item : lootItems) {
            lootArray.add((JsonElement)this.buildLootItem(item));
        }
        return lootArray;
    }

    private JsonObject buildLootItem(OsrsKillboardItem item) {
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("id", (Number)item.getId());
        itemJson.addProperty("name", item.getName());
        itemJson.addProperty("qty", (Number)item.getQuantity());
        itemJson.addProperty("price", (Number)item.getGePrice());
        return itemJson;
    }

    private int getLootValue(OsrsKillboardItem[] lootItems) {
        int lootValue = 0;
        for (OsrsKillboardItem item : lootItems) {
            lootValue = (int)((long)lootValue + item.getGePrice());
        }
        return lootValue;
    }

    private OsrsKillboardItem buildOsrsKillboardItem(int itemId, int quantity) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        long price = (long)this.itemManager.getItemPrice(realItemId) * (long)quantity;
        return new OsrsKillboardItem(itemId, itemComposition.getName(), quantity, price);
    }

    private JsonObject getEquippedGearForPlayer(Player player) {
        ArrayList<Integer> equipmentIds = new ArrayList<Integer>();
        PlayerComposition playerComposition = player.getPlayerComposition();
        equipmentIds.add(playerComposition.getEquipmentId(KitType.HEAD));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.TORSO));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.LEGS));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.BOOTS));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.HANDS));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.SHIELD));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.WEAPON));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.AMULET));
        equipmentIds.add(playerComposition.getEquipmentId(KitType.CAPE));
        ArrayList<OsrsKillboardItem> realItemList = new ArrayList<OsrsKillboardItem>();
        Iterator iterator = equipmentIds.iterator();
        while (iterator.hasNext()) {
            int equipmentId = (Integer)iterator.next();
            OsrsKillboardItem newItem = this.buildOsrsKillboardItem(equipmentId, 1);
            realItemList.add(newItem);
        }
        OsrsKillboardItem[] equipmentArrayList = realItemList.toArray(new OsrsKillboardItem[realItemList.size()]);
        return this.getEquippedGearAsJson(equipmentArrayList);
    }

    private JsonObject getEquippedGearAsJson(OsrsKillboardItem[] equippedItems) {
        String[] equipmentSlots = new String[]{"Head", "Torso", "Legs", "Boots", "Hands", "Shield", "Weapon", "Amulet", "Cape"};
        JsonObject equipment = new JsonObject();
        for (int i = 0; i < equipmentSlots.length; ++i) {
            equipment.add(equipmentSlots[i], (JsonElement)this.buildLootItem(equippedItems[i]));
        }
        return equipment;
    }

    private OsrsKillboardItem[] buildEntries(Collection<ItemStack> itemStacks) {
        return (OsrsKillboardItem[])itemStacks.stream().map(itemStack -> this.buildOsrsKillboardItem(itemStack.getId(), itemStack.getQuantity())).toArray(OsrsKillboardItem[]::new);
    }

    private boolean isPlayerInSafeMinigame() {
        ImmutableSet SOUL_WARS_REGIONS = ImmutableSet.of((Object)8493, (Object)8749, (Object)9005);
        ImmutableSet LAST_MAN_STANDING_REGIONS = ImmutableSet.of((Object)13658, (Object)13659, (Object)13660, (Object)13914, (Object)13915, (Object)13916, (Object[])new Integer[]{13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432});
        boolean playerInSafeMinigame = false;
        if (this.isPlayerWithinMapRegion((Set<Integer>)LAST_MAN_STANDING_REGIONS) || this.isPlayerWithinMapRegion((Set<Integer>)SOUL_WARS_REGIONS)) {
            playerInSafeMinigame = true;
        }
        return playerInSafeMinigame;
    }

    private boolean isPlayerWithinMapRegion(Set<Integer> definedMapRegions) {
        int[] mapRegions;
        for (int region : mapRegions = this.client.getMapRegions()) {
            if (!definedMapRegions.contains(region)) continue;
            return true;
        }
        return false;
    }

    static void openOsrsKillboardLink(String killId) {
        LinkBrowser.browse((String)OsrsKillboardPlugin.GetKillUrl(killId));
    }

    static String GetKillUrl(String killId) {
        Object url = "https://osrskillboard.com";
        if (StringUtils.isNotEmpty((CharSequence)killId)) {
            url = "https://osrskillboard.com/pks/" + killId;
        }
        return url;
    }

    OsrsKillboardClient getOsrsKillboardClient() {
        return this.osrsKillboardClient;
    }
}

