/*
 * Decompiled with CFR 0.152.
 */
package com.osrskillboard;

import com.osrskillboard.OsrsKillboardBox;
import com.osrskillboard.OsrsKillboardClient;
import com.osrskillboard.OsrsKillboardConfig;
import com.osrskillboard.OsrsKillboardItem;
import com.osrskillboard.OsrsKillboardPlugin;
import com.osrskillboard.OsrsKillboardRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;

class OsrsKillboardPanel
extends PluginPanel {
    private static final int MAX_LOOT_BOXES = 500;
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel logsContainer = new JPanel();
    private final JPanel overallPanel = new JPanel();
    private final JLabel overallKillsLabel = new JLabel();
    private final JLabel overallGpLabel = new JLabel();
    private final JLabel overallIcon = new JLabel();
    private final JPanel actionsContainer = new JPanel();
    private final JLabel detailsTitle = new JLabel();
    private final List<OsrsKillboardRecord> records = new ArrayList<OsrsKillboardRecord>();
    private final List<OsrsKillboardBox> boxes = new ArrayList<OsrsKillboardBox>();
    private final ItemManager itemManager;
    private final OsrsKillboardPlugin plugin;
    private final OsrsKillboardConfig config;
    private String currentView;

    OsrsKillboardPanel(OsrsKillboardPlugin plugin, ItemManager itemManager, OsrsKillboardConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        this.add(layoutPanel, "North");
        JPanel leftTitleContainer = new JPanel(new BorderLayout(5, 0));
        leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.detailsTitle.setForeground(Color.WHITE);
        leftTitleContainer.add((Component)this.detailsTitle, "Center");
        this.actionsContainer.add((Component)leftTitleContainer, "West");
        this.overallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        this.overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overallPanel.setLayout(new BorderLayout());
        this.overallPanel.setVisible(false);
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout(new GridLayout(2, 1));
        overallInfo.setBorder(new EmptyBorder(2, 10, 2, 0));
        this.overallKillsLabel.setFont(FontManager.getRunescapeSmallFont());
        this.overallGpLabel.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.overallKillsLabel);
        overallInfo.add(this.overallGpLabel);
        this.overallPanel.add((Component)this.overallIcon, "West");
        this.overallPanel.add((Component)overallInfo, "Center");
        JMenuItem reset = new JMenuItem("Reset All");
        reset.addActionListener(e -> {
            this.records.removeIf(r -> r.matches(this.currentView));
            this.boxes.removeIf(b -> b.matches(this.currentView));
            this.updateOverall();
            this.logsContainer.removeAll();
            this.logsContainer.repaint();
            OsrsKillboardClient client = plugin.getOsrsKillboardClient();
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(reset);
        this.overallPanel.setComponentPopupMenu(popupMenu);
        this.logsContainer.setLayout(new BoxLayout(this.logsContainer, 1));
        layoutPanel.add(this.actionsContainer);
        layoutPanel.add(this.overallPanel);
        layoutPanel.add(this.logsContainer);
        this.errorPanel.setContent("OSRS Killboard", "You haven't killed any players yet.");
        this.add((Component)this.errorPanel);
    }

    void loadHeaderIcon(BufferedImage img) {
        this.overallIcon.setIcon(new ImageIcon(img));
    }

    void add(String eventName, int actorLevel, OsrsKillboardItem[] items, String killId) {
        Object subTitle = actorLevel > -1 ? "(lvl-" + actorLevel + ")" : "";
        OsrsKillboardRecord record = new OsrsKillboardRecord(eventName, (String)subTitle, items, System.currentTimeMillis(), killId);
        this.records.add(record);
        OsrsKillboardBox box = this.buildBox(record);
        if (box != null) {
            box.rebuild();
            this.updateOverall();
        }
    }

    void addRecords(Collection<OsrsKillboardRecord> recs) {
        this.records.addAll(recs);
        this.rebuild();
    }

    private void rebuild() {
        this.logsContainer.removeAll();
        this.boxes.clear();
        int start = 0;
        if (this.records.size() > 500) {
            start = this.records.size() - 500;
        }
        for (int i = start; i < this.records.size(); ++i) {
            this.buildBox(this.records.get(i));
        }
        this.boxes.forEach(OsrsKillboardBox::rebuild);
        this.updateOverall();
        this.logsContainer.revalidate();
        this.logsContainer.repaint();
    }

    private OsrsKillboardBox buildBox(OsrsKillboardRecord record) {
        if (!record.matches(this.currentView)) {
            return null;
        }
        this.remove((Component)this.errorPanel);
        this.actionsContainer.setVisible(true);
        this.overallPanel.setVisible(true);
        OsrsKillboardBox box = new OsrsKillboardBox(this.itemManager, record.getTitle(), record.getSubTitle());
        box.combine(record);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        box.setComponentPopupMenu(popupMenu);
        JMenuItem reset = new JMenuItem("Reset");
        reset.addActionListener(e -> {
            this.records.removeAll(box.getRecords());
            this.boxes.remove(box);
            this.updateOverall();
            this.logsContainer.remove(box);
            this.logsContainer.repaint();
        });
        popupMenu.add(reset);
        if (!record.getOsrsKillboardKillId().equals("") || record.getTitle() != "PvP Loot Chest") {
            JMenuItem openOsrsKillboardLink = new JMenuItem("Open on OSRSKillboard.com");
            openOsrsKillboardLink.addActionListener(e -> OsrsKillboardPlugin.openOsrsKillboardLink(record.getOsrsKillboardKillId()));
            popupMenu.add(openOsrsKillboardLink);
            JMenuItem copyOsrsKillboardLink = new JMenuItem("Copy kill link");
            String killUrl = OsrsKillboardPlugin.GetKillUrl(record.getOsrsKillboardKillId());
            StringSelection osrsKillboardLink = new StringSelection(killUrl);
            copyOsrsKillboardLink.addActionListener(e -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(osrsKillboardLink, null));
            popupMenu.add(copyOsrsKillboardLink);
        }
        this.boxes.add(box);
        this.logsContainer.add((Component)box, 0);
        if (this.boxes.size() > 500) {
            this.logsContainer.remove(this.boxes.remove(0));
        }
        return box;
    }

    private void updateOverall() {
        long overallKills = 0L;
        long overallGp = 0L;
        for (OsrsKillboardRecord record : this.records) {
            if (!record.matches(this.currentView)) continue;
            int present = record.getItems().length;
            for (OsrsKillboardItem item : record.getItems()) {
                overallGp += item.getGePrice();
            }
            if (present <= 0) continue;
            ++overallKills;
        }
        this.overallKillsLabel.setText(OsrsKillboardPanel.htmlLabel("Total count: ", overallKills));
        this.overallGpLabel.setText(OsrsKillboardPanel.htmlLabel("Total value: ", overallGp));
    }

    private static String htmlLabel(String key, long value) {
        String valueStr = QuantityFormatter.quantityToStackSize((long)value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }
}

