/*
 * Decompiled with CFR 0.152.
 */
package com.osrskillboard;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.osrskillboard.OsrsKillboardItem;
import com.osrskillboard.OsrsKillboardPanel;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsrsKillboardClient {
    private static final Logger log = LoggerFactory.getLogger(OsrsKillboardClient.class);
    private final OkHttpClient httpClient;
    private static final HttpUrl apiBase = HttpUrl.parse((String)"https://api.osrskillboard.com/");
    @Inject
    private ChatMessageManager chatMessageManager;

    @Inject
    private OsrsKillboardClient(OkHttpClient client, Gson gson) {
        this.httpClient = client;
    }

    public CompletableFuture<Void> submitPk(JsonObject killRecord, final OsrsKillboardPanel panel, final String victimName, final int victimCombat, final OsrsKillboardItem[] victimLoot) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl url = apiBase.newBuilder().addPathSegment("pks").build();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        Request requestBuilder = new Request.Builder().post(RequestBody.create((MediaType)JSON, (String)killRecord.toString())).url(url).build();
        this.httpClient.newCall(requestBuilder).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OsrsKillboardClient.this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("OSRSKillboard.com - Kill of " + victimName + " failed to log.").build());
                SwingUtilities.invokeLater(() -> panel.add(victimName, victimCombat, victimLoot, ""));
                log.warn("unable to submit pk", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                String killIdentifier = null;
                try {
                    assert (response.body() != null);
                    killIdentifier = response.body().string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    response.close();
                }
                OsrsKillboardClient.this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("OSRSKillboard.com - Kill of " + victimName + " logged.").build());
                String finalKillIdentifier = killIdentifier;
                SwingUtilities.invokeLater(() -> {
                    panel.add(victimName, victimCombat, victimLoot, finalKillIdentifier);
                    future.complete(null);
                });
            }
        });
        return future;
    }

    public CompletableFuture<Void> submitKeyLoot(JsonObject keyJson, final OsrsKillboardPanel panel, final OsrsKillboardItem[] keyLoot) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        HttpUrl url = apiBase.newBuilder().addPathSegment("lootkeys").build();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        Request requestBuilder = new Request.Builder().post(RequestBody.create((MediaType)JSON, (String)keyJson.toString())).url(url).build();
        this.httpClient.newCall(requestBuilder).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OsrsKillboardClient.this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("OSRSKillboard.com - PvP Loot Chest opening failed to log.").build());
                SwingUtilities.invokeLater(() -> panel.add("PvP Loot Chest", -2, keyLoot, ""));
                log.warn("unable to submit PVP Loot Chest", (Throwable)e);
            }

            public void onResponse(Call call, Response response) {
                String killIdentifier = null;
                try {
                    assert (response.body() != null);
                    killIdentifier = response.body().string();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    response.close();
                }
                OsrsKillboardClient.this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).value("OSRSKillboard.com - PvP Loot Chest opening logged.").build());
                String serverKeyId = killIdentifier;
                SwingUtilities.invokeLater(() -> {
                    panel.add("PvP Loot Chest", -2, keyLoot, serverKeyId);
                    future.complete(null);
                });
            }
        });
        return future;
    }
}

