/*
 * Decompiled with CFR 0.152.
 */
package com.osrskillboard;

import com.google.common.base.Strings;
import com.osrskillboard.OsrsKillboardItem;
import com.osrskillboard.OsrsKillboardRecord;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;

class OsrsKillboardBox
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private final JPanel itemContainer = new JPanel();
    private final JLabel priceLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final ItemManager itemManager;
    private final String id;
    private final List<OsrsKillboardRecord> records = new ArrayList<OsrsKillboardRecord>();
    private long totalPrice;
    private boolean hideIgnoredItems;
    private BiConsumer<String, Boolean> onItemToggle;

    OsrsKillboardBox(ItemManager itemManager, String id, @Nullable String subtitle) {
        this.id = id;
        this.itemManager = itemManager;
        this.onItemToggle = this.onItemToggle;
        this.hideIgnoredItems = this.hideIgnoredItems;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel logTitle = new JPanel(new BorderLayout(5, 0));
        logTitle.setBorder(new EmptyBorder(7, 7, 7, 7));
        logTitle.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel titleLabel = new JLabel(Text.removeTags((String)id));
        titleLabel.setFont(FontManager.getRunescapeSmallFont());
        titleLabel.setForeground(Color.WHITE);
        logTitle.add((Component)titleLabel, "West");
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.subTitleLabel, "Center");
        if (!Strings.isNullOrEmpty((String)subtitle)) {
            this.subTitleLabel.setText(subtitle);
        }
        this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
        this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        logTitle.add((Component)this.priceLabel, "East");
        this.add((Component)logTitle, "North");
        this.add((Component)this.itemContainer, "Center");
    }

    private long getTotalKills() {
        return this.records.size();
    }

    boolean matches(OsrsKillboardRecord record) {
        return record.getTitle().equals(this.id);
    }

    boolean matches(String id) {
        if (id == null) {
            return true;
        }
        return this.id.equals(id);
    }

    void combine(OsrsKillboardRecord record) {
        if (!this.matches(record)) {
            throw new IllegalArgumentException(record.toString());
        }
        this.records.add(record);
    }

    void rebuild() {
        this.buildItems();
        String priceTypeString = " ";
        this.priceLabel.setText(QuantityFormatter.quantityToStackSize((long)this.totalPrice) + " gp");
        this.priceLabel.setToolTipText(QuantityFormatter.formatNumber((long)this.totalPrice) + " gp");
        long kills = this.getTotalKills();
        if (kills > 1L) {
            this.subTitleLabel.setText("x " + kills);
        }
        this.validate();
        this.repaint();
    }

    private void buildItems() {
        ArrayList<OsrsKillboardItem> allItems = new ArrayList<OsrsKillboardItem>();
        ArrayList<OsrsKillboardItem> items = new ArrayList<OsrsKillboardItem>();
        this.totalPrice = 0L;
        for (OsrsKillboardRecord record : this.records) {
            allItems.addAll(Arrays.asList(record.getItems()));
        }
        for (OsrsKillboardItem entry : allItems) {
            this.totalPrice += entry.getGePrice();
            int quantity = 0;
            for (OsrsKillboardItem i : items) {
                if (i.getId() != entry.getId()) continue;
                quantity = i.getQuantity();
                items.remove(i);
                break;
            }
            if (quantity > 0) {
                int newQuantity = entry.getQuantity() + quantity;
                long pricePerItem = entry.getGePrice() == 0L ? 0L : entry.getGePrice() / (long)entry.getQuantity();
                items.add(new OsrsKillboardItem(entry.getId(), entry.getName(), newQuantity, pricePerItem * (long)newQuantity));
                continue;
            }
            items.add(entry);
        }
        items.sort((i1, i2) -> Long.compare(i2.getGePrice(), i1.getGePrice()));
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.itemContainer.removeAll();
        this.itemContainer.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (int i = 0; i < rowSize * 5; ++i) {
            JPanel slotContainer = new JPanel();
            slotContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (i < items.size()) {
                OsrsKillboardItem item = (OsrsKillboardItem)items.get(i);
                JLabel imageLabel = new JLabel();
                imageLabel.setToolTipText(OsrsKillboardBox.buildToolTip(item));
                imageLabel.setVerticalAlignment(0);
                imageLabel.setHorizontalAlignment(0);
                AsyncBufferedImage itemImage = this.itemManager.getImage(item.getId(), item.getQuantity(), item.getQuantity() > 1);
                itemImage.addTo(imageLabel);
                slotContainer.add(imageLabel);
            }
            this.itemContainer.add(slotContainer);
        }
        this.itemContainer.repaint();
    }

    private static String buildToolTip(OsrsKillboardItem item) {
        String name = item.getName();
        int quantity = item.getQuantity();
        long price = item.getGePrice();
        return name + " x " + quantity + " (" + QuantityFormatter.quantityToStackSize((long)price) + ") ";
    }

    String getId() {
        return this.id;
    }

    public List<OsrsKillboardRecord> getRecords() {
        return this.records;
    }
}

