/*
 * Decompiled with CFR 0.152.
 */
package com.molopl.plugins.lifesaving;

import com.google.inject.Provides;
import com.molopl.plugins.lifesaving.LifeSavingConfig;
import com.molopl.plugins.lifesaving.LifeSavingInfoBox;
import com.molopl.plugins.lifesaving.LifeSavingItem;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Life-Saving Jewellery", description="Infoboxes and notifications for Phoenix necklace and Ring of life", tags={"phoenix", "necklace", "ring", "life"})
public class LifeSavingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LifeSavingPlugin.class);
    private static final String RING_OF_LIFE_USED_MSG = "Your Ring of Life saves you and is destroyed in the process.";
    private static final String PHOENIX_NECKLACE_USED_MSG = "Your phoenix necklace heals you, but is destroyed in the process.";
    @Inject
    private Client client;
    @Inject
    private LifeSavingConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientThread clientThread;

    @Provides
    public LifeSavingConfig provideConfig(ConfigManager configManager) {
        return (LifeSavingConfig)configManager.getConfig(LifeSavingConfig.class);
    }

    public void startUp() {
    }

    public void shutDown() {
        this.infoBoxManager.removeIf(LifeSavingInfoBox.class::isInstance);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("lifeSavingJewellery")) {
            return;
        }
        if (!this.config.ringOfLifeInfobox()) {
            this.removeInfobox(LifeSavingItem.RING_OF_LIFE);
        }
        if (!this.config.phoenixNecklaceInfobox()) {
            this.removeInfobox(LifeSavingItem.PHOENIX_NECKLACE);
        }
        this.clientThread.invokeLater(() -> {
            ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
            if (itemContainer == null) {
                return;
            }
            Item[] items = itemContainer.getItems();
            this.updateInfobox(this.config.ringOfLifeInfobox(), LifeSavingItem.RING_OF_LIFE, items);
            this.updateInfobox(this.config.phoenixNecklaceInfobox(), LifeSavingItem.PHOENIX_NECKLACE, items);
        });
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String message = event.getMessage();
        this.checkNotification(this.config.ringOfLifeNotification(), LifeSavingItem.RING_OF_LIFE, message, RING_OF_LIFE_USED_MSG);
        this.checkNotification(this.config.phoenixNecklaceNotification(), LifeSavingItem.PHOENIX_NECKLACE, message, PHOENIX_NECKLACE_USED_MSG);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            return;
        }
        Item[] items = event.getItemContainer().getItems();
        this.updateInfobox(this.config.ringOfLifeInfobox(), LifeSavingItem.RING_OF_LIFE, items);
        this.updateInfobox(this.config.phoenixNecklaceInfobox(), LifeSavingItem.PHOENIX_NECKLACE, items);
    }

    private void updateInfobox(boolean enabled, LifeSavingItem type, Item[] wornItems) {
        if (!enabled) {
            return;
        }
        this.removeInfobox(type);
        int itemId = type.getItemId();
        int slotIdx = type.getSlot().getSlotIdx();
        if (wornItems.length <= slotIdx) {
            return;
        }
        Item wornItem = wornItems[slotIdx];
        if (wornItem.getId() != itemId) {
            return;
        }
        String name = this.itemManager.getItemComposition(itemId).getName();
        AsyncBufferedImage image = this.itemManager.getImage(itemId);
        LifeSavingInfoBox infobox = new LifeSavingInfoBox(this, (BufferedImage)image, type, name);
        this.infoBoxManager.addInfoBox((InfoBox)infobox);
    }

    private void removeInfobox(LifeSavingItem type) {
        this.infoBoxManager.removeIf(infoBox -> infoBox instanceof LifeSavingInfoBox && ((LifeSavingInfoBox)((Object)infoBox)).getType() == type);
    }

    private void checkNotification(boolean enabled, LifeSavingItem type, String actualMessage, String expectedMessage) {
        if (enabled && StringUtils.contains((CharSequence)actualMessage, (CharSequence)expectedMessage)) {
            this.notifier.notify(String.format("Your %s is destroyed!", this.itemManager.getItemComposition(type.getItemId()).getName()));
        }
    }
}

