/*
 * Decompiled with CFR 0.152.
 */
package com.geeckon.instantdamagecalculator;

import com.geeckon.instantdamagecalculator.InstantDamageCalculatorConfig;
import com.geeckon.instantdamagecalculator.InstantDamageCalculatorOverlay;
import com.geeckon.instantdamagecalculator.NPCWithXpBoost;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="InstantDamageCalculator", tags={"experience", "levels", "prayer", "xpdrop", "damage", "damagedrop", "muspah"})
public class InstantDamageCalculatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InstantDamageCalculatorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InstantDamageCalculatorConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InstantDamageCalculatorOverlay overlay;
    private int xp = -1;
    private NPCWithXpBoost lastOpponent;
    private int lastOpponentID = -1;
    private int hit = 0;
    private int totalHit = 0;
    private int equippedWeaponTypeVarbit = -1;
    private int activeProtectionPrayerVarbit = -1;
    private int mode = 0;
    private static final ImmutableMap<NPCWithXpBoost, Double> XP_MODIFIERS = ImmutableMap.builder().put((Object)NPCWithXpBoost.CERBERUS, (Object)1.15).put((Object)NPCWithXpBoost.ABYSSAL_SIRE, (Object)1.125).put((Object)NPCWithXpBoost.ALCHEMICAL_HYDRA, (Object)1.2).put((Object)NPCWithXpBoost.CHAOS_FANATIC, (Object)1.125).put((Object)NPCWithXpBoost.CRAZY_ARCHAEOLOGIST, (Object)1.25).put((Object)NPCWithXpBoost.SCORPIA, (Object)1.3).put((Object)NPCWithXpBoost.KING_BLACK_DRAGON, (Object)1.075).put((Object)NPCWithXpBoost.CHAOS_ELEMENTAL, (Object)1.075).put((Object)NPCWithXpBoost.VETION, (Object)1.225).put((Object)NPCWithXpBoost.SKELETON_HELLHOUND, (Object)1.05).put((Object)NPCWithXpBoost.GREATER_SKELETON_HELLHOUND, (Object)1.125).put((Object)NPCWithXpBoost.VENENATIS, (Object)1.525).put((Object)NPCWithXpBoost.CALLISTO, (Object)1.225).put((Object)NPCWithXpBoost.OBOR, (Object)1.075).put((Object)NPCWithXpBoost.BRYOPHYTA, (Object)1.025).put((Object)NPCWithXpBoost.THE_MIMIC, (Object)1.25).put((Object)NPCWithXpBoost.THIRD_AGE_WARRIOR, (Object)1.075).put((Object)NPCWithXpBoost.SKOTIZO, (Object)1.375).put((Object)NPCWithXpBoost.TZKAL_ZUK, (Object)1.575).put((Object)NPCWithXpBoost.JAL_AK, (Object)1.025).put((Object)NPCWithXpBoost.JAL_IMKOT, (Object)1.075).put((Object)NPCWithXpBoost.RABBIT, (Object)2.125).put((Object)NPCWithXpBoost.AHRIM_THE_BLIGHTED, (Object)1.025).put((Object)NPCWithXpBoost.DHAROK_THE_WRETCHED, (Object)1.15).put((Object)NPCWithXpBoost.GUTHAN_THE_INFESTED, (Object)1.15).put((Object)NPCWithXpBoost.TORAG_THE_CORRUPTED, (Object)1.125).put((Object)NPCWithXpBoost.VERAC_THE_DEFILED, (Object)1.125).put((Object)NPCWithXpBoost.GIANT_MOLE, (Object)1.075).put((Object)NPCWithXpBoost.DERANGED_ARCHAEOLOGIST, (Object)1.375).put((Object)NPCWithXpBoost.DAGANNOTH_REX, (Object)1.3).put((Object)NPCWithXpBoost.DAGANNOTH_PRIME, (Object)1.3).put((Object)NPCWithXpBoost.SARACHNIS, (Object)1.075).put((Object)NPCWithXpBoost.SPAWN_OF_SARACHNIS, (Object)1.025).put((Object)NPCWithXpBoost.KALPHITE_QUEEN_CRAWLING, (Object)1.05).put((Object)NPCWithXpBoost.KALPHITE_QUEEN_AIRBORNE, (Object)1.125).put((Object)NPCWithXpBoost.KREE_ARRA, (Object)1.4).put((Object)NPCWithXpBoost.WINGMAN_SKREE, (Object)1.025).put((Object)NPCWithXpBoost.COMMANDER_ZILYANA, (Object)1.375).put((Object)NPCWithXpBoost.STARLIGHT, (Object)1.05).put((Object)NPCWithXpBoost.GENERAL_GRAARDOR, (Object)1.325).put((Object)NPCWithXpBoost.KRIL_TSUTSAROTH, (Object)1.375).put((Object)NPCWithXpBoost.SNAKELING, (Object)1.025).put((Object)NPCWithXpBoost.PHANTOM_MUSPAH, (Object)2.075).put((Object)NPCWithXpBoost.CORPOREAL_BEAST, (Object)1.55).put((Object)NPCWithXpBoost.NEX, (Object)2.525).put((Object)NPCWithXpBoost.UMBRA, (Object)1.075).put((Object)NPCWithXpBoost.CRUOR, (Object)1.05).put((Object)NPCWithXpBoost.GLACIES, (Object)1.05).put((Object)NPCWithXpBoost.DUKE_SUCELLUS, (Object)1.55).put((Object)NPCWithXpBoost.VARDORVIS, (Object)1.55).put((Object)NPCWithXpBoost.LEVIATHAN, (Object)1.975).put((Object)NPCWithXpBoost.BANDIT_130, (Object)1.025).put((Object)NPCWithXpBoost.BLACK_DRAGON, (Object)1.05).put((Object)NPCWithXpBoost.BRUTAL_BLACK_DRAGON, (Object)1.1).put((Object)NPCWithXpBoost.DARK_WARRIOR_135, (Object)1.1).put((Object)NPCWithXpBoost.ENT_WILDERNESS, (Object)1.025).put((Object)NPCWithXpBoost.ENT_WC_GUILD, (Object)1.05).put((Object)NPCWithXpBoost.FIRE_GIANT_104_109, (Object)1.025).put((Object)NPCWithXpBoost.BRUTAL_GREEN_DRAGON, (Object)1.05).put((Object)NPCWithXpBoost.LAVA_DRAGON, (Object)1.075).put((Object)NPCWithXpBoost.MOSS_GIANT_84, (Object)1.025).put((Object)NPCWithXpBoost.GREATER_NECHRYAEL, (Object)1.025).put((Object)NPCWithXpBoost.REVENANT_HOBGOBLIN, (Object)1.025).put((Object)NPCWithXpBoost.REVENANT_CYCLOPS, (Object)1.075).put((Object)NPCWithXpBoost.REVENANT_HELLHOUND, (Object)1.075).put((Object)NPCWithXpBoost.REVENANT_DEMON, (Object)1.075).put((Object)NPCWithXpBoost.REVENANT_ORK, (Object)1.1).put((Object)NPCWithXpBoost.REVENANT_DARK_BEAST, (Object)1.125).put((Object)NPCWithXpBoost.REVENANT_KNIGHT, (Object)1.175).put((Object)NPCWithXpBoost.REVENANT_DRAGON, (Object)1.2).put((Object)NPCWithXpBoost.REVENANT_MALEDICTUS, (Object)1.65).put((Object)NPCWithXpBoost.SPIRITUAL_WARRIOR_BANDOS, (Object)1.025).put((Object)NPCWithXpBoost.DEVIANT_SPECTRE, (Object)1.025).put((Object)NPCWithXpBoost.ADAMANT_DRAGON, (Object)1.1).put((Object)NPCWithXpBoost.DEMONIC_GORILLA, (Object)1.075).put((Object)NPCWithXpBoost.TORTURED_GORILLA, (Object)1.125).put((Object)NPCWithXpBoost.BLUE_DRAGON, (Object)1.025).put((Object)NPCWithXpBoost.BRUTAL_BLUE_DRAGON, (Object)1.05).put((Object)NPCWithXpBoost.DARK_BEAST, (Object)1.025).put((Object)NPCWithXpBoost.DRAKE, (Object)1.075).put((Object)NPCWithXpBoost.ELVES, (Object)1.025).put((Object)NPCWithXpBoost.SPITTING_WYVERN, (Object)1.025).put((Object)NPCWithXpBoost.TALONED_WYVERN, (Object)1.025).put((Object)NPCWithXpBoost.LONGTAILED_WYVERN, (Object)1.025).put((Object)NPCWithXpBoost.ANCIENT_WYVERN, (Object)1.05).put((Object)NPCWithXpBoost.IRON_DRAGON, (Object)1.05).put((Object)NPCWithXpBoost.LIZARDMAN_SHAMAN_OVERWORLD, (Object)1.05).put((Object)NPCWithXpBoost.MITHRIL_DRAGON, (Object)1.075).put((Object)NPCWithXpBoost.RED_DRAGON, (Object)1.025).put((Object)NPCWithXpBoost.BRUTAL_RED_DRAGON, (Object)1.075).put((Object)NPCWithXpBoost.RUNE_DRAGON, (Object)1.1).put((Object)NPCWithXpBoost.SKELETAL_WYVERN, (Object)1.05).put((Object)NPCWithXpBoost.STEEL_DRAGON, (Object)1.05).put((Object)NPCWithXpBoost.SUQAH, (Object)1.025).put((Object)NPCWithXpBoost.BRONZE_DRAGON, (Object)1.025).put((Object)NPCWithXpBoost.ICE_TROLLS, (Object)1.05).put((Object)NPCWithXpBoost.TROLL_GENERAL, (Object)1.075).put((Object)NPCWithXpBoost.WYRM, (Object)1.025).put((Object)NPCWithXpBoost.LOCUST_RIDER, (Object)1.025).put((Object)NPCWithXpBoost.SCARAB_MAGE, (Object)1.025).put((Object)NPCWithXpBoost.HYDRA, (Object)1.075).put((Object)NPCWithXpBoost.REPUGNANT_SPECTRE, (Object)1.075).put((Object)NPCWithXpBoost.BASILISK_SENTINEL, (Object)1.075).put((Object)NPCWithXpBoost.KING_KURASK, (Object)1.025).put((Object)NPCWithXpBoost.MARBLE_GARGOYLE, (Object)1.025).put((Object)NPCWithXpBoost.NECHRYACH, (Object)1.025).put((Object)NPCWithXpBoost.GREATER_ABYSSAL_DEMON, (Object)1.05).put((Object)NPCWithXpBoost.NIGHT_BEAST, (Object)1.175).put((Object)NPCWithXpBoost.CORRUPT_LIZARDMAN_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.ELVARG_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.MOSS_GUARDIAN_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.MOSS_GUARDIAN_HARD_NMZ, (Object)1.075).put((Object)NPCWithXpBoost.SLAGILITH_NMZ, (Object)1.03).put((Object)NPCWithXpBoost.SLAGILITH_HARD_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.DAGANNOTH_MOTHER_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.DAGANNOTH_MOTHER_HARD_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.DAD_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.DAD_HARD_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.ARRG_NMZ, (Object)1.075).put((Object)NPCWithXpBoost.ARRG_HARD_NMZ, (Object)1.175).put((Object)NPCWithXpBoost.BLACK_KNIGHT_TITAN_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.BLACK_KNIGHT_TITAN_HARD_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.ICE_TROLL_KING_NMZ, (Object)1.075).put((Object)NPCWithXpBoost.ICE_TROLL_KING_HARD_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.GLOD_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.GLOD_HARD_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.EVIL_CHICKEN_NMZ, (Object)0.025).put((Object)NPCWithXpBoost.AGRITHNANA_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.AGRITHNANA_HARD_NMZ, (Object)1.175).put((Object)NPCWithXpBoost.FLAMBEED_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.FLAMBEED_HARD_NMZ, (Object)1.175).put((Object)NPCWithXpBoost.KARAMEL_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.DESSOURT_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.DESSOURT_HARD_NMZ, (Object)1.2).put((Object)NPCWithXpBoost.GELATINNOTH_MOTHER_NMZ, (Object)1.075).put((Object)NPCWithXpBoost.GELATINNOTH_MOTHER_HARD_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.CHRONOZON_NMZ, (Object)0.1).put((Object)NPCWithXpBoost.DESSOUS_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.DESSOUS_HARD_NMZ, (Object)1.175).put((Object)NPCWithXpBoost.DAMIS_FIRST_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.DAMIS_SECOND_NMZ, (Object)1.15).put((Object)NPCWithXpBoost.DAMIS_FIRST_HARD_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.DAMIS_SECOND_HARD_NMZ, (Object)1.225).put((Object)NPCWithXpBoost.FAREED_NMZ, (Object)1.15).put((Object)NPCWithXpBoost.FAREED_HARD_NMZ, (Object)1.25).put((Object)NPCWithXpBoost.KAMIL_NMZ, (Object)1.125).put((Object)NPCWithXpBoost.KAMIL_HARD_NMZ, (Object)1.225).put((Object)NPCWithXpBoost.BARRELCHEST_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.BARRELCHEST_HARD_NMZ, (Object)1.175).put((Object)NPCWithXpBoost.GIANT_SCARAB_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.GIANT_SCARAB_HARD_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.JUNGLE_DEMON_NMZ, (Object)1.075).put((Object)NPCWithXpBoost.JUNGLE_DEMON_HARD_NMZ, (Object)1.15).put((Object)NPCWithXpBoost.ARIANWYN_NMZ, (Object)1.025).put((Object)NPCWithXpBoost.ESSYLLT_NMZ, (Object)1.05).put((Object)NPCWithXpBoost.ESSYLLT_HARD_NMZ, (Object)1.1).put((Object)NPCWithXpBoost.DAGANNOTH_WATERBIRTH_MELEE, (Object)1.05).put((Object)NPCWithXpBoost.GIANT_ROCK_CRAB, (Object)1.1).put((Object)NPCWithXpBoost.WALLASALKI, (Object)1.025).put((Object)NPCWithXpBoost.ROCK_LOBSTER, (Object)1.025).put((Object)NPCWithXpBoost.JUSTICIAR_ZACHARIAH, (Object)1.55).put((Object)NPCWithXpBoost.DERWEN, (Object)1.2).put((Object)NPCWithXpBoost.PORAZDIR, (Object)1.2).put((Object)NPCWithXpBoost.GALVEK, (Object)1.425).put((Object)NPCWithXpBoost.FRAGMENT_OF_SEREN, (Object)1.55).put((Object)NPCWithXpBoost.GLOUGH, (Object)1.325).put((Object)NPCWithXpBoost.MONKEY_GUARD, (Object)1.025).put((Object)NPCWithXpBoost.MONKEY_SKELETON, (Object)1.025).put((Object)NPCWithXpBoost.DOUBLE_AGENT_108, (Object)1.025).put((Object)NPCWithXpBoost.DOUBLE_AGENT_141, (Object)1.05).put((Object)NPCWithXpBoost.SARADOMIN_WIZARD, (Object)1.025).put((Object)NPCWithXpBoost.ANCIENT_WIZARD_MELEE, (Object)1.05).put((Object)NPCWithXpBoost.UNDEAD_DRUID, (Object)1.05).put((Object)NPCWithXpBoost.FEROCIOUS_BARBARIAN_SPIRIT, (Object)1.05).build();
    private static final ImmutableMap<NPCWithXpBoost, Double[]> XP_MODIFIERS_WITH_MODES = ImmutableMap.builder().put((Object)NPCWithXpBoost.TEKTON, (Object)new Double[]{1.35, 1.5}).put((Object)NPCWithXpBoost.TEKTON_ENRAGED, (Object)new Double[]{1.525, 1.775}).put((Object)NPCWithXpBoost.ICE_DEMON, (Object)new Double[]{1.525, 1.775}).put((Object)NPCWithXpBoost.LIZARDMAN_SHAMAN, (Object)new Double[]{1.175, 1.275}).put((Object)NPCWithXpBoost.VANGUARD_MELEE, (Object)new Double[]{1.075, 1.125}).put((Object)NPCWithXpBoost.VANGUARD_RANGED, (Object)new Double[]{1.05, 1.075}).put((Object)NPCWithXpBoost.VANGUARD_MAGIC, (Object)new Double[]{1.275, 1.4}).put((Object)NPCWithXpBoost.GUARDIAN, (Object)new Double[]{1.075, 1.1}).put((Object)NPCWithXpBoost.VASA_NISTIRIO, (Object)new Double[]{1.075, 1.1}).put((Object)NPCWithXpBoost.VASA_CRYSTALS, (Object)new Double[]{1.025, 1.025}).put((Object)NPCWithXpBoost.SKELETAL_MYSTIC, (Object)new Double[]{1.2, 1.3}).put((Object)NPCWithXpBoost.MUTTADILE_SMALL, (Object)new Double[]{1.125, 1.225}).put((Object)NPCWithXpBoost.MUTTADILE_LARGE, (Object)new Double[]{1.2, 1.35}).put((Object)NPCWithXpBoost.PESTILENT_BLOAT, (Object)new Double[]{1.85, 1.975, 1.075}).put((Object)NPCWithXpBoost.NYLOCAS_VASILIAS, (Object)new Double[]{1.225, 1.225, 1.025}).put((Object)NPCWithXpBoost.SOTETSEG, (Object)new Double[]{1.675, 1.675, 1.045}).put((Object)NPCWithXpBoost.VERZIK_VITUR_P1, (Object)new Double[]{1.05, 1.05, 1.005}).put((Object)NPCWithXpBoost.VERZIK_VITUR_P2, (Object)new Double[]{1.425, 1.425, 1.025}).put((Object)NPCWithXpBoost.VERZIK_VITUR_P3, (Object)new Double[]{1.85, 1.85, 1.125}).build();
    private static final ImmutableMap<NPCWithXpBoost, Integer[]> TOA_NPC_BASE_STATS = ImmutableMap.builder().put((Object)NPCWithXpBoost.KEPHRI, (Object)new Integer[]{150, 0, 0, 80, 60, 300, 100, 0, 0}).put((Object)NPCWithXpBoost.AGILE_SCARAB, (Object)new Integer[]{30, 60, 20, 5, 0, 0, 0, 0, 25}).put((Object)NPCWithXpBoost.SOLDIER_SCARAB, (Object)new Integer[]{40, 75, 80, 80, 15, 250, 30, 100, 55}).put((Object)NPCWithXpBoost.SPITTING_SCARAB, (Object)new Integer[]{40, 1, 80, 80, 15, 250, 30, 0, 55}).put((Object)NPCWithXpBoost.ARCANE_SCARAB, (Object)new Integer[]{40, 75, 80, 80, 15, 250, 30, 0, 55}).put((Object)NPCWithXpBoost.SCARAB_TOA, (Object)new Integer[]{12, 20, 32, 28, 0, 0, 0, 0, 0}).put((Object)NPCWithXpBoost.AKKHA, (Object)new Integer[]{400, 100, 140, 80, 60, 120, 120, 115, 30}).put((Object)NPCWithXpBoost.AKKHAS_SHADOW, (Object)new Integer[]{70, 100, 140, 30, 60, 120, 120, 115, 30}).put((Object)NPCWithXpBoost.BABA, (Object)new Integer[]{380, 150, 160, 80, 80, 150, 240, 0, 26}).put((Object)NPCWithXpBoost.BABOON_TOA, (Object)new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0}).put((Object)NPCWithXpBoost.BABOON_BRAWLER_SMALL, (Object)new Integer[]{4, 40, 40, 12, 900, 900, 900, 20, 0}).put((Object)NPCWithXpBoost.BABOON_BRAWLER_LARGE, (Object)new Integer[]{8, 60, 60, 20, 900, 900, 900, 25, 0}).put((Object)NPCWithXpBoost.BABOON_THROWER_SMALL, (Object)new Integer[]{4, 40, 40, 12, -50, -50, -50, 20, 0}).put((Object)NPCWithXpBoost.BABOON_THROWER_LARGE, (Object)new Integer[]{8, 60, 60, 20, -50, -50, -50, 25, 0}).put((Object)NPCWithXpBoost.BABOON_MAGE_SMALL, (Object)new Integer[]{4, 40, 40, 12, 900, 900, 900, 20, 0}).put((Object)NPCWithXpBoost.BABOON_MAGE_LARGE, (Object)new Integer[]{8, 60, 60, 20, 900, 900, 900, 25, 0}).put((Object)NPCWithXpBoost.BABOON_SHAMAN, (Object)new Integer[]{16, 60, 60, 20, 900, 900, 900, 25, 0}).put((Object)NPCWithXpBoost.CURSED_BABOON, (Object)new Integer[]{10, 60, 60, 20, 900, 900, 900, 25, 0}).put((Object)NPCWithXpBoost.VOLATILE_BABOON, (Object)new Integer[]{8, 60, 60, 20, 900, 900, 900, 25, 0}).put((Object)NPCWithXpBoost.BABOON_THRALL, (Object)new Integer[]{2, 40, 40, 12, 0, 0, 0, 20, 0}).put((Object)NPCWithXpBoost.ZEBAK, (Object)new Integer[]{580, 250, 140, 70, 160, 160, 260, 160, 100}).put((Object)NPCWithXpBoost.CROCODILE_TOA, (Object)new Integer[]{30, 150, 60, 100, 150, 350, 350, 0, 100}).put((Object)NPCWithXpBoost.OBELISK, (Object)new Integer[]{260, 200, 150, 100, 70, 70, 70, 0, 0}).put((Object)NPCWithXpBoost.CORE, (Object)new Integer[]{0, 0, 0, 0, 0, 0, 0, 0, 0}).put((Object)NPCWithXpBoost.ELIDINIS_WARDEN_P2, (Object)new Integer[]{140, 300, 150, 100, 70, 70, 70, 0, 10}).put((Object)NPCWithXpBoost.TUMEKENS_WARDEN_P2, (Object)new Integer[]{140, 300, 150, 100, 70, 70, 70, 0, 25}).put((Object)NPCWithXpBoost.WARDENS_P3, (Object)new Integer[]{880, 150, 150, 150, 40, 40, 20, 0, 40}).build();
    private HashMap<NPCWithXpBoost, Double> TOA_XP_MODIFIERS = new HashMap();
    private HashMap<Integer, Double> CUSTOM_XP_MODIFIERS = new HashMap();
    private Instant expiryTimer;
    private boolean overlayExpired = true;

    @Provides
    InstantDamageCalculatorConfig provideConfig(ConfigManager configManager) {
        return (InstantDamageCalculatorConfig)configManager.getConfig(InstantDamageCalculatorConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.updateCustomXP();
        this.clientThread.invoke(() -> this.updateToaModifiers());
        log.info("InstantDamageCalculator started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("InstantDamageCalculator stopped!");
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getKey().equals("customBonusXP")) {
            this.updateCustomXP();
        }
        if (configChanged.getKey().equals("expiry") && this.config.expiry() != 0) {
            this.expireOverlay();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            switch (Text.removeTags((String)chatMessage.getMessage())) {
                case "You enter the Theatre of Blood (Entry Mode)...": {
                    this.mode = 2;
                    break;
                }
                case "You enter the Theatre of Blood (Normal Mode)...": {
                    this.mode = 0;
                    break;
                }
                case "You enter the Theatre of Blood (Hard Mode)...": {
                    this.mode = 1;
                }
            }
        } else if (chatMessage.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION && Text.removeTags((String)chatMessage.getMessage()).equals("The raid has begun!")) {
            this.mode = this.client.getVarbitValue(6385) > 0 ? 1 : 0;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (statChanged.getSkill() == Skill.HITPOINTS) {
            int newXp = this.client.getSkillExperience(Skill.HITPOINTS);
            if (this.xp == -1) {
                this.xp = newXp;
                return;
            }
            long diff = newXp - this.xp;
            if (diff > 0L) {
                double modifier = 1.0;
                modifier = this.CUSTOM_XP_MODIFIERS.containsKey(this.lastOpponentID) ? this.CUSTOM_XP_MODIFIERS.get(this.lastOpponentID) : (XP_MODIFIERS_WITH_MODES.containsKey((Object)this.lastOpponent) ? ((Double[])XP_MODIFIERS_WITH_MODES.get((Object)this.lastOpponent))[this.mode] : (this.TOA_XP_MODIFIERS.containsKey((Object)this.lastOpponent) ? this.TOA_XP_MODIFIERS.get((Object)this.lastOpponent).doubleValue() : ((Double)XP_MODIFIERS.getOrDefault((Object)this.lastOpponent, (Object)1.0)).doubleValue()));
                this.hit = (int)Math.round((double)diff / 1.33 / modifier);
                this.xp = newXp;
                this.totalHit += this.hit;
                this.enableExpiryTimer();
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        Actor opponent = event.getTarget();
        if (!(opponent instanceof NPC)) {
            this.lastOpponent = null;
            this.lastOpponentID = -1;
            return;
        }
        NPC npc = (NPC)opponent;
        this.lastOpponentID = npc.getId();
        this.lastOpponent = NPCWithXpBoost.getNpc(this.lastOpponentID);
    }

    @Subscribe(priority=1.0f)
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() == 996) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            int widgetId = intStack[intStackSize - 4];
            this.processXpDrop(widgetId);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        int toaWidgetID = 481;
        if (widgetLoaded.getGroupId() == toaWidgetID) {
            this.updateToaModifiers();
        }
    }

    private void processXpDrop(int widgetId) {
        Widget xpdrop = this.client.getWidget(widgetId);
        Widget[] children = xpdrop.getChildren();
        Widget text = children[0];
        int[] spriteIDs = Arrays.stream(children).skip(1L).filter(Objects::nonNull).mapToInt(Widget::getSpriteId).toArray();
        this.replaceXpDrops(text, spriteIDs);
    }

    private void replaceXpDrops(Widget text, int[] spriteIDs) {
        if (!this.config.replaceXpDrops()) {
            return;
        }
        boolean hasOtherCombatDrop = false;
        for (int i = 0; i < spriteIDs.length; ++i) {
            int spriteId = spriteIDs[i];
            if (spriteId == 203) {
                text.setText("" + this.hit);
                return;
            }
            if (spriteId != 197 && spriteId != 198 && spriteId != 199 && spriteId != 200 && spriteId != 202) continue;
            hasOtherCombatDrop = true;
        }
        if (hasOtherCombatDrop) {
            text.setText("");
        }
    }

    private void updateCustomXP() {
        this.CUSTOM_XP_MODIFIERS.clear();
        for (String customRaw : this.config.customBonusXP().split("\n")) {
            String[] split;
            if (customRaw.trim().equals("") || (split = customRaw.split(":")).length < 2) continue;
            try {
                Integer customID = Integer.parseInt(split[0].trim());
                Double customXP = Double.parseDouble(split[1].trim());
                if (customID <= 0 || !(customXP > 0.0)) continue;
                this.CUSTOM_XP_MODIFIERS.put(customID, customXP);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.config.displayTotalDamageOverlay()) {
            return;
        }
        if (event.getVarbitId() == 357) {
            if (!this.config.resetOnWeaponChange()) {
                return;
            }
            int currentEquippedWeaponTypeVarbit = this.client.getVarbitValue(357);
            if (currentEquippedWeaponTypeVarbit == this.equippedWeaponTypeVarbit) {
                return;
            }
            this.equippedWeaponTypeVarbit = currentEquippedWeaponTypeVarbit;
            this.resetTotalHit();
        }
        if ((event.getVarbitId() == 4116 || event.getVarbitId() == 4117 || event.getVarbitId() == 4118) && event.getValue() == 1) {
            if (!this.config.resetOnPrayerChange()) {
                return;
            }
            if (event.getVarbitId() == this.activeProtectionPrayerVarbit) {
                return;
            }
            this.activeProtectionPrayerVarbit = event.getVarbitId();
            this.resetTotalHit();
        }
    }

    private void resetTotalHit() {
        this.totalHit = 0;
    }

    private void updateToaModifiers() {
        int toaCrondisLevel;
        int toaApmekenLevel;
        int toaHetLevel;
        int toaScabarasLevel;
        int[] regions = this.client.getMapRegions();
        if (regions == null || regions.length != 1) {
            return;
        }
        if (regions[0] != 14160) {
            return;
        }
        int parentWidget = 481;
        int scabarasWidget = 49;
        int hetWidget = 51;
        int apmekenWidget = 53;
        int crondisWidget = 55;
        int toaRaidLevel = this.client.getVarbitValue(14380);
        int toaGroupSize = 0;
        if (this.client.getVarbitValue(14346) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14347) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14348) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14349) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14350) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14351) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14352) > 0) {
            ++toaGroupSize;
        }
        if (this.client.getVarbitValue(14353) > 0) {
            ++toaGroupSize;
        }
        if (toaGroupSize == 0) {
            toaGroupSize = 1;
        }
        try {
            toaScabarasLevel = Integer.parseInt(this.client.getWidget(parentWidget, scabarasWidget).getText());
            toaHetLevel = Integer.parseInt(this.client.getWidget(parentWidget, hetWidget).getText());
            toaApmekenLevel = Integer.parseInt(this.client.getWidget(parentWidget, apmekenWidget).getText());
            toaCrondisLevel = Integer.parseInt(this.client.getWidget(parentWidget, crondisWidget).getText());
        }
        catch (NullPointerException e) {
            return;
        }
        catch (NumberFormatException e) {
            return;
        }
        double raidMultiplier = 1.0 + 0.004 * (double)toaRaidLevel;
        double groupMultiplier = 1.0;
        if (toaGroupSize >= 2) {
            groupMultiplier += 0.9;
        }
        if (toaGroupSize >= 3) {
            groupMultiplier += 0.9;
        }
        if (toaGroupSize >= 4) {
            groupMultiplier += (double)(toaGroupSize - 3) * 0.6;
        }
        double scabarasMultiplier = 1.0 + (toaScabarasLevel > 0 ? 0.08 : 0.0) + (toaScabarasLevel > 1 ? 0.05 * (double)(toaScabarasLevel - 1) : 0.0);
        double hetMultiplier = 1.0 + (toaHetLevel > 0 ? 0.08 : 0.0) + (toaHetLevel > 1 ? 0.05 * (double)(toaHetLevel - 1) : 0.0);
        double apmekenMultiplier = 1.0 + (toaApmekenLevel > 0 ? 0.08 : 0.0) + (toaApmekenLevel > 1 ? 0.05 * (double)(toaApmekenLevel - 1) : 0.0);
        double crondisMultiplier = 1.0 + (toaCrondisLevel > 0 ? 0.08 : 0.0) + (toaCrondisLevel > 1 ? 0.05 * (double)(toaCrondisLevel - 1) : 0.0);
        double commonMultiplier = raidMultiplier * groupMultiplier;
        double kephriMultiplier = commonMultiplier * scabarasMultiplier;
        double akkhaMultiplier = commonMultiplier * hetMultiplier;
        double babaMultiplier = commonMultiplier * apmekenMultiplier;
        double zebakMultiplier = commonMultiplier * crondisMultiplier;
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.KEPHRI, this.calculateToaModifier(NPCWithXpBoost.KEPHRI, kephriMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.SOLDIER_SCARAB, this.calculateToaModifier(NPCWithXpBoost.SOLDIER_SCARAB, kephriMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.SPITTING_SCARAB, this.calculateToaModifier(NPCWithXpBoost.SPITTING_SCARAB, kephriMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.ARCANE_SCARAB, this.calculateToaModifier(NPCWithXpBoost.ARCANE_SCARAB, kephriMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.AGILE_SCARAB, this.calculateToaModifier(NPCWithXpBoost.AGILE_SCARAB, kephriMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.SCARAB_TOA, this.calculateToaModifier(NPCWithXpBoost.SCARAB_TOA, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.AKKHA, this.calculateToaModifier(NPCWithXpBoost.AKKHA, akkhaMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.AKKHAS_SHADOW, this.calculateToaModifier(NPCWithXpBoost.AKKHAS_SHADOW, akkhaMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABA, this.calculateToaModifier(NPCWithXpBoost.BABA, babaMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_TOA, 1.0);
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_BRAWLER_SMALL, this.calculateToaModifier(NPCWithXpBoost.BABOON_BRAWLER_SMALL, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_BRAWLER_LARGE, this.calculateToaModifier(NPCWithXpBoost.BABOON_BRAWLER_LARGE, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_THROWER_SMALL, this.calculateToaModifier(NPCWithXpBoost.BABOON_THROWER_SMALL, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_THROWER_LARGE, this.calculateToaModifier(NPCWithXpBoost.BABOON_THROWER_LARGE, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_MAGE_SMALL, this.calculateToaModifier(NPCWithXpBoost.BABOON_MAGE_SMALL, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_MAGE_LARGE, this.calculateToaModifier(NPCWithXpBoost.BABOON_MAGE_LARGE, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_SHAMAN, this.calculateToaModifier(NPCWithXpBoost.BABOON_SHAMAN, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.CURSED_BABOON, this.calculateToaModifier(NPCWithXpBoost.CURSED_BABOON, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.VOLATILE_BABOON, this.calculateToaModifier(NPCWithXpBoost.VOLATILE_BABOON, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.BABOON_THRALL, this.calculateToaModifier(NPCWithXpBoost.BABOON_THRALL, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.ZEBAK, this.calculateToaModifier(NPCWithXpBoost.ZEBAK, zebakMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.CROCODILE_TOA, this.calculateToaModifier(NPCWithXpBoost.CROCODILE_TOA, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.OBELISK, this.calculateToaModifier(NPCWithXpBoost.OBELISK, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.CORE, 1.0);
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.ELIDINIS_WARDEN_P2, this.calculateToaModifier(NPCWithXpBoost.ELIDINIS_WARDEN_P2, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.TUMEKENS_WARDEN_P2, this.calculateToaModifier(NPCWithXpBoost.TUMEKENS_WARDEN_P2, commonMultiplier));
        this.TOA_XP_MODIFIERS.put(NPCWithXpBoost.WARDENS_P3, this.calculateToaModifier(NPCWithXpBoost.WARDENS_P3, commonMultiplier));
    }

    private double calculateToaModifier(NPCWithXpBoost npc, double multiplier) {
        int D;
        Integer[] baseStats = (Integer[])TOA_NPC_BASE_STATS.get((Object)npc);
        int attack = baseStats[1];
        int strength = baseStats[2];
        int defense = baseStats[3];
        int stabDefense = baseStats[4];
        int slashDefense = baseStats[5];
        int crushDefense = baseStats[6];
        int attackBonus = baseStats[7];
        int strengthBonus = baseStats[8];
        double rawHP = (double)baseStats[0].intValue() * multiplier;
        int hp = (int)Math.round(rawHP / 10.0) * 10;
        int M = (hp + attack + strength + defense) / 4;
        int MDAS = M * ((D = (stabDefense + slashDefense + crushDefense) / 3) + attackBonus + strengthBonus);
        if (MDAS < 0) {
            MDAS = 0;
        }
        int band = MDAS / 5120;
        return 1.0 + (double)band * 0.025;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Duration expiryTimeout;
        Duration timeSinceUpdate;
        if (this.expiryTimer != null && this.config.expiry() != 0 && (timeSinceUpdate = Duration.between(this.expiryTimer, Instant.now())).compareTo(expiryTimeout = Duration.ofSeconds(this.config.expiry())) >= 0) {
            this.expireOverlay();
        }
    }

    private void expireOverlay() {
        this.overlayExpired = true;
    }

    private void enableExpiryTimer() {
        this.expiryTimer = Instant.now();
        this.overlayExpired = false;
    }

    public int getHit() {
        return this.hit;
    }

    public int getTotalHit() {
        return this.totalHit;
    }

    public boolean isOverlayExpired() {
        return this.overlayExpired;
    }
}

