/*
 * Decompiled with CFR 0.152.
 */
package com.geeckon.instantdamagecalculator;

import com.geeckon.instantdamagecalculator.InstantDamageCalculatorConfig;
import com.geeckon.instantdamagecalculator.InstantDamageCalculatorPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

class InstantDamageCalculatorOverlay
extends OverlayPanel {
    private final Client client;
    private final InstantDamageCalculatorConfig config;
    private final InstantDamageCalculatorPlugin plugin;

    @Inject
    private InstantDamageCalculatorOverlay(Client client, InstantDamageCalculatorConfig config, InstantDamageCalculatorPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Instant damage overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.displayDamageOverlay() || this.config.expiry() != 0 && this.plugin.isOverlayExpired()) {
            return null;
        }
        Color strColor = new Color(238, 51, 51);
        String str = String.valueOf(this.plugin.getHit());
        String leftText = this.config.displayOverlayText() ? "Current hit:" : "";
        this.panelComponent.getChildren().add(LineComponent.builder().left(leftText).right(str).rightColor(strColor).build());
        if (this.config.displayTotalDamageOverlay()) {
            String totalStr = String.valueOf(this.plugin.getTotalHit());
            String leftTotalText = this.config.displayOverlayText() ? "Total hit:" : "";
            this.panelComponent.getChildren().add(LineComponent.builder().left(leftTotalText).right(totalStr).rightColor(strColor).build());
        }
        return super.render(graphics);
    }
}

