/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import java.util.HashMap;
import java.util.Map;
import men.groupiron.ConsumableState;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillState
implements ConsumableState {
    private static final Logger log = LoggerFactory.getLogger(SkillState.class);
    private final Map<String, Integer> skillXpMap;
    private final transient String playerName;

    public SkillState(String playerName, Client client) {
        this.playerName = playerName;
        this.skillXpMap = new HashMap<String, Integer>();
        for (Skill skill : Skill.values()) {
            this.skillXpMap.put(skill.getName(), client.getSkillExperience(skill));
        }
    }

    @Override
    public Object get() {
        return new int[]{this.skillXpMap.get("Agility"), this.skillXpMap.get("Attack"), this.skillXpMap.get("Construction"), this.skillXpMap.get("Cooking"), this.skillXpMap.get("Crafting"), this.skillXpMap.get("Defence"), this.skillXpMap.get("Farming"), this.skillXpMap.get("Firemaking"), this.skillXpMap.get("Fishing"), this.skillXpMap.get("Fletching"), this.skillXpMap.get("Herblore"), this.skillXpMap.get("Hitpoints"), this.skillXpMap.get("Hunter"), this.skillXpMap.get("Magic"), this.skillXpMap.get("Mining"), this.skillXpMap.get("Prayer"), this.skillXpMap.get("Ranged"), this.skillXpMap.get("Runecraft"), this.skillXpMap.get("Slayer"), this.skillXpMap.get("Smithing"), this.skillXpMap.get("Strength"), this.skillXpMap.get("Thieving"), this.skillXpMap.get("Woodcutting")};
    }

    @Override
    public String whoOwnsThis() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkillState)) {
            return false;
        }
        SkillState other = (SkillState)o;
        for (Skill skill : Skill.values()) {
            String skillName = skill.getName();
            if (this.skillXpMap.get(skillName).equals(other.skillXpMap.get(skillName))) continue;
            return false;
        }
        return true;
    }
}

