/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import men.groupiron.ConsumableState;
import net.runelite.api.Client;
import net.runelite.api.Skill;

public class ResourcesState
implements ConsumableState {
    private final CurrentMax hitpoints;
    private final CurrentMax prayer;
    private final CurrentMax energy;
    int world;
    private final transient String playerName;

    ResourcesState(String playerName, Client client) {
        this.playerName = playerName;
        this.hitpoints = new CurrentMax(client.getBoostedSkillLevel(Skill.HITPOINTS), client.getRealSkillLevel(Skill.HITPOINTS));
        this.prayer = new CurrentMax(client.getBoostedSkillLevel(Skill.PRAYER), client.getRealSkillLevel(Skill.PRAYER));
        this.energy = new CurrentMax(client.getEnergy(), 100);
        this.world = client.getWorld();
    }

    @Override
    public Object get() {
        return new int[]{this.hitpoints.current, this.hitpoints.max, this.prayer.current, this.prayer.max, this.energy.current, this.energy.max, this.world};
    }

    @Override
    public String whoOwnsThis() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcesState)) {
            return false;
        }
        ResourcesState other = (ResourcesState)o;
        return other.world == this.world && other.hitpoints.equals(this.hitpoints) && other.prayer.equals(this.prayer) && other.energy.equals(this.energy);
    }

    public CurrentMax getHitpoints() {
        return this.hitpoints;
    }

    public CurrentMax getPrayer() {
        return this.prayer;
    }

    public CurrentMax getEnergy() {
        return this.energy;
    }

    public int getWorld() {
        return this.world;
    }

    private static class CurrentMax {
        private final int current;
        private final int max;

        CurrentMax(int current, int max) {
            this.current = current;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentMax)) {
                return false;
            }
            CurrentMax other = (CurrentMax)o;
            return other.getCurrent() == this.current && other.getMax() == this.max;
        }

        public int getCurrent() {
            return this.current;
        }

        public int getMax() {
            return this.max;
        }
    }
}

