/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import men.groupiron.ConsumableState;
import net.runelite.api.Client;
import net.runelite.api.Quest;

public class QuestState
implements ConsumableState {
    private final Map<Integer, net.runelite.api.QuestState> questStateMap;
    private final transient String playerName;
    private List<Integer> sortedQuestIds = Arrays.stream(Quest.values()).map(Quest::getId).sorted().collect(Collectors.toList());

    public QuestState(String playerName, Client client) {
        this.playerName = playerName;
        this.questStateMap = new HashMap<Integer, net.runelite.api.QuestState>();
        for (Quest quest : Quest.values()) {
            this.questStateMap.put(quest.getId(), quest.getState(client));
        }
    }

    @Override
    public Object get() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.questStateMap.size());
        for (Integer questId : this.sortedQuestIds) {
            result.add(this.questStateMap.get(questId).ordinal());
        }
        return result;
    }

    @Override
    public String whoOwnsThis() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestState)) {
            return false;
        }
        QuestState other = (QuestState)o;
        for (Quest quest : Quest.values()) {
            Integer questId = quest.getId();
            if (this.questStateMap.get(questId) == other.questStateMap.get(questId)) continue;
            return false;
        }
        return true;
    }
}

