/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import men.groupiron.ConsumableState;
import men.groupiron.ItemContainerItem;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemContainerState
implements ConsumableState {
    private static final Logger log = LoggerFactory.getLogger(ItemContainerState.class);
    private final List<ItemContainerItem> items;
    private final transient String playerName;

    public ItemContainerState(String playerName, ItemContainer container, ItemManager itemManager) {
        Item[] contents;
        this.playerName = playerName;
        this.items = new ArrayList<ItemContainerItem>();
        for (Item item : contents = container.getItems()) {
            if (!this.isItemValid(item, itemManager)) continue;
            this.items.add(new ItemContainerItem(itemManager.canonicalize(item.getId()), item.getQuantity()));
        }
    }

    public ItemContainerState(String playerName, ItemContainer container, ItemManager itemManager, int containerSize) {
        this.playerName = playerName;
        this.items = new ArrayList<ItemContainerItem>();
        for (int i = 0; i < containerSize; ++i) {
            Item item = container.getItem(i);
            if (!this.isItemValid(item, itemManager)) {
                this.items.add(new ItemContainerItem(0, 0));
                continue;
            }
            this.items.add(new ItemContainerItem(itemManager.canonicalize(item.getId()), item.getQuantity()));
        }
    }

    public ItemContainerState(String playerName, List<ItemContainerItem> items) {
        this.playerName = playerName;
        this.items = items;
    }

    @Nullable
    public ItemContainerState add(ItemContainerState itemsToAdd) {
        if (itemsToAdd == null || !itemsToAdd.whoOwnsThis().equals(this.whoOwnsThis())) {
            return null;
        }
        Map<Integer, ItemContainerItem> thisItems = this.getItemMap();
        Map<Integer, ItemContainerItem> otherItems = itemsToAdd.getItemMap();
        ArrayList<ItemContainerItem> result = new ArrayList<ItemContainerItem>();
        for (Integer itemId : thisItems.keySet()) {
            ItemContainerItem item = thisItems.get(itemId);
            if (otherItems.containsKey(itemId)) {
                item.addQuantity(otherItems.get(itemId).getQuantity());
            }
            result.add(item);
        }
        for (Integer itemId : otherItems.keySet()) {
            if (thisItems.containsKey(itemId)) continue;
            result.add(otherItems.get(itemId));
        }
        return new ItemContainerState(this.whoOwnsThis(), result);
    }

    @Nullable
    public ItemContainerState whatGotRemoved(ItemContainerState other) {
        if (other == null || !other.whoOwnsThis().equals(this.whoOwnsThis())) {
            return null;
        }
        Map<Integer, ItemContainerItem> thisItems = this.getItemMap();
        Map<Integer, ItemContainerItem> otherItems = other.getItemMap();
        ArrayList<ItemContainerItem> result = new ArrayList<ItemContainerItem>();
        for (Integer itemId : otherItems.keySet()) {
            ItemContainerItem otherItem = otherItems.get(itemId);
            if (otherItem.getId() == 0) continue;
            if (thisItems.containsKey(itemId)) {
                ItemContainerItem thisItem = thisItems.get(itemId);
                int quantityDifference = otherItem.getQuantity() - thisItem.getQuantity();
                if (quantityDifference <= 0) continue;
                result.add(new ItemContainerItem(itemId, quantityDifference));
                continue;
            }
            result.add(new ItemContainerItem(itemId, otherItem.getQuantity()));
        }
        return new ItemContainerState(this.playerName, result);
    }

    public Map<Integer, ItemContainerItem> getItemMap() {
        HashMap<Integer, ItemContainerItem> itemMap = new HashMap<Integer, ItemContainerItem>();
        for (ItemContainerItem itemContainerItem : this.items) {
            Integer id = itemContainerItem.getId();
            if (itemMap.containsKey(id)) {
                ((ItemContainerItem)itemMap.get(id)).addQuantity(itemContainerItem.getQuantity());
                continue;
            }
            itemMap.put(id, new ItemContainerItem(id, itemContainerItem.getQuantity()));
        }
        return itemMap;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    private boolean isItemValid(Item item, ItemManager itemManager) {
        if (item == null) {
            return false;
        }
        int id = item.getId();
        int quantity = item.getQuantity();
        if (itemManager != null) {
            boolean isPlaceholder = itemManager.getItemComposition(id).getPlaceholderTemplateId() != -1;
            return id >= 0 && quantity >= 0 && !isPlaceholder;
        }
        return false;
    }

    public List<Integer> asFlatList() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.items.size() * 2);
        for (ItemContainerItem item : this.items) {
            result.add(item.getId());
            result.add(item.getQuantity());
        }
        return result;
    }

    @Override
    public Object get() {
        return this.asFlatList();
    }

    @Override
    public String whoOwnsThis() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemContainerState)) {
            return false;
        }
        ItemContainerState other = (ItemContainerState)o;
        if (other.items.size() != this.items.size()) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).equals(other.items.get(i))) continue;
            return false;
        }
        return true;
    }
}

