/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import men.groupiron.ConsumableState;
import men.groupiron.LocationState;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class InteractingState
implements ConsumableState {
    private final transient String playerName;
    private final String name;
    private final int scale;
    private final int ratio;
    private final LocationState location;

    public InteractingState(String playerName, Actor actor, Client client) {
        this.playerName = playerName;
        this.scale = actor.getHealthScale();
        this.ratio = actor.getHealthRatio();
        this.name = actor.getName();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)actor.getLocalLocation());
        this.location = new LocationState(playerName, worldPoint);
    }

    @Override
    public Object get() {
        return this;
    }

    @Override
    public String whoOwnsThis() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractingState)) {
            return false;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getScale() {
        return this.scale;
    }

    public int getRatio() {
        return this.ratio;
    }

    public LocationState getLocation() {
        return this.location;
    }
}

