/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import com.google.inject.Provides;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import men.groupiron.AchievementDiaryState;
import men.groupiron.CollectionLogManager;
import men.groupiron.DataManager;
import men.groupiron.GroupIronmenTrackerConfig;
import men.groupiron.InteractingState;
import men.groupiron.ItemContainerState;
import men.groupiron.LocationState;
import men.groupiron.QuestState;
import men.groupiron.ResourcesState;
import men.groupiron.RunePouchState;
import men.groupiron.SkillState;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Group Ironmen Tracker")
public class GroupIronmenTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GroupIronmenTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GroupIronmenTrackerConfig config;
    @Inject
    private DataManager dataManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private CollectionLogManager collectionLogManager;
    @Inject
    ClientThread clientThread;
    private int itemsDeposited = 0;
    private static final int SECONDS_BETWEEN_UPLOADS = 1;
    private static final int SECONDS_BETWEEN_INFREQUENT_DATA_CHANGES = 60;
    private static final int DEPOSIT_ITEM = 0xC00002;
    private static final int DEPOSIT_INVENTORY = 0xC00004;
    private static final int DEPOSIT_EQUIPMENT = 0xC00006;
    private static final int CHATBOX_ENTERED = 681;
    private static final int GROUP_STORAGE_LOADER = 293;
    private static final int COLLECTION_LOG_INVENTORYID = 620;
    private static final Pattern COLLECTION_LOG_ITEM_PATTERN = Pattern.compile("New item added to your collection log: (.*)");
    private boolean notificationStarted = false;

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> this.collectionLogManager.initCollectionLog());
        log.info("Group Ironmen Tracker started!");
    }

    protected void shutDown() throws Exception {
        log.info("Group Ironmen Tracker stopped!");
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void submitToApi() {
        this.dataManager.submitToApi();
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS)
    public void updateThingsThatDoChangeOften() {
        if (this.doNotUseThisData()) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        String playerName = player.getName();
        this.dataManager.getResources().update(new ResourcesState(playerName, this.client));
        LocalPoint localPoint = player.getLocalLocation();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        this.dataManager.getPosition().update(new LocationState(playerName, worldPoint));
        this.dataManager.getRunePouch().update(new RunePouchState(playerName, this.client));
    }

    @Schedule(period=60L, unit=ChronoUnit.SECONDS)
    public void updateThingsThatDoNotChangeOften() {
        if (this.doNotUseThisData()) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.dataManager.getQuests().update(new QuestState(playerName, this.client));
        this.dataManager.getAchievementDiary().update(new AchievementDiaryState(playerName, this.client));
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        --this.itemsDeposited;
        this.updateInteracting();
        Widget groupStorageLoaderText = this.client.getWidget(293, 1);
        if (groupStorageLoaderText != null && groupStorageLoaderText.getText().equalsIgnoreCase("saving...")) {
            this.dataManager.getSharedBank().commitTransaction();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (this.doNotUseThisData()) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.dataManager.getSkills().update(new SkillState(playerName, this.client));
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.doNotUseThisData()) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        int id = event.getContainerId();
        ItemContainer container = event.getItemContainer();
        if (id == InventoryID.BANK.getId()) {
            this.dataManager.getDeposited().reset();
            this.dataManager.getBank().update(new ItemContainerState(playerName, container, this.itemManager));
        } else if (id == InventoryID.SEED_VAULT.getId()) {
            this.dataManager.getSeedVault().update(new ItemContainerState(playerName, container, this.itemManager));
        } else if (id == InventoryID.INVENTORY.getId()) {
            ItemContainerState newInventoryState = new ItemContainerState(playerName, container, this.itemManager, 28);
            if (this.itemsDeposited > 0) {
                this.updateDeposited(newInventoryState, (ItemContainerState)this.dataManager.getInventory().mostRecentState());
            }
            this.dataManager.getInventory().update(newInventoryState);
        } else if (id == InventoryID.EQUIPMENT.getId()) {
            ItemContainerState newEquipmentState = new ItemContainerState(playerName, container, this.itemManager, 14);
            if (this.itemsDeposited > 0) {
                this.updateDeposited(newEquipmentState, (ItemContainerState)this.dataManager.getEquipment().mostRecentState());
            }
            this.dataManager.getEquipment().update(newEquipmentState);
        } else if (id == InventoryID.GROUP_STORAGE.getId()) {
            this.dataManager.getSharedBank().update(new ItemContainerState(playerName, container, this.itemManager));
        } else if (id == 620) {
            this.collectionLogManager.updateCollection(new ItemContainerState(playerName, container, this.itemManager));
        }
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 681 && this.client.getWidget(WidgetInfo.DEPOSIT_BOX_INVENTORY_ITEMS_CONTAINER) != null) {
            this.itemsMayHaveBeenDeposited();
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        int param1 = event.getParam1();
        MenuAction menuAction = event.getMenuAction();
        if (menuAction == MenuAction.CC_OP && (param1 == 0xC00002 || param1 == 0xC00004 || param1 == 0xC00006)) {
            this.itemsMayHaveBeenDeposited();
        }
    }

    @Subscribe
    private void onInteractingChanged(InteractingChanged event) {
        if (event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        this.updateInteracting();
    }

    @Subscribe
    private void onChatMessage(ChatMessage chatMessage) {
        String itemName;
        if (this.doNotUseThisData()) {
            return;
        }
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        Matcher matcher = COLLECTION_LOG_ITEM_PATTERN.matcher(chatMessage.getMessage());
        if (matcher.find() && !StringUtils.isBlank((CharSequence)(itemName = Text.removeTags((String)matcher.group(1))))) {
            this.collectionLogManager.updateNewItem(itemName);
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.notificationStarted = true;
                break;
            }
            case 3347: {
                if (!this.notificationStarted) {
                    return;
                }
                String topText = this.client.getVarcStrValue(387);
                String bottomText = this.client.getVarcStrValue(388);
                if (topText.equalsIgnoreCase("Collection log")) {
                    String entry = Text.removeTags((String)bottomText).substring("New item:".length());
                    this.collectionLogManager.updateNewItem(entry);
                }
                this.notificationStarted = false;
            }
        }
    }

    private void itemsMayHaveBeenDeposited() {
        this.itemsDeposited = 2;
    }

    private void updateInteracting() {
        Actor actor;
        Player player = this.client.getLocalPlayer();
        if (player != null && (actor = player.getInteracting()) != null) {
            String playerName = player.getName();
            this.dataManager.getInteracting().update(new InteractingState(playerName, actor, this.client));
        }
    }

    private void updateDeposited(ItemContainerState newState, ItemContainerState previousState) {
        ItemContainerState deposited = newState.whatGotRemoved(previousState);
        this.dataManager.getDeposited().update(deposited);
    }

    private boolean doNotUseThisData() {
        return this.client.getGameState() != GameState.LOGGED_IN || this.client.getLocalPlayer() == null;
    }

    @Provides
    GroupIronmenTrackerConfig provideConfig(ConfigManager configManager) {
        return (GroupIronmenTrackerConfig)configManager.getConfig(GroupIronmenTrackerConfig.class);
    }
}

