/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import men.groupiron.ConsumableState;

public class DataState {
    private final AtomicReference<ConsumableState> state = new AtomicReference();
    private ConsumableState previousState;
    private final String key;
    private final boolean transactionBased;

    DataState() {
        this.key = "";
        this.transactionBased = false;
    }

    DataState(String key, boolean transactionBased) {
        this.key = key;
        this.transactionBased = transactionBased;
    }

    public void update(ConsumableState o) {
        if (!o.equals(this.previousState)) {
            this.previousState = o;
            if (!this.transactionBased) {
                this.state.set(o);
            }
        }
    }

    public Object consumeState(String whoIsUpdating) {
        return this.consumeState(whoIsUpdating, new HashMap<String, Object>());
    }

    public Object consumeState(Map<String, Object> output) {
        return this.consumeState((String)output.get("name"), output);
    }

    public Object consumeState(String whoIsUpdating, Map<String, Object> output) {
        String whoOwnsThis;
        ConsumableState consumedState = this.state.getAndSet(null);
        if (consumedState != null && (whoOwnsThis = consumedState.whoOwnsThis()) != null && whoOwnsThis.equals(whoIsUpdating)) {
            Object c = consumedState.get();
            output.put(this.key, c);
            return c;
        }
        return null;
    }

    public ConsumableState mostRecentState() {
        return this.previousState;
    }

    public void restoreState() {
        this.state.compareAndSet(null, this.previousState);
    }

    public void commitTransaction() {
        this.state.set(this.previousState);
    }
}

