/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import com.google.gson.Gson;
import java.util.EnumSet;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import men.groupiron.CollectionLogManager;
import men.groupiron.DataState;
import men.groupiron.DepositedItems;
import men.groupiron.GroupIronmenTrackerConfig;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.client.RuneLiteProperties;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DataManager {
    private static final Logger log = LoggerFactory.getLogger(DataManager.class);
    @Inject
    Client client;
    @Inject
    GroupIronmenTrackerConfig config;
    @Inject
    private Gson gson;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private CollectionLogManager collectionLogManager;
    private static final String PUBLIC_BASE_URL = "https://groupiron.men";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String USER_AGENT = "GroupIronmenTracker/1.5.3 RuneLite/" + RuneLiteProperties.getVersion();
    private boolean isMemberInGroup = false;
    private int skipNextNAttempts = 0;
    private final DataState inventory = new DataState("inventory", false);
    private final DataState bank = new DataState("bank", false);
    private final DataState equipment = new DataState("equipment", false);
    private final DataState sharedBank = new DataState("shared_bank", true);
    private final DataState resources = new DataState("stats", false);
    private final DataState skills = new DataState("skills", false);
    private final DataState quests = new DataState("quests", false);
    private final DataState position = new DataState("coordinates", false);
    private final DataState runePouch = new DataState("rune_pouch", false);
    private final DataState interacting = new DataState("interacting", false);
    private final DataState seedVault = new DataState("seed_vault", false);
    private final DataState achievementDiary = new DataState("diary_vars", false);
    private final DepositedItems deposited = new DepositedItems();

    public void submitToApi() {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null || this.isBadWorldType()) {
            return;
        }
        if (this.skipNextNAttempts-- > 0) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        String groupToken = this.config.authorizationToken().trim();
        if (groupToken.length() > 0) {
            String url;
            if (!this.isMemberInGroup) {
                boolean isMember = this.checkIfPlayerIsInGroup(groupToken, playerName);
                if (!isMember) {
                    this.skipNextNAttempts = 10;
                    return;
                }
                this.isMemberInGroup = true;
            }
            if ((url = this.getUpdateGroupMemberUrl()) == null) {
                return;
            }
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("name", playerName);
            this.inventory.consumeState(updates);
            this.bank.consumeState(updates);
            this.equipment.consumeState(updates);
            this.sharedBank.consumeState(updates);
            this.resources.consumeState(updates);
            this.skills.consumeState(updates);
            this.quests.consumeState(updates);
            this.position.consumeState(updates);
            this.runePouch.consumeState(updates);
            this.interacting.consumeState(updates);
            this.deposited.consumeState(updates);
            this.seedVault.consumeState(updates);
            this.achievementDiary.consumeState(updates);
            this.collectionLogManager.consumeCollections(updates);
            this.collectionLogManager.consumeNewItems(updates);
            if (updates.size() > 1) {
                try {
                    RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson(updates));
                    Request request = new Request.Builder().url(url).header("Authorization", groupToken).header("User-Agent", USER_AGENT).post(body).build();
                    Call call = this.okHttpClient.newCall(request);
                    try (Response response = call.execute();){
                        if (!response.isSuccessful()) {
                            this.skipNextNAttempts = 10;
                            if (response.code() == 401) {
                                this.isMemberInGroup = false;
                            }
                            this.restoreStateIfNothingUpdated();
                        }
                    }
                }
                catch (Exception _error) {
                    this.skipNextNAttempts = 10;
                    this.restoreStateIfNothingUpdated();
                }
            }
        }
    }

    private boolean checkIfPlayerIsInGroup(String groupToken, String playerName) {
        boolean bl;
        block9: {
            String url = this.amIMemberOfGroupUrl(playerName);
            if (url == null) {
                return false;
            }
            Request request = new Request.Builder().url(url).header("Authorization", groupToken).header("User-Agent", USER_AGENT).get().build();
            Call call = this.okHttpClient.newCall(request);
            Response response = call.execute();
            try {
                bl = response.isSuccessful();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception _error) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    private void restoreStateIfNothingUpdated() {
        this.inventory.restoreState();
        this.bank.restoreState();
        this.equipment.restoreState();
        this.sharedBank.restoreState();
        this.resources.restoreState();
        this.skills.restoreState();
        this.quests.restoreState();
        this.position.restoreState();
        this.runePouch.restoreState();
        this.interacting.restoreState();
        this.deposited.restoreState();
        this.seedVault.restoreState();
        this.achievementDiary.restoreState();
    }

    private String baseUrl() {
        String baseUrlOverride = this.config.baseUrlOverride().trim();
        if (baseUrlOverride.length() > 0) {
            return baseUrlOverride;
        }
        return PUBLIC_BASE_URL;
    }

    private String groupName() {
        String groupName = this.config.groupName().trim();
        if (groupName.length() == 0) {
            return null;
        }
        return groupName;
    }

    private String getUpdateGroupMemberUrl() {
        String baseUrl = this.baseUrl();
        String groupName = this.groupName();
        if (baseUrl == null || groupName == null) {
            return null;
        }
        return String.format("%s/api/group/%s/update-group-member", baseUrl, groupName);
    }

    private String amIMemberOfGroupUrl(String playerName) {
        String baseUrl = this.baseUrl();
        String groupName = this.groupName();
        if (baseUrl == null || groupName == null) {
            return null;
        }
        return String.format("%s/api/group/%s/am-i-in-group?member_name=%s", baseUrl, groupName, playerName);
    }

    private boolean isBadWorldType() {
        EnumSet worldTypes = this.client.getWorldType();
        for (WorldType worldType : worldTypes) {
            if (worldType != WorldType.SEASONAL && worldType != WorldType.DEADMAN && worldType != WorldType.TOURNAMENT_WORLD && worldType != WorldType.PVP_ARENA && worldType != WorldType.BETA_WORLD && worldType != WorldType.QUEST_SPEEDRUNNING) continue;
            return true;
        }
        return false;
    }

    public DataState getInventory() {
        return this.inventory;
    }

    public DataState getBank() {
        return this.bank;
    }

    public DataState getEquipment() {
        return this.equipment;
    }

    public DataState getSharedBank() {
        return this.sharedBank;
    }

    public DataState getResources() {
        return this.resources;
    }

    public DataState getSkills() {
        return this.skills;
    }

    public DataState getQuests() {
        return this.quests;
    }

    public DataState getPosition() {
        return this.position;
    }

    public DataState getRunePouch() {
        return this.runePouch;
    }

    public DataState getInteracting() {
        return this.interacting;
    }

    public DataState getSeedVault() {
        return this.seedVault;
    }

    public DataState getAchievementDiary() {
        return this.achievementDiary;
    }

    public DepositedItems getDeposited() {
        return this.deposited;
    }
}

