/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import java.util.HashMap;
import java.util.List;
import men.groupiron.ConsumableState;
import men.groupiron.ItemContainerState;

public class CollectionPageState
implements ConsumableState {
    private final ItemContainerState items;
    private final String pageName;
    private final int tabIdx;
    private final List<Integer> completionCounts;

    public CollectionPageState(int tabIdx, String pageName, ItemContainerState items, List<Integer> completionCounts) {
        this.tabIdx = tabIdx;
        this.pageName = pageName;
        this.items = items;
        this.completionCounts = completionCounts;
    }

    @Override
    public Object get() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tab", this.tabIdx);
        result.put("page_name", this.pageName);
        result.put("items", this.items.get());
        result.put("completion_counts", this.completionCounts);
        return result;
    }

    @Override
    public String whoOwnsThis() {
        return this.items.whoOwnsThis();
    }

    public boolean equals(Object o) {
        boolean completionCountsEqual;
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionPageState)) {
            return false;
        }
        CollectionPageState other = (CollectionPageState)o;
        boolean bl = completionCountsEqual = this.completionCounts.size() == other.completionCounts.size();
        if (completionCountsEqual) {
            for (int i = 0; i < this.completionCounts.size() && (completionCountsEqual = this.completionCounts.get(i).equals(other.completionCounts.get(i))); ++i) {
            }
        }
        return completionCountsEqual && this.tabIdx == other.tabIdx && this.pageName.equals(other.pageName) && this.items.equals(other.items);
    }
}

