/*
 * Decompiled with CFR 0.152.
 */
package men.groupiron;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import men.groupiron.CollectionPageState;
import men.groupiron.DataState;
import men.groupiron.ItemContainerState;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.ItemComposition;
import net.runelite.api.StructComposition;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CollectionLogManager {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogManager.class);
    @Inject
    Client client;
    @Inject
    ItemManager itemManager;
    private final Map<String, DataState> collections = new HashMap<String, DataState>();
    private String playerName;
    private Set<String> consumedNewItems = null;
    private Set<String> newItems = null;
    private static final int collectionLogTabVarbit = 6905;
    private static final int collectionLogPageVarbit = 6906;
    static final Pattern COLLECTION_LOG_COUNT_PATTERN = Pattern.compile(".+:(.+)");
    static Map<String, Set<Integer>> pageItems;
    static Map<Integer, Map<Integer, String>> pageNameLookup;
    private static final List<Integer> COLLECTION_LOG_TAB_STRUCT_IDS;
    private static final int COLLECTION_LOG_PAGE_NAME_PARAM_ID = 689;
    private static final int COLLECTION_LOG_TAB_ENUM_PARAM_ID = 683;
    private static final int COLLECTION_LOG_PAGE_ITEMS_ENUM_PARAM_ID = 690;

    public void initCollectionLog() {
        pageItems = new HashMap<String, Set<Integer>>();
        pageNameLookup = new HashMap<Integer, Map<Integer, String>>();
        int tabIdx = 0;
        for (Integer structId : COLLECTION_LOG_TAB_STRUCT_IDS) {
            StructComposition tabStruct = this.client.getStructComposition(structId.intValue());
            int tabEnumId = tabStruct.getIntValue(683);
            EnumComposition tabEnum = this.client.getEnum(tabEnumId);
            Map pageIdToName = pageNameLookup.computeIfAbsent(tabIdx, k -> new HashMap());
            int pageIdx = 0;
            int[] nArray = tabEnum.getIntVals();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer pageStructId = nArray[i];
                StructComposition pageStruct = this.client.getStructComposition(pageStructId.intValue());
                String pageName = pageStruct.getStringValue(689);
                int pageItemsEnumId = pageStruct.getIntValue(690);
                EnumComposition pageItemsEnum = this.client.getEnum(pageItemsEnumId);
                pageIdToName.put(pageIdx, pageName);
                Set items = pageItems.computeIfAbsent(pageName, k -> new HashSet());
                int[] nArray2 = pageItemsEnum.getIntVals();
                int n2 = nArray2.length;
                for (int j = 0; j < n2; ++j) {
                    Integer pageItemId = nArray2[j];
                    ItemComposition itemComposition = this.itemManager.getItemComposition(pageItemId.intValue());
                    items.add(itemComposition.getId());
                }
                ++pageIdx;
            }
            ++tabIdx;
        }
    }

    public void updateCollection(ItemContainerState containerState) {
        int pageIdx;
        Widget collectionLogHeader = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_HEADER);
        if (collectionLogHeader == null || collectionLogHeader.isHidden()) {
            return;
        }
        Widget[] collectionLogHeaderChildren = collectionLogHeader.getChildren();
        if (collectionLogHeaderChildren == null || collectionLogHeaderChildren.length == 0) {
            return;
        }
        ArrayList<Integer> completionCounts = new ArrayList<Integer>();
        for (int i = 2; i < collectionLogHeaderChildren.length; ++i) {
            String text = Text.removeTags((String)collectionLogHeaderChildren[i].getText());
            Matcher matcher = COLLECTION_LOG_COUNT_PATTERN.matcher(text);
            if (!matcher.find()) continue;
            try {
                Integer count = Integer.valueOf(matcher.group(1).trim());
                completionCounts.add(count);
                continue;
            }
            catch (Exception count) {
                // empty catch block
            }
        }
        int tabIdx = this.client.getVarbitValue(6905);
        String pageName = this.getPageName(tabIdx, pageIdx = this.client.getVarbitValue(6906));
        if (!StringUtils.isBlank((CharSequence)pageName)) {
            DataState pageDataState = this.collections.computeIfAbsent(pageName + tabIdx, k -> new DataState());
            pageDataState.update(new CollectionPageState(tabIdx, pageName, containerState, completionCounts));
        }
    }

    private String getPageName(int tabIdx, int pageIdx) {
        Map<Integer, String> x = pageNameLookup.get(tabIdx);
        if (x != null) {
            return x.get(pageIdx);
        }
        return null;
    }

    public synchronized void updateNewItem(String item) {
        String playerName = this.client.getLocalPlayer().getName();
        if (playerName != null) {
            if (!playerName.equals(this.playerName) || this.newItems == null) {
                this.playerName = playerName;
                this.newItems = new HashSet<String>();
            }
            this.newItems.add(item.trim());
        }
    }

    public synchronized void consumeNewItems(Map<String, Object> output) {
        if (this.newItems != null && output.get("name").equals(this.playerName)) {
            output.put("collection_log_new", this.newItems);
        }
        this.consumedNewItems = this.newItems;
        this.newItems = null;
    }

    public void consumeCollections(Map<String, Object> output) {
        if (this.collections.isEmpty()) {
            return;
        }
        ArrayList<Object> collectionLogOutput = new ArrayList<Object>();
        String whoIsUpdating = (String)output.get("name");
        for (DataState pageDataState : this.collections.values()) {
            Object result = pageDataState.consumeState(whoIsUpdating);
            if (result == null) continue;
            collectionLogOutput.add(result);
        }
        if (!collectionLogOutput.isEmpty()) {
            output.put("collection_log", collectionLogOutput);
        }
    }

    public void restoreCollections() {
        for (DataState pageDataState : this.collections.values()) {
            pageDataState.restoreState();
        }
    }

    public synchronized void restoreNewCollections() {
        if (this.consumedNewItems == null) {
            return;
        }
        for (String item : this.consumedNewItems) {
            this.updateNewItem(item);
        }
        this.consumedNewItems = null;
    }

    static {
        COLLECTION_LOG_TAB_STRUCT_IDS = ImmutableList.of((Object)471, (Object)472, (Object)473, (Object)474, (Object)475);
    }
}

