/*
 * Decompiled with CFR 0.152.
 */
package com.specimencleaning;

import com.specimencleaning.SpecimenCleaningConfig;
import java.awt.Color;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SpecimenCleaningSession {
    private static final Logger log = LoggerFactory.getLogger(SpecimenCleaningSession.class);
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private SpecimenCleaningConfig config;
    private int uncleanedFindCount;
    private int artefactCount;
    private int antiqueLampCount;
    private Instant lastActionTime = null;

    void incrementItemObtained(int itemId) {
        switch (itemId) {
            case 11175: {
                ++this.uncleanedFindCount;
                break;
            }
            case 11176: 
            case 11177: 
            case 11178: 
            case 11183: {
                ++this.artefactCount;
                break;
            }
            case 11185: 
            case 11186: 
            case 11187: 
            case 11188: 
            case 11189: {
                ++this.antiqueLampCount;
                if (!this.config.showNotifs()) break;
                String formattedMessage = new ChatMessageBuilder().append(Color.RED, "You found an antique lamp!").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(formattedMessage).build());
            }
        }
    }

    void resetTracker() {
        this.setLastActionTime(null);
        this.uncleanedFindCount = 0;
        this.artefactCount = 0;
        if (!this.config.neverResetLamps()) {
            this.antiqueLampCount = 0;
        }
        if (this.config.showNotifs()) {
            String formattedMessage = new ChatMessageBuilder().append("Specimen cleaning tracker reset.").build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(formattedMessage).build());
        }
    }

    public int getUncleanedFindCount() {
        return this.uncleanedFindCount;
    }

    public int getArtefactCount() {
        return this.artefactCount;
    }

    public int getAntiqueLampCount() {
        return this.antiqueLampCount;
    }

    public Instant getLastActionTime() {
        return this.lastActionTime;
    }

    public void setLastActionTime(Instant lastActionTime) {
        this.lastActionTime = lastActionTime;
    }
}

