/*
 * Decompiled with CFR 0.152.
 */
package com.specimencleaning;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.inject.Provides;
import com.specimencleaning.SpecimenCleaningConfig;
import com.specimencleaning.SpecimenCleaningOverlay;
import com.specimencleaning.SpecimenCleaningSession;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Specimen Cleaning", description="Show Varrock Museum specimen cleaning stats", tags={"overlay", "minigame", "Varrock", "museum"})
public class SpecimenCleaningPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpecimenCleaningPlugin.class);
    private static final Set<Integer> REGIONS = ImmutableSet.of((Object)12853, (Object)13109);
    private static final Set<Integer> TILES_X = IntStream.rangeClosed(3253, 3267).boxed().collect(Collectors.toSet());
    private static final Set<Integer> TILES_Y = IntStream.rangeClosed(3442, 3446).boxed().collect(Collectors.toSet());
    private static final Set<Integer> ITEMS = ImmutableSet.of((Object)11175, (Object)11176, (Object)11177, (Object)11178, (Object)11183, (Object)11185, (Object[])new Integer[]{11186, 11187, 11188, 11189});
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SpecimenCleaningOverlay overlay;
    @Inject
    private SpecimenCleaningConfig config;
    @Inject
    private SpecimenCleaningSession session;
    private Multiset<Integer> lastInventory;

    @Provides
    SpecimenCleaningConfig provideConfig(ConfigManager configManager) {
        return (SpecimenCleaningConfig)configManager.getConfig(SpecimenCleaningConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (!this.isPlayerInArea() || container != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        HashMultiset currentInventory = HashMultiset.create();
        Arrays.stream(container.getItems()).filter(item -> ITEMS.contains(item.getId())).forEach(arg_0 -> SpecimenCleaningPlugin.lambda$onItemContainerChanged$1((Multiset)currentInventory, arg_0));
        if (this.lastInventory != null) {
            Multiset delta = Multisets.difference((Multiset)currentInventory, this.lastInventory);
            delta.forEach(itemId -> this.session.incrementItemObtained((int)itemId));
            if (delta.size() > 0) {
                this.session.setLastActionTime(Instant.now());
            }
        }
        this.lastInventory = currentInventory;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.config.timeout() > 0 && this.session.getLastActionTime() != null) {
            Duration timeoutMinutes = Duration.ofMinutes(this.config.timeout());
            Duration sinceAction = Duration.between(this.session.getLastActionTime(), Instant.now());
            if (sinceAction.compareTo(timeoutMinutes) >= 0) {
                this.session.resetTracker();
            }
        }
    }

    boolean isPlayerInArea() {
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        WorldPoint location = this.client.getLocalPlayer().getWorldLocation();
        int currRegion = location.getRegionID();
        int currX = location.getX();
        int currY = location.getY();
        return REGIONS.contains(currRegion) && TILES_X.contains(currX) && TILES_Y.contains(currY);
    }

    private static /* synthetic */ void lambda$onItemContainerChanged$1(Multiset currentInventory, Item item) {
        currentInventory.add((Object)item.getId(), item.getQuantity());
    }
}

