/*
 * Decompiled with CFR 0.152.
 */
package com.specimencleaning;

import com.specimencleaning.SpecimenCleaningPlugin;
import com.specimencleaning.SpecimenCleaningSession;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class SpecimenCleaningOverlay
extends OverlayPanel {
    private final SpecimenCleaningPlugin plugin;
    private final SpecimenCleaningSession specimenCleaningSession;

    @Inject
    SpecimenCleaningOverlay(SpecimenCleaningPlugin plugin, SpecimenCleaningSession specimenCleaningSession) {
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.plugin = plugin;
        this.specimenCleaningSession = specimenCleaningSession;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isPlayerInArea()) {
            return null;
        }
        SpecimenCleaningSession session = this.specimenCleaningSession;
        int uncleanedFindCount = session.getUncleanedFindCount();
        int artefactCount = session.getArtefactCount();
        int antiqueLampCount = session.getAntiqueLampCount();
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Cleaning Tracker").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Specimen:").right(Integer.toString(uncleanedFindCount)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Artefacts:").right(Integer.toString(artefactCount)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("XP Lamps:").right(Integer.toString(antiqueLampCount)).build());
        return super.render(graphics);
    }
}

