/*
 * Decompiled with CFR 0.152.
 */
package com.scoutingstats;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.scoutingstats.ScoutingStatsConfig;
import com.scoutingstats.ScoutingStatsOverlay;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Scouting Stats", description="Super Duper Omega COX Scout Counter")
public class ScoutingStatsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ScoutingStatsPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private ScoutingStatsConfig config;
    private ScoutingStatsOverlay ScoutingStatsOverlay = null;
    private static final int OUTSIDE_COX_LOBBY = 4919;
    public int Entries = 0;
    public int Exits = 0;
    public boolean flag = false;

    protected void startUp() {
        this.ScoutingStatsOverlay = new ScoutingStatsOverlay(this, this.Entries, this.Exits);
        this.overlayManager.add((Overlay)this.ScoutingStatsOverlay);
        this.updateOverlay();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.ScoutingStatsOverlay);
    }

    protected void updateOverlay() {
        this.ScoutingStatsOverlay.Entries = this.Entries;
        this.ScoutingStatsOverlay.Exits = this.Exits;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean outsideRaidLobby;
        boolean isInRaid = this.client.getVarbitValue(5432) == 1;
        boolean bl = outsideRaidLobby = this.client.getLocalPlayer().getWorldLocation().getRegionID() == 4919;
        if (isInRaid && !this.flag) {
            ++this.Entries;
            this.flag = true;
        } else if (this.flag && outsideRaidLobby) {
            ++this.Exits;
            this.flag = false;
        }
    }

    @Provides
    ScoutingStatsConfig provideConfig(ConfigManager configManager) {
        return (ScoutingStatsConfig)configManager.getConfig(ScoutingStatsConfig.class);
    }
}

