/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.swing;

import com.creatorskit.Character;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.programming.MovementType;
import com.creatorskit.programming.Program;
import com.creatorskit.programming.ProgramComp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class ProgramPanel
extends JFrame {
    @Inject
    private ClientThread clientThread;
    private final CreatorsPlugin plugin;
    private final BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"/panelicon.png");
    private final GridBagConstraints c = new GridBagConstraints();
    private final JPanel allPanel = new JPanel();
    private final Random random = new Random();

    @Inject
    public ProgramPanel(@Nullable Client client, ClientThread clientThread, CreatorsPlugin plugin) {
        this.clientThread = clientThread;
        this.plugin = plugin;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setTitle("Creators Kit Programmer");
        this.setIconImage(this.icon);
        this.setPreferredSize(new Dimension(300, 300));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.allPanel);
        this.add(scrollPane);
        this.allPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.allPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.allPanel.setLayout(new GridLayout(0, 7));
        this.pack();
    }

    public void createProgramPanel(Character character, JPanel programPanel, JLabel nameLabel, JSpinner idleAnimSpinner) {
        programPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        programPanel.setBorder(new LineBorder(ColorScheme.MEDIUM_GRAY_COLOR));
        programPanel.setLayout(new GridBagLayout());
        this.c.fill = 3;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        nameLabel.setText(character.getName());
        nameLabel.setHorizontalAlignment(0);
        nameLabel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        programPanel.add((Component)nameLabel, this.c);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(0, 1));
        textPanel.setBorder(new EmptyBorder(2, 2, 2, 0));
        textPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        programPanel.add((Component)textPanel, this.c);
        JLabel idleAnimLabel = new JLabel("Idle animation:");
        idleAnimLabel.setHorizontalAlignment(4);
        idleAnimLabel.setToolTipText("Set the animation for when the object isn't moving");
        JLabel walkAnimLabel = new JLabel("Active animation:");
        walkAnimLabel.setHorizontalAlignment(4);
        walkAnimLabel.setToolTipText("Set the animation for when the object is moving");
        JLabel speedLabel = new JLabel("Speed:");
        speedLabel.setHorizontalAlignment(4);
        speedLabel.setToolTipText("Set how fast the object moves");
        JLabel turnSpeedLabel = new JLabel("Turn speed:");
        turnSpeedLabel.setHorizontalAlignment(4);
        turnSpeedLabel.setToolTipText("Set how fast the object turns. Set to 0 for no turning");
        JLabel movementTypeLabel = new JLabel("Movement Type:");
        movementTypeLabel.setHorizontalAlignment(4);
        movementTypeLabel.setToolTipText("Determines the terrain on which the object can travel");
        JLabel loopLabel = new JLabel("Loop:");
        loopLabel.setHorizontalAlignment(4);
        loopLabel.setToolTipText("Set whether this program should loop once finished");
        textPanel.add(idleAnimLabel);
        textPanel.add(walkAnimLabel);
        textPanel.add(speedLabel);
        textPanel.add(turnSpeedLabel);
        textPanel.add(movementTypeLabel);
        textPanel.add(loopLabel);
        this.c.gridx = 1;
        this.c.gridy = 1;
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridLayout(0, 1));
        optionsPanel.setBorder(new EmptyBorder(2, 0, 2, 2));
        optionsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        programPanel.add((Component)optionsPanel, this.c);
        Program program = character.getProgram();
        ProgramComp comp = program.getComp();
        idleAnimSpinner.setModel(new SpinnerNumberModel(comp.getIdleAnim(), -1, 9999, 1));
        idleAnimSpinner.addChangeListener(e -> {
            int idleAnim = (Integer)idleAnimSpinner.getValue();
            comp.setIdleAnim(idleAnim);
            character.getAnimationSpinner().setValue(idleAnim);
        });
        optionsPanel.add(idleAnimSpinner);
        JSpinner walkAnimSpinner = new JSpinner(new SpinnerNumberModel(comp.getWalkAnim(), -1, 9999, 1));
        walkAnimSpinner.addChangeListener(e -> comp.setWalkAnim((Integer)walkAnimSpinner.getValue()));
        optionsPanel.add(walkAnimSpinner);
        JSpinner speedSpinner = new JSpinner(new SpinnerNumberModel(comp.getSpeed(), 0.0, 2.0, 1.0));
        speedSpinner.addChangeListener(e -> comp.setSpeed((Double)speedSpinner.getValue()));
        optionsPanel.add(speedSpinner);
        JSpinner turnSpeedSpinner = new JSpinner();
        turnSpeedSpinner.setValue(comp.getTurnSpeed());
        turnSpeedSpinner.addChangeListener(e -> comp.setTurnSpeed((Integer)turnSpeedSpinner.getValue()));
        optionsPanel.add(turnSpeedSpinner);
        JComboBox<MovementType> movementBox = new JComboBox<MovementType>();
        movementBox.addItem(MovementType.NORMAL);
        movementBox.addItem(MovementType.WATERBORNE);
        movementBox.addItem(MovementType.GHOST);
        movementBox.addItemListener(e -> {
            comp.setMovementType((MovementType)((Object)((Object)movementBox.getSelectedItem())));
            this.plugin.updateProgramPath(program, false, character.isInInstance());
        });
        movementBox.setSelectedItem((Object)comp.getMovementType());
        optionsPanel.add(movementBox);
        JCheckBox loopCheckBox = new JCheckBox();
        loopCheckBox.setFocusable(false);
        loopCheckBox.setSelected(comp.isLoop());
        loopCheckBox.addActionListener(e -> comp.setLoop(loopCheckBox.isSelected()));
        optionsPanel.add(loopCheckBox);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        JButton colourButton = new JButton();
        colourButton.setText("Reroll Colour");
        colourButton.setToolTipText("Rerolls a new random colour for the path");
        colourButton.setFocusable(false);
        colourButton.addActionListener(e -> comp.setColor(this.getRandomColor()));
        programPanel.add((Component)colourButton, this.c);
        this.allPanel.add(programPanel);
        this.repaint();
        this.revalidate();
    }

    public void removeProgramPanel(JPanel panel) {
        this.allPanel.remove(panel);
        this.repaint();
        this.revalidate();
    }

    private Color getRandomColor() {
        float r = this.random.nextFloat();
        float g = this.random.nextFloat();
        float b = this.random.nextFloat();
        return new Color(r, g, b);
    }

    public JPanel getAllPanel() {
        return this.allPanel;
    }
}

