/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.swing;

import com.creatorskit.Character;
import com.creatorskit.CreatorsConfig;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.models.BodyPart;
import com.creatorskit.models.CustomModel;
import com.creatorskit.models.CustomModelComp;
import com.creatorskit.models.CustomModelType;
import com.creatorskit.models.DetailedModel;
import com.creatorskit.models.LightingStyle;
import com.creatorskit.models.ModelFinder;
import com.creatorskit.models.ModelStats;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import net.runelite.api.Client;
import net.runelite.api.RuneLiteObject;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelOrganizer
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(ModelOrganizer.class);
    private final Client client;
    private final CreatorsPlugin plugin;
    private final ClientThread clientThread;
    private final CreatorsConfig config;
    private final BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), (String)"/panelicon.png");
    private final BufferedImage CLEAR = ImageUtil.loadImageResource(this.getClass(), (String)"/Clear.png");
    private final BufferedImage ANVIL = ImageUtil.loadImageResource(this.getClass(), (String)"/Anvil.png");
    private final BufferedImage SAVE = ImageUtil.loadImageResource(this.getClass(), (String)"/Save.png");
    private final BufferedImage TRANSMOG = ImageUtil.loadImageResource(this.getClass(), (String)"/Transmog.png");
    private final HashMap<CustomModel, JPanel> panelMap = new HashMap();
    JPanel modelPane = new JPanel();
    GridBagConstraints c = new GridBagConstraints();
    public static final File MODELS_DIR = new File(RuneLite.RUNELITE_DIR, "creatorskit");

    @Inject
    public ModelOrganizer(Client client, CreatorsPlugin plugin, ClientThread clientThread, CreatorsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.config = config;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.setTitle("Creator's Kit Model Organizer");
        this.setIconImage(this.icon);
        this.setPreferredSize(new Dimension(1100, 300));
        this.c.fill = 1;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridheight = 4;
        JLabel organizerLabel = new JLabel("Model Organizer");
        organizerLabel.setHorizontalAlignment(0);
        organizerLabel.setFont(FontManager.getRunescapeBoldFont());
        this.add((Component)organizerLabel, this.c);
        this.modelPane.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.modelPane.setLayout(new GridLayout(0, 10, 8, 8));
        this.c.weightx = 0.1;
        this.c.gridx = 2;
        this.c.gridy = 0;
        this.c.gridheight = 1;
        JLabel searcherLabel = new JLabel("Cache Searcher");
        searcherLabel.setHorizontalAlignment(0);
        searcherLabel.setFont(FontManager.getRunescapeBoldFont());
        this.add((Component)searcherLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 1;
        JSpinner idSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        idSpinner.setToolTipText("Choose the NPC or Object Id to find");
        this.add((Component)idSpinner, this.c);
        this.c.gridx = 2;
        this.c.gridy = 2;
        JComboBox<CustomModelType> modelTypeComboBox = new JComboBox<CustomModelType>();
        modelTypeComboBox.addItem(CustomModelType.CACHE_NPC);
        modelTypeComboBox.addItem(CustomModelType.CACHE_OBJECT);
        modelTypeComboBox.setFocusable(false);
        modelTypeComboBox.setToolTipText("Pick which part of the cache to search");
        this.add(modelTypeComboBox, this.c);
        this.c.gridx = 2;
        this.c.gridy = 3;
        JButton addCustomModelButton = new JButton("Add Custom Model");
        addCustomModelButton.setFocusable(false);
        addCustomModelButton.setToolTipText("Add the chosen NPC or Object as a Custom Model");
        this.add((Component)addCustomModelButton, this.c);
        addCustomModelButton.addActionListener(e -> {
            CustomModelType type = (CustomModelType)((Object)((Object)modelTypeComboBox.getSelectedItem()));
            if (type == null) {
                return;
            }
            int id = (Integer)idSpinner.getValue();
            plugin.cacheToCustomModel(type, id);
        });
        this.c.gridx = 3;
        this.c.gridy = 0;
        this.c.gridheight = 2;
        JButton loadButton = new JButton("Load Custom Model");
        loadButton.setFocusable(false);
        loadButton.setToolTipText("Loads a previously forged and saved Custom Model");
        this.add((Component)loadButton, this.c);
        loadButton.addActionListener(e -> this.openLoadDialog());
        this.c.gridx = 3;
        this.c.gridy = 2;
        this.c.gridheight = 2;
        JButton clearButton = new JButton("Clear Unused Models");
        clearButton.setFocusable(false);
        clearButton.setToolTipText("Clears all unused models from Custom Model dropdown menus");
        this.add((Component)clearButton, this.c);
        clearButton.addActionListener(e -> {
            ArrayList<CustomModel> unusedModels = new ArrayList<CustomModel>();
            CustomModel transmogModel = plugin.getTransmogModel();
            for (int i = 0; i < plugin.getStoredModels().size(); ++i) {
                CustomModel customModel = plugin.getStoredModels().get(i);
                if (customModel == transmogModel) continue;
                boolean isBeingUsed = false;
                for (Character character : plugin.getCharacters()) {
                    if (character.getStoredModel() != customModel) continue;
                    isBeingUsed = true;
                    break;
                }
                if (isBeingUsed) continue;
                unusedModels.add(customModel);
            }
            for (CustomModel customModel : unusedModels) {
                plugin.removeCustomModel(customModel);
            }
        });
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 19;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 4;
        this.c.gridheight = 1;
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.modelPane);
        this.add((Component)scrollPane, this.c);
        this.revalidate();
        this.pack();
    }

    public void createModelPanel(CustomModel model) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1, 2, 2));
        panel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        panel.setBorder(new LineBorder(ColorScheme.MEDIUM_GRAY_COLOR, 1));
        this.modelPane.add(panel);
        JTextField textField = new JTextField();
        textField.setText(model.getComp().getName());
        textField.setHorizontalAlignment(0);
        panel.add(textField);
        this.panelMap.put(model, panel);
        textField.addActionListener(e -> {
            model.getComp().setName(textField.getText());
            this.plugin.updatePanelComboBoxes();
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 0, 4, 4));
        panel.add(buttonsPanel);
        JButton deleteButton = new JButton(new ImageIcon(this.CLEAR));
        deleteButton.setFocusable(false);
        deleteButton.setToolTipText("Remove this model from all Objects and dropdown menus");
        deleteButton.addActionListener(e -> this.plugin.removeCustomModel(model));
        buttonsPanel.add(deleteButton);
        JButton anvilButton = new JButton(new ImageIcon(this.ANVIL));
        anvilButton.setFocusable(false);
        anvilButton.setToolTipText("Send this model to the Anvil");
        buttonsPanel.add(anvilButton);
        anvilButton.addActionListener(e -> this.plugin.customModelToAnvil(model));
        JButton saveButton = new JButton(new ImageIcon(this.SAVE));
        saveButton.setFocusable(false);
        saveButton.setToolTipText("Save this model for future use");
        buttonsPanel.add(saveButton);
        saveButton.addActionListener(e -> this.openSaveDialog(model, textField.getText()));
        JButton transmogButton = new JButton(new ImageIcon(this.TRANSMOG));
        transmogButton.setFocusable(false);
        transmogButton.setToolTipText("Set this as your player transmog");
        buttonsPanel.add(transmogButton);
        transmogButton.addActionListener(e -> this.setTransmog(model));
        this.revalidate();
        this.repaint();
    }

    public void removeModelPanel(CustomModel model) {
        JPanel panel = this.panelMap.get(model);
        this.modelPane.remove(panel);
        this.modelPane.updateUI();
        this.panelMap.remove(model);
        this.revalidate();
        this.repaint();
    }

    private void openLoadDialog() {
        MODELS_DIR.mkdirs();
        JFileChooser fileChooser = new JFileChooser(MODELS_DIR);
        fileChooser.setDialogTitle("Choose a model to load");
        JCheckBox priorityCheckbox = new JCheckBox("Set Priority?");
        priorityCheckbox.setToolTipText("May resolve some rendering issues by setting all faces to the same priority. Leave off if you're unsure");
        JComboBox<LightingStyle> comboBox = new JComboBox<LightingStyle>();
        comboBox.setToolTipText("Sets the lighting style");
        comboBox.addItem(LightingStyle.DEFAULT);
        comboBox.addItem(LightingStyle.ACTOR);
        comboBox.addItem(LightingStyle.NONE);
        comboBox.setFocusable(false);
        JPanel accessory = new JPanel();
        accessory.setLayout(new GridLayout(0, 1));
        accessory.add(priorityCheckbox);
        accessory.add(comboBox);
        fileChooser.setAccessory(accessory);
        int option = fileChooser.showOpenDialog(fileChooser);
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            String name = selectedFile.getName();
            if (name.endsWith(".json")) {
                name = this.replaceLast(name, ".json");
            }
            if (name.endsWith(".txt")) {
                name = this.replaceLast(name, ".txt");
            }
            this.plugin.loadCustomModel(selectedFile, priorityCheckbox.isSelected(), (LightingStyle)((Object)comboBox.getSelectedItem()), name);
        }
    }

    private String replaceLast(String string, String from) {
        int lastIndex = string.lastIndexOf(from);
        if (lastIndex < 0) {
            return string;
        }
        String tail = string.substring(lastIndex).replaceFirst(from, "");
        return string.substring(0, lastIndex) + tail;
    }

    private void openSaveDialog(CustomModel customModel, String name) {
        File outputDir = MODELS_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getName().endsWith(".json")) {
                    f = new File(f.getPath() + ".json");
                }
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists, overwrite?", "Warning", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File(name));
        fileChooser.setDialogTitle("Save Custom Model");
        int option = fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith(".json")) {
                selectedFile = new File(selectedFile.getPath() + ".json");
            }
            this.saveToFile(selectedFile, customModel);
        }
    }

    public void saveToFile(File file, CustomModel customModel) {
        try {
            FileWriter writer = new FileWriter(file, false);
            DetailedModel[] detailedModels = customModel.getComp().getDetailedModels();
            if (detailedModels == null) {
                detailedModels = this.modelToDetailedPanels(customModel);
            }
            String string = this.plugin.gson.toJson((Object)detailedModels);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            log.debug("Error when saving Custom Model to file");
        }
    }

    private DetailedModel[] modelToDetailedPanels(CustomModel customModel) {
        CustomModelComp comp = customModel.getComp();
        CustomModelType type = comp.getType();
        ModelStats[] modelStats = customModel.getComp().getModelStats();
        DetailedModel[] detailedModels = new DetailedModel[modelStats.length];
        int group = 1;
        if (type == CustomModelType.CACHE_NPC) {
            group = 8;
        }
        if (type == CustomModelType.CACHE_PLAYER) {
            group = 9;
        }
        for (int i = 0; i < modelStats.length; ++i) {
            DetailedModel detailedModel;
            ModelStats modelStat = modelStats[i];
            String recolFrom = ModelFinder.shortArrayToString(modelStat.getRecolourFrom());
            String recolTo = ModelFinder.shortArrayToString(modelStat.getRecolourTo());
            String bodyPart = "Name";
            if (type == CustomModelType.CACHE_PLAYER) {
                bodyPart = "Item";
            }
            if (modelStat.getBodyPart() != BodyPart.NA) {
                bodyPart = modelStat.getBodyPart().toString();
            }
            detailedModels[i] = detailedModel = new DetailedModel(bodyPart, modelStat.getModelId(), group, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, recolTo, recolFrom);
        }
        return detailedModels;
    }

    public void setTransmog(CustomModel customModel) {
        RuneLiteObject transmog = this.plugin.getTransmog();
        if (transmog == null) {
            transmog = this.client.createRuneLiteObject();
            this.plugin.setTransmog(transmog);
        }
        this.plugin.setTransmogModel(customModel);
        transmog.setModel(customModel.getModel());
        transmog.setShouldLoop(true);
        transmog.setRadius(this.config.transmogRadius());
    }
}

