/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.swing;

import com.creatorskit.CreatorsPlugin;
import com.creatorskit.models.CustomModel;
import com.creatorskit.models.CustomModelComp;
import com.creatorskit.models.CustomModelType;
import com.creatorskit.models.DetailedModel;
import com.creatorskit.models.LightingStyle;
import com.creatorskit.swing.ComplexPanel;
import com.creatorskit.swing.GroupPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.runelite.api.Client;
import net.runelite.api.JagexColor;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAnvil
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(ModelAnvil.class);
    private ClientThread clientThread;
    private final Client client;
    private final CreatorsPlugin plugin;
    private final BufferedImage ICON = ImageUtil.loadImageResource(this.getClass(), (String)"/panelicon.png");
    private final BufferedImage DUPLICATE = ImageUtil.loadImageResource(this.getClass(), (String)"/Duplicate.png");
    private final BufferedImage CLOSE = ImageUtil.loadImageResource(this.getClass(), (String)"/Close.png");
    private final BufferedImage ARROW_LEFT = ImageUtil.loadImageResource(this.getClass(), (String)"/Arrow_Left.png");
    private final BufferedImage ARROW_RIGHT = ImageUtil.loadImageResource(this.getClass(), (String)"/Arrow_Right.png");
    private final BufferedImage ARROW_DOWN = ImageUtil.loadImageResource(this.getClass(), (String)"/Arrow_Down.png");
    private final BufferedImage ARROW_UP = ImageUtil.loadImageResource(this.getClass(), (String)"/Arrow_Up.png");
    private final BufferedImage TRANSLATE = ImageUtil.loadImageResource(this.getClass(), (String)"/Translate.png");
    private final BufferedImage ROTATE = ImageUtil.loadImageResource(this.getClass(), (String)"/Rotate.png");
    private final BufferedImage TRANSLATE_SUBTILE = ImageUtil.loadImageResource(this.getClass(), (String)"/Translate subtile.png");
    private final BufferedImage SCALE = ImageUtil.loadImageResource(this.getClass(), (String)"/Scale.png");
    private final BufferedImage COPY_COLOURS = ImageUtil.loadImageResource(this.getClass(), (String)"/Copy_Colours.png");
    private final BufferedImage PASTE_COLOURS = ImageUtil.loadImageResource(this.getClass(), (String)"/Paste_Colours.png");
    private final Dimension SPINNER_DIMENSION = new Dimension(65, 25);
    private final ArrayList<ComplexPanel> complexPanels = new ArrayList();
    public static final File MODELS_DIR = new File(RuneLite.RUNELITE_DIR, "creatorskit");
    private final JPanel complexMode = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane();
    private final GridBagConstraints c = new GridBagConstraints();
    private HashMap<Short, Short> copiedColourMap = new HashMap();
    private final int COMPLEX_GRID_COLUMNS = 3;

    @Inject
    public ModelAnvil(Client client, ClientThread clientThread, CreatorsPlugin plugin) {
        this.client = client;
        this.clientThread = clientThread;
        this.plugin = plugin;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.setTitle("Creator's Kit Anvil");
        this.setIconImage(this.ICON);
        this.c.fill = 1;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        JLabel modelForgeLabel = new JLabel("Model Anvil");
        modelForgeLabel.setFont(FontManager.getRunescapeBoldFont());
        modelForgeLabel.setHorizontalAlignment(0);
        modelForgeLabel.setVerticalAlignment(0);
        this.add((Component)modelForgeLabel, this.c);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.ipady = 10;
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 0, 10, 0));
        this.add((Component)buttonsPanel, this.c);
        JTextField nameField = new JTextField();
        nameField.setText("Name");
        nameField.setHorizontalAlignment(0);
        buttonsPanel.add(nameField);
        JButton forgeButton = new JButton("Forge");
        forgeButton.setFocusable(false);
        buttonsPanel.add(forgeButton);
        JButton forgeSetButton = new JButton("Forge & Set");
        forgeSetButton.setFocusable(false);
        buttonsPanel.add(forgeSetButton);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.ipady = 0;
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(new LineBorder(ColorScheme.LIGHT_GRAY_COLOR, 1));
        this.add((Component)tabbedPane, this.c);
        this.scrollPane.setViewportView(this.complexMode);
        this.complexMode.setLayout(new GridLayout(0, 3, 8, 8));
        this.complexMode.setBackground(Color.BLACK);
        this.complexMode.setBorder(new LineBorder(ColorScheme.DARK_GRAY_COLOR, 8));
        tabbedPane.addTab("Anvil", this.scrollPane);
        JPanel headerPanel = new JPanel();
        headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.scrollPane.setColumnHeaderView(headerPanel);
        JButton addButton = new JButton("Add");
        addButton.setFocusable(false);
        addButton.addActionListener(e -> this.createComplexPanel());
        headerPanel.add(addButton);
        JButton clearButton = new JButton("Clear");
        clearButton.setFocusable(false);
        clearButton.addActionListener(e -> {
            for (JPanel jPanel : this.complexPanels) {
                this.complexMode.remove(jPanel);
                this.repaint();
                this.revalidate();
            }
            this.complexPanels.clear();
        });
        headerPanel.add(clearButton);
        JPopupMenu loadPopupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Load");
        menuItem.addActionListener(e -> LinkBrowser.open((String)MODELS_DIR.toString()));
        loadPopupMenu.add(menuItem);
        JButton loadButton = new JButton("Load");
        loadButton.addActionListener(e -> this.openLoadDialog());
        loadButton.setFocusable(false);
        loadButton.setComponentPopupMenu(loadPopupMenu);
        headerPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.setFocusable(false);
        saveButton.addActionListener(e -> this.openSaveDialog(nameField.getText()));
        headerPanel.add(saveButton);
        JComboBox<LightingStyle> lightingComboBox = new JComboBox<LightingStyle>();
        lightingComboBox.addItem(LightingStyle.DEFAULT);
        lightingComboBox.addItem(LightingStyle.ACTOR);
        lightingComboBox.addItem(LightingStyle.NONE);
        lightingComboBox.setFocusable(false);
        lightingComboBox.setToolTipText("Sets the lighting style. Use Actor for NPCs or Players");
        headerPanel.add(lightingComboBox);
        JCheckBox priorityCheckBox = new JCheckBox("Priority");
        priorityCheckBox.setToolTipText("Use an oversimplified method of resolving render order issues (useful when merging models but not for NPCs/Players)");
        priorityCheckBox.setFocusable(false);
        headerPanel.add(priorityCheckBox);
        forgeButton.addActionListener(e -> this.forgeModel(client, nameField, priorityCheckBox.isSelected(), (LightingStyle)((Object)((Object)lightingComboBox.getSelectedItem())), false));
        forgeSetButton.addActionListener(e -> this.forgeModel(client, nameField, priorityCheckBox.isSelected(), (LightingStyle)((Object)((Object)lightingComboBox.getSelectedItem())), true));
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BorderLayout());
        this.scrollPane.setRowHeaderView(sidePanel);
        JPanel cacheSearcherPanel = new JPanel();
        cacheSearcherPanel.setLayout(new GridLayout(0, 1, 4, 4));
        cacheSearcherPanel.setBorder(new EmptyBorder(4, 20, 4, 20));
        cacheSearcherPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        sidePanel.add((Component)cacheSearcherPanel, "First");
        GroupPanel groupPanel = new GroupPanel(client, plugin, clientThread);
        sidePanel.add((Component)groupPanel, "Center");
        JLabel searcherLabel = new JLabel("Cache Searcher");
        searcherLabel.setFont(FontManager.getRunescapeBoldFont());
        searcherLabel.setHorizontalAlignment(0);
        searcherLabel.setVerticalAlignment(0);
        cacheSearcherPanel.add(searcherLabel);
        JSpinner idSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99999, 1));
        idSpinner.setToolTipText("Choose the NPC or Object Id to find");
        cacheSearcherPanel.add(idSpinner);
        JComboBox<CustomModelType> modelTypeComboBox = new JComboBox<CustomModelType>();
        modelTypeComboBox.addItem(CustomModelType.CACHE_NPC);
        modelTypeComboBox.addItem(CustomModelType.CACHE_OBJECT);
        modelTypeComboBox.setFocusable(false);
        modelTypeComboBox.setToolTipText("Pick which part of the cache to search");
        cacheSearcherPanel.add(modelTypeComboBox);
        JButton addModelsButton = new JButton("Add Models");
        addModelsButton.setFocusable(false);
        addModelsButton.setToolTipText("Add the models from the chosen NPC or Object to the Anvil");
        cacheSearcherPanel.add(addModelsButton);
        addModelsButton.addActionListener(e -> {
            CustomModelType type = (CustomModelType)((Object)((Object)modelTypeComboBox.getSelectedItem()));
            if (type == null) {
                return;
            }
            int id = (Integer)idSpinner.getValue();
            plugin.cacheToAnvil(type, id);
        });
        this.validate();
        this.pack();
    }

    public void createComplexPanel() {
        this.createComplexPanel("Name", -1, 1, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, "", "");
    }

    public void createComplexPanel(DetailedModel dm) {
        this.createComplexPanel(dm.getName(), dm.getModelId(), dm.getGroup(), dm.getXTile(), dm.getYTile(), dm.getZTile(), dm.getXTranslate(), dm.getYTranslate(), dm.getZTranslate(), dm.getXScale(), dm.getYScale(), dm.getZScale(), dm.getRotate(), dm.getRecolourNew(), dm.getRecolourOld());
    }

    public void createComplexPanel(String name, int modelId, int group, int xTile, int yTile, int zTile, int xTranslate, int yTranslate, int zTranslate, int scaleX, int scaleY, int scaleZ, int rotate, String newColours, String oldColours) {
        JSpinner modelIdSpinner = new JSpinner();
        JSpinner groupSpinner = new JSpinner();
        JTextField nameField = new JTextField(name);
        JTextField colourNewField = new JTextField();
        JTextField colourOldField = new JTextField();
        JSpinner xTileSpinner = new JSpinner();
        JSpinner yTileSpinner = new JSpinner();
        JSpinner zTileSpinner = new JSpinner();
        JSpinner xSpinner = new JSpinner();
        JSpinner ySpinner = new JSpinner();
        JSpinner zSpinner = new JSpinner();
        JSpinner xScaleSpinner = new JSpinner();
        JSpinner yScaleSpinner = new JSpinner();
        JSpinner zScaleSpinner = new JSpinner();
        JCheckBox check90 = new JCheckBox();
        JCheckBox check180 = new JCheckBox();
        JCheckBox check270 = new JCheckBox();
        ComplexPanel complexModePanel = new ComplexPanel(modelIdSpinner, groupSpinner, nameField, colourNewField, colourOldField, xSpinner, ySpinner, zSpinner, xTileSpinner, yTileSpinner, zTileSpinner, xScaleSpinner, yScaleSpinner, zScaleSpinner, check90, check180, check270);
        complexModePanel.setLayout(new GridBagLayout());
        complexModePanel.setBorder(new LineBorder(ModelAnvil.getBorderColour(modelId), 1));
        this.c.insets = new Insets(4, 4, 4, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 4;
        this.c.gridheight = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        nameField.setToolTipText("Name for organizational purposes only");
        complexModePanel.add((Component)nameField, this.c);
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.gridx = 0;
        this.c.gridy = 2;
        JPanel arrowPanel = new JPanel();
        arrowPanel.setLayout(new BorderLayout());
        complexModePanel.add((Component)arrowPanel, this.c);
        JButton arrowUpButton = new JButton(new ImageIcon(this.ARROW_UP));
        arrowUpButton.setFocusable(false);
        arrowUpButton.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        arrowUpButton.setToolTipText("Move panel up");
        arrowUpButton.addActionListener(e -> this.setPanelIndex(complexModePanel, -3));
        arrowPanel.add((Component)arrowUpButton, "First");
        JButton arrowLeftButton = new JButton(new ImageIcon(this.ARROW_LEFT));
        arrowLeftButton.setFocusable(false);
        arrowLeftButton.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        arrowLeftButton.setToolTipText("Move panel left");
        arrowLeftButton.addActionListener(e -> this.setPanelIndex(complexModePanel, -1));
        arrowPanel.add((Component)arrowLeftButton, "Before");
        JButton arrowRightButton = new JButton(new ImageIcon(this.ARROW_RIGHT));
        arrowRightButton.setFocusable(false);
        arrowRightButton.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        arrowRightButton.setToolTipText("Move panel right");
        arrowRightButton.addActionListener(e -> this.setPanelIndex(complexModePanel, 1));
        arrowPanel.add((Component)arrowRightButton, "After");
        JButton arrowDownButton = new JButton(new ImageIcon(this.ARROW_DOWN));
        arrowDownButton.setFocusable(false);
        arrowDownButton.setBackground(ColorScheme.MEDIUM_GRAY_COLOR);
        arrowDownButton.setToolTipText("Move panel up");
        arrowDownButton.addActionListener(e -> this.setPanelIndex(complexModePanel, 3));
        arrowPanel.add((Component)arrowDownButton, "Last");
        this.c.weightx = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 2;
        JPanel xyzPanel = new JPanel();
        xyzPanel.setLayout(new GridLayout(3, 0));
        complexModePanel.add((Component)xyzPanel, this.c);
        JLabel xLabel = new JLabel("x:");
        xLabel.setToolTipText("East/West");
        xLabel.setHorizontalAlignment(4);
        xyzPanel.add(xLabel);
        JLabel yLabel = new JLabel("y:");
        yLabel.setToolTipText("North/South");
        yLabel.setHorizontalAlignment(4);
        xyzPanel.add(yLabel);
        JLabel zLabel = new JLabel("z:");
        zLabel.setToolTipText("Up/Down");
        zLabel.setHorizontalAlignment(4);
        xyzPanel.add(zLabel);
        this.c.weightx = 1.0;
        this.c.gridwidth = 2;
        this.c.gridx = 0;
        this.c.gridy = 3;
        JLabel colourLabel = new JLabel("Colours:");
        colourLabel.setHorizontalAlignment(4);
        colourLabel.setToolTipText("Choose new Colours to replace default Colours");
        complexModePanel.add((Component)colourLabel, this.c);
        this.c.gridwidth = 2;
        this.c.gridx = 4;
        this.c.gridy = 0;
        SpinnerNumberModel modelIdModel = new SpinnerNumberModel(modelId, -1, 99999, 1);
        modelIdSpinner.setModel(modelIdModel);
        modelIdSpinner.setBackground(modelId == -1 ? ColorScheme.PROGRESS_ERROR_COLOR : ColorScheme.MEDIUM_GRAY_COLOR);
        modelIdSpinner.setToolTipText("Set the id of the model you want to draw from the cache");
        modelIdSpinner.addChangeListener(e -> {
            complexModePanel.setBorder(new LineBorder(ModelAnvil.getBorderColour((Integer)modelIdSpinner.getValue()), 1));
            modelIdSpinner.setBackground((Integer)modelIdSpinner.getValue() == -1 ? ColorScheme.PROGRESS_ERROR_COLOR : ColorScheme.MEDIUM_GRAY_COLOR);
        });
        complexModePanel.add((Component)modelIdSpinner, this.c);
        this.c.gridwidth = 2;
        this.c.gridx = 6;
        this.c.gridy = 0;
        SpinnerNumberModel groupSpinnerNumberModel = new SpinnerNumberModel(group, 1, 99, 1);
        groupSpinner.setModel(groupSpinnerNumberModel);
        groupSpinner.setToolTipText("Set the group for the purpose of Group Transforms");
        groupSpinner.setBackground(ModelAnvil.getBorderColour(group * 6));
        complexModePanel.add((Component)groupSpinner, this.c);
        groupSpinner.addChangeListener(e -> {
            int colourPick = (Integer)groupSpinner.getValue() * 6;
            groupSpinner.setBackground(ModelAnvil.getBorderColour(colourPick));
        });
        this.c.gridx = 8;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        JButton duplicateButton = new JButton(new ImageIcon(this.DUPLICATE));
        duplicateButton.setFocusable(false);
        duplicateButton.setToolTipText("Duplicate panel");
        complexModePanel.add((Component)duplicateButton, this.c);
        this.c.gridx = 9;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        JButton removeButton = new JButton(new ImageIcon(this.CLOSE));
        removeButton.setFocusable(false);
        removeButton.setToolTipText("Remove panel");
        complexModePanel.add((Component)removeButton, this.c);
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel tileLabel = new JLabel(new ImageIcon(this.TRANSLATE));
        tileLabel.setToolTipText("Translate by full tile");
        tileLabel.setBackground(Color.BLACK);
        complexModePanel.add((Component)tileLabel, this.c);
        this.c.gridx = 4;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel translateLabel = new JLabel(new ImageIcon(this.TRANSLATE_SUBTILE));
        translateLabel.setToolTipText("Translate by sub-tile (1/128 of a tile)");
        translateLabel.setBackground(Color.BLACK);
        complexModePanel.add((Component)translateLabel, this.c);
        this.c.gridx = 6;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel scaleLabel = new JLabel(new ImageIcon(this.SCALE));
        scaleLabel.setToolTipText("Scale. 128 is default scale");
        scaleLabel.setBackground(Color.BLACK);
        complexModePanel.add((Component)scaleLabel, this.c);
        this.c.gridx = 8;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel rotateLabel = new JLabel(new ImageIcon(this.ROTATE));
        rotateLabel.setToolTipText("Rotate");
        rotateLabel.setBackground(Color.BLACK);
        complexModePanel.add((Component)rotateLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        JPanel tilePanel = new JPanel();
        tilePanel.setLayout(new GridLayout(3, 0));
        complexModePanel.add((Component)tilePanel, this.c);
        xTileSpinner.setValue(xTile);
        xTileSpinner.setToolTipText("E/W");
        xTileSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        tilePanel.add(xTileSpinner);
        yTileSpinner.setValue(yTile);
        yTileSpinner.setToolTipText("N/S");
        tilePanel.add(yTileSpinner);
        zTileSpinner.setValue(zTile);
        zTileSpinner.setToolTipText("U/D");
        tilePanel.add(zTileSpinner);
        this.c.gridx = 4;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        JPanel translatePanel = new JPanel();
        translatePanel.setLayout(new GridLayout(3, 0));
        complexModePanel.add((Component)translatePanel, this.c);
        xSpinner.setValue(xTranslate);
        xSpinner.setToolTipText("E/W");
        xSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        translatePanel.add(xSpinner);
        ySpinner.setValue(yTranslate);
        ySpinner.setToolTipText("N/S");
        translatePanel.add(ySpinner);
        zSpinner.setValue(zTranslate);
        zSpinner.setToolTipText("U/D");
        translatePanel.add(zSpinner);
        this.c.gridx = 6;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new GridLayout(3, 0));
        complexModePanel.add((Component)scalePanel, this.c);
        xScaleSpinner.setValue(scaleX);
        xScaleSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        xScaleSpinner.setToolTipText("E/W");
        scalePanel.add(xScaleSpinner);
        yScaleSpinner.setValue(scaleY);
        yScaleSpinner.setToolTipText("N/S");
        scalePanel.add(yScaleSpinner);
        zScaleSpinner.setValue(scaleZ);
        zScaleSpinner.setToolTipText("U/D");
        scalePanel.add(zScaleSpinner);
        this.c.gridx = 8;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        JPanel rotatePanel = new JPanel();
        rotatePanel.setBackground(Color.BLACK);
        rotatePanel.setLayout(new GridLayout(3, 0));
        complexModePanel.add((Component)rotatePanel, this.c);
        check90.setText("90\u00b0");
        check90.setHorizontalAlignment(2);
        check90.setFocusable(false);
        rotatePanel.add(check90);
        check180.setText("180\u00b0");
        check180.setHorizontalAlignment(2);
        check180.setFocusable(false);
        rotatePanel.add(check180);
        check270.setText("270\u00b0");
        check270.setHorizontalAlignment(2);
        check270.setFocusable(false);
        rotatePanel.add(check270);
        check90.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                check180.setSelected(false);
                check270.setSelected(false);
            }
        });
        check180.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                check90.setSelected(false);
                check270.setSelected(false);
            }
        });
        check270.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                check180.setSelected(false);
                check90.setSelected(false);
            }
        });
        switch (rotate) {
            case 0: {
                break;
            }
            case 1: {
                check270.setSelected(true);
                break;
            }
            case 2: {
                check180.setSelected(true);
                break;
            }
            case 3: {
                check90.setSelected(true);
            }
        }
        HashMap<Short, Short> colourMap = new HashMap<Short, Short>();
        if (!newColours.equals("") && !oldColours.equals("")) {
            try {
                String[] newCols = newColours.split(",");
                String[] oldCols = oldColours.split(",");
                for (int i = 0; i < newCols.length; ++i) {
                    Short newCol = Short.parseShort(newCols[i]);
                    Short oldCol = Short.parseShort(oldCols[i]);
                    colourMap.put(oldCol, newCol);
                }
            }
            catch (Exception newCols) {
                // empty catch block
            }
        }
        colourNewField.setText(newColours);
        colourNewField.setVisible(false);
        complexModePanel.add(colourNewField);
        colourOldField.setText(oldColours);
        colourOldField.setVisible(false);
        complexModePanel.add(colourOldField);
        JButton clearColoursButton = new JButton("Clear (" + colourMap.size() + ")");
        JFrame swapperFrame = new JFrame("Colour Swapper: " + nameField.getText());
        swapperFrame.setVisible(false);
        swapperFrame.setEnabled(false);
        swapperFrame.setIconImage(this.ICON);
        swapperFrame.setLayout(new BorderLayout());
        JScrollPane colourScrollPane = new JScrollPane();
        swapperFrame.add((Component)colourScrollPane, "Before");
        JPanel gridMenu = new JPanel();
        gridMenu.setLayout(new GridLayout(0, 2, 2, 2));
        colourScrollPane.setViewportView(gridMenu);
        JPanel colourButtons = new JPanel();
        colourScrollPane.setColumnHeaderView(colourButtons);
        JButton copyColourButton = new JButton("Copy");
        copyColourButton.setFocusable(false);
        copyColourButton.setToolTipText("Copy New Colours");
        copyColourButton.addActionListener(e -> {
            this.copiedColourMap = colourMap;
        });
        colourButtons.add(copyColourButton);
        JButton pasteColourButton = new JButton("Paste");
        pasteColourButton.setFocusable(false);
        pasteColourButton.setToolTipText("Paste copied New Colours");
        colourButtons.add(pasteColourButton);
        JColorChooser colorChooser = new JColorChooser();
        swapperFrame.add((Component)colorChooser, "After");
        this.c.gridx = 2;
        this.c.gridy = 3;
        this.c.gridwidth = 4;
        JButton colourSwapper = new JButton("Colour Swapper");
        colourSwapper.setFocusable(false);
        colourSwapper.setToolTipText("Opens an interface to swap colours on this model");
        complexModePanel.add((Component)colourSwapper, this.c);
        colourSwapper.addActionListener(e -> this.setupColourSwapper(swapperFrame, gridMenu, nameField, modelIdSpinner, colourMap, colorChooser, colourNewField, colourOldField, clearColoursButton));
        pasteColourButton.addActionListener(e -> {
            colourMap.clear();
            colourMap.putAll(this.copiedColourMap);
            String[] mapToCSV = ModelAnvil.hashmapToCSV(colourMap);
            colourNewField.setText(mapToCSV[1]);
            colourOldField.setText(mapToCSV[0]);
            this.setupColourSwapper(swapperFrame, gridMenu, nameField, modelIdSpinner, colourMap, colorChooser, colourNewField, colourOldField, clearColoursButton);
        });
        this.c.gridx = 6;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        JButton copyColourButtonMain = new JButton(new ImageIcon(this.COPY_COLOURS));
        copyColourButtonMain.setFocusable(false);
        copyColourButtonMain.setToolTipText("Copy New Colours");
        copyColourButtonMain.addActionListener(e -> {
            this.copiedColourMap = colourMap;
        });
        complexModePanel.add((Component)copyColourButtonMain, this.c);
        this.c.gridx = 7;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        JButton pasteColourButtonMain = new JButton(new ImageIcon(this.PASTE_COLOURS));
        pasteColourButtonMain.setFocusable(false);
        pasteColourButtonMain.setToolTipText("Paste copied New Colours");
        complexModePanel.add((Component)pasteColourButtonMain, this.c);
        pasteColourButtonMain.addActionListener(e -> {
            colourMap.clear();
            colourMap.putAll(this.copiedColourMap);
            String[] mapToCSV = ModelAnvil.hashmapToCSV(colourMap);
            colourNewField.setText(mapToCSV[1]);
            colourOldField.setText(mapToCSV[0]);
            if (swapperFrame.isVisible()) {
                this.setupColourSwapper(swapperFrame, gridMenu, nameField, modelIdSpinner, colourMap, colorChooser, colourNewField, colourOldField, clearColoursButton);
            }
        });
        this.c.gridx = 8;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        clearColoursButton.setFocusable(false);
        clearColoursButton.setToolTipText("Clears all swapped colours");
        complexModePanel.add((Component)clearColoursButton, this.c);
        clearColoursButton.addActionListener(e -> {
            for (Component component : gridMenu.getComponents()) {
                JButton button;
                if (!(component instanceof JButton) || !(button = (JButton)component).getText().equals("Unset")) continue;
                button.setBorder(new EmptyBorder(4, 4, 4, 4));
                button.setText("Set");
            }
            colourMap.clear();
            colourNewField.setText("");
            colourOldField.setText("");
            clearColoursButton.setText("Clear (0)");
            swapperFrame.revalidate();
            swapperFrame.repaint();
            swapperFrame.pack();
            this.revalidate();
            this.repaint();
        });
        duplicateButton.addActionListener(e -> {
            int rotation = 0;
            if (check270.isSelected()) {
                rotation = 1;
            }
            if (check180.isSelected()) {
                rotation = 2;
            }
            if (check90.isSelected()) {
                rotation = 3;
            }
            String[] colourSwaps = ModelAnvil.hashmapToCSV(colourMap);
            this.createComplexPanel(nameField.getText(), (Integer)modelIdSpinner.getValue(), (Integer)groupSpinner.getValue(), (Integer)xTileSpinner.getValue(), (Integer)yTileSpinner.getValue(), (Integer)zTileSpinner.getValue(), (Integer)xSpinner.getValue(), (Integer)ySpinner.getValue(), (Integer)zSpinner.getValue(), (Integer)xScaleSpinner.getValue(), (Integer)yScaleSpinner.getValue(), (Integer)zScaleSpinner.getValue(), rotation, colourSwaps[1], colourSwaps[0]);
        });
        removeButton.addActionListener(e -> {
            swapperFrame.setVisible(false);
            swapperFrame.setEnabled(false);
            this.complexMode.remove(complexModePanel);
            this.complexPanels.remove(complexModePanel);
            this.repaint();
            this.revalidate();
        });
        nameField.addActionListener(e -> {
            nameField.setText(nameField.getText().replaceAll("=", ""));
            swapperFrame.setTitle("Colour Swapper: " + nameField.getText());
        });
        this.complexMode.add(complexModePanel);
        complexModePanel.setEnabled(true);
        complexModePanel.setVisible(true);
        this.complexPanels.add(complexModePanel);
        this.revalidate();
        this.repaint();
    }

    private void setPanelIndex(JPanel panel, int change) {
        int newPosition = this.complexMode.getComponentZOrder(panel) + change;
        if (newPosition < 0) {
            newPosition = 0;
        }
        if (newPosition >= this.complexPanels.size()) {
            newPosition = this.complexPanels.size() - 1;
        }
        this.complexMode.setComponentZOrder(panel, newPosition);
        this.repaint();
        this.revalidate();
    }

    private void forgeModel(Client client, JTextField nameField, boolean setPriority, LightingStyle lightingStyle, boolean forgeAndSet) {
        if (client == null) {
            return;
        }
        if (this.complexPanels.isEmpty()) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            DetailedModel[] detailedModels = this.panelsToDetailedModels();
            Model model = this.forgeComplexModel(setPriority, detailedModels, lightingStyle);
            if (model == null) {
                return;
            }
            CustomModelComp comp = new CustomModelComp(this.plugin.getStoredModels().size(), CustomModelType.FORGED, -1, null, null, detailedModels, lightingStyle, setPriority, nameField.getText());
            CustomModel customModel = new CustomModel(model, comp);
            this.plugin.addCustomModel(customModel, forgeAndSet);
        });
    }

    public Model forgeComplexModel(boolean setPriority, DetailedModel[] detailedModels, LightingStyle lightingStyle) {
        return this.plugin.createComplexModel(detailedModels, setPriority, lightingStyle);
    }

    private DetailedModel[] panelsToDetailedModels() {
        DetailedModel[] detailedModels = new DetailedModel[this.complexPanels.size()];
        for (int i = 0; i < this.complexPanels.size(); ++i) {
            DetailedModel detailedModel;
            ComplexPanel complexModePanel = this.complexPanels.get(i);
            String name = complexModePanel.getNameField().getText();
            int modelId = (Integer)complexModePanel.getModelIdSpinner().getValue();
            int group = (Integer)complexModePanel.getGroupSpinner().getValue();
            int xTile = (Integer)complexModePanel.getXTileSpinner().getValue();
            int yTile = (Integer)complexModePanel.getYTileSpinner().getValue();
            int zTile = (Integer)complexModePanel.getZTileSpinner().getValue();
            int xTranslate = (Integer)complexModePanel.getXSpinner().getValue();
            int yTranslate = (Integer)complexModePanel.getYSpinner().getValue();
            int zTranslate = (Integer)complexModePanel.getZSpinner().getValue();
            int xScale = (Integer)complexModePanel.getXScaleSpinner().getValue();
            int yScale = (Integer)complexModePanel.getYScaleSpinner().getValue();
            int zScale = (Integer)complexModePanel.getZScaleSpinner().getValue();
            int rotate = 0;
            String recolourNew = complexModePanel.getColourNewField().getText();
            String recolourOld = complexModePanel.getColourOldField().getText();
            JCheckBox check90 = complexModePanel.getCheck90();
            JCheckBox check180 = complexModePanel.getCheck180();
            JCheckBox check270 = complexModePanel.getCheck270();
            if (check90.isSelected()) {
                rotate = 3;
            }
            if (check180.isSelected()) {
                rotate = 2;
            }
            if (check270.isSelected()) {
                rotate = 1;
            }
            detailedModels[i] = detailedModel = new DetailedModel(name, modelId, group, xTile, yTile, zTile, xTranslate, yTranslate, zTranslate, xScale, yScale, zScale, rotate, recolourNew, recolourOld);
        }
        return detailedModels;
    }

    private void openSaveDialog(String name) {
        File outputDir = MODELS_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getName().endsWith(".json")) {
                    f = new File(f.getPath() + ".json");
                }
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists, overwrite?", "Warning", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File(name));
        fileChooser.setDialogTitle("Save current model collection");
        int option = fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith(".json")) {
                selectedFile = new File(selectedFile.getPath() + ".json");
            }
            this.saveToFile(selectedFile);
        }
    }

    public void saveToFile(File file) {
        try {
            FileWriter writer = new FileWriter(file, false);
            DetailedModel[] detailedModels = this.panelsToDetailedModels();
            String string = this.plugin.gson.toJson((Object)detailedModels);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            log.debug("Error when saving Forge model to file");
        }
    }

    private void openLoadDialog() {
        MODELS_DIR.mkdirs();
        JFileChooser fileChooser = new JFileChooser(MODELS_DIR);
        fileChooser.setDialogTitle("Choose a model to load");
        int option = fileChooser.showOpenDialog(this);
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.plugin.loadCustomModelToAnvil(selectedFile);
        }
    }

    private void setupColourSwapper(JFrame swapperFrame, JPanel gridMenu, JTextField nameField, JSpinner modelIdSpinner, HashMap<Short, Short> colourMap, JColorChooser colorChooser, JTextField colourNewField, JTextField colourOldField, JButton clearColoursButton) {
        swapperFrame.setVisible(true);
        swapperFrame.setEnabled(true);
        swapperFrame.setTitle("Colour Swapper: " + nameField.getText());
        gridMenu.removeAll();
        this.clientThread.invokeLater(() -> {
            ModelData md = this.client.loadModelData(((Integer)modelIdSpinner.getValue()).intValue());
            if (md == null) {
                return;
            }
            ArrayList<Short> list = new ArrayList<Short>();
            for (short s : md.getFaceColors()) {
                if (list.contains(s)) continue;
                list.add(s);
            }
            SwingUtilities.invokeLater(() -> {
                JLabel oldColourTitle = new JLabel("Old Colours");
                oldColourTitle.setFont(FontManager.getRunescapeBoldFont());
                oldColourTitle.setToolTipText("Default colours of the model");
                oldColourTitle.setHorizontalAlignment(0);
                oldColourTitle.setVerticalAlignment(3);
                gridMenu.add(oldColourTitle);
                JLabel newColourTitle = new JLabel("New Colours");
                newColourTitle.setToolTipText("Pick colours to replace Old Colours");
                newColourTitle.setFont(FontManager.getRunescapeBoldFont());
                newColourTitle.setHorizontalAlignment(0);
                newColourTitle.setVerticalAlignment(3);
                gridMenu.add(newColourTitle);
                for (int i = 0; i < list.size(); ++i) {
                    short s = (Short)list.get(i);
                    JLabel oldColour = new JLabel("" + s, 0);
                    oldColour.setFont(FontManager.getRunescapeBoldFont());
                    oldColour.setOpaque(true);
                    oldColour.setBackground(Color.BLACK);
                    Color color = ModelAnvil.colorFromShort(s);
                    oldColour.setBorder(new LineBorder(color, 12));
                    gridMenu.add(oldColour);
                    JButton newColour = new JButton();
                    newColour.setName("newColour");
                    newColour.setFocusable(false);
                    newColour.setFont(FontManager.getRunescapeBoldFont());
                    newColour.setText("Set");
                    gridMenu.add(newColour);
                    if (colourMap.containsKey(s)) {
                        newColour.setBorder(new LineBorder(ModelAnvil.colorFromShort((Short)colourMap.get(s)), 12));
                        newColour.setText("Unset");
                    }
                    newColour.addActionListener(f -> {
                        if (newColour.getText().equals("Unset")) {
                            colourMap.remove(s);
                            newColour.setBorder(new EmptyBorder(4, 4, 4, 4));
                            newColour.setText("Set");
                        } else {
                            Color colourToAdd = colorChooser.getColor();
                            colourMap.put(s, ModelAnvil.shortFromColour(colourToAdd));
                            newColour.setBorder(new LineBorder(colourToAdd, 12));
                            newColour.setText("Unset");
                        }
                        String[] mapToCSV = ModelAnvil.hashmapToCSV(colourMap);
                        colourNewField.setText(mapToCSV[1]);
                        colourOldField.setText(mapToCSV[0]);
                        clearColoursButton.setText("Clear (" + colourMap.size() + ")");
                        swapperFrame.revalidate();
                        swapperFrame.repaint();
                        this.revalidate();
                        this.repaint();
                    });
                }
                swapperFrame.revalidate();
                swapperFrame.repaint();
                swapperFrame.pack();
                this.revalidate();
                this.repaint();
            });
        });
        clearColoursButton.setText("Clear (" + colourMap.size() + ")");
        swapperFrame.revalidate();
        swapperFrame.repaint();
        swapperFrame.pack();
        this.revalidate();
        this.repaint();
    }

    public static String[] hashmapToCSV(HashMap<Short, Short> map) {
        if (map.isEmpty()) {
            return new String[]{"", ""};
        }
        StringBuilder oldBuilder = new StringBuilder();
        StringBuilder newBuilder = new StringBuilder();
        for (Map.Entry<Short, Short> entry : map.entrySet()) {
            short oldColour = entry.getKey();
            short newColour = entry.getValue();
            oldBuilder.append(oldColour).append(",");
            newBuilder.append(newColour).append(",");
        }
        oldBuilder.deleteCharAt(oldBuilder.length() - 1);
        newBuilder.deleteCharAt(newBuilder.length() - 1);
        return new String[]{oldBuilder.toString(), newBuilder.toString()};
    }

    public static Color colorFromShort(short s) {
        float hue = (float)JagexColor.unpackHue((short)s) / 63.0f;
        float sat = (float)JagexColor.unpackSaturation((short)s) / 7.0f;
        float lum = (float)JagexColor.unpackLuminance((short)s) / 127.0f;
        int[] rgb = ModelAnvil.hslToRgb(hue, sat, lum);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static short shortFromColour(Color color) {
        float[] col = ModelAnvil.rgbToHsl(color.getRed(), color.getGreen(), color.getBlue());
        int hue = (int)(col[0] * 63.0f);
        int sat = (int)(col[1] * 7.0f);
        int lum = (int)(col[2] * 127.0f);
        return JagexColor.packHSL((int)hue, (int)sat, (int)lum);
    }

    public static Color getBorderColour(int i) {
        if (i == -1) {
            return ColorScheme.MEDIUM_GRAY_COLOR;
        }
        float hue = ((float)i - 25.0f) / 50.0f;
        return Color.getHSBColor(hue, 1.0f, 0.7f);
    }

    public static int[] hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ModelAnvil.hueToRgb(p, q, h + 0.33333334f);
            g = ModelAnvil.hueToRgb(p, q, h);
            b = ModelAnvil.hueToRgb(p, q, h - 0.33333334f);
        }
        return new int[]{ModelAnvil.to255(r), ModelAnvil.to255(g), ModelAnvil.to255(b)};
    }

    public static float[] rgbToHsl(int red, int green, int blue) {
        float h;
        float s;
        float max;
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float f = r > g && r > b ? r : (max = g > b ? g : b);
        float min = r < g && r < b ? r : (g < b ? g : b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f2 = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = r > g && r > b ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (g > b ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }

    public static int to255(float v) {
        return (int)Math.min(255.0f, 256.0f * v);
    }

    public static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public ArrayList<ComplexPanel> getComplexPanels() {
        return this.complexPanels;
    }
}

