/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.swing;

import com.creatorskit.CreatorsPlugin;
import com.creatorskit.swing.ComplexPanel;
import com.creatorskit.swing.GroupOperation;
import com.creatorskit.swing.ModelAnvil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSpinnerUI;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class GroupPanel
extends JPanel {
    private CreatorsPlugin plugin;
    private Client client;
    private ClientThread clientThread;
    private final GridBagConstraints c = new GridBagConstraints();
    private final BufferedImage ICON = ImageUtil.loadImageResource(this.getClass(), (String)"/panelicon.png");
    private final BufferedImage TRANSLATE = ImageUtil.loadImageResource(this.getClass(), (String)"/Translate.png");
    private final BufferedImage ROTATE = ImageUtil.loadImageResource(this.getClass(), (String)"/Rotate.png");
    private final BufferedImage TRANSLATE_SUBTILE = ImageUtil.loadImageResource(this.getClass(), (String)"/Translate subtile.png");
    private final BufferedImage SCALE = ImageUtil.loadImageResource(this.getClass(), (String)"/Scale.png");
    private final Dimension SPINNER_DIMENSION = new Dimension(35, 25);
    private final JSpinner groupSpinner = new JSpinner();

    @Inject
    public GroupPanel(@Nullable Client client, CreatorsPlugin plugin, ClientThread clientThread) {
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.c.fill = 1;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        JLabel title = new JLabel("Group Transformer");
        title.setFont(FontManager.getRunescapeBoldFont());
        title.setHorizontalAlignment(0);
        this.add((Component)title, this.c);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        JLabel groupLabel = new JLabel("Group:");
        groupLabel.setHorizontalAlignment(4);
        this.add((Component)groupLabel, this.c);
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 99, 1);
        this.groupSpinner.setModel(spinnerNumberModel);
        this.groupSpinner.setBackground(ModelAnvil.getBorderColour(6));
        this.groupSpinner.setToolTipText("Pick the Group number to Group Transform");
        this.add((Component)this.groupSpinner, this.c);
        this.groupSpinner.addChangeListener(e -> this.groupSpinner.setBackground(ModelAnvil.getBorderColour((Integer)this.groupSpinner.getValue() * 6)));
        JPanel adjustPanel = this.createAdjustPanel();
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.add((Component)adjustPanel, this.c);
        JPanel setPanel = this.createSetPanel();
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.add((Component)setPanel, this.c);
        this.revalidate();
        this.repaint();
    }

    public JPanel createAdjustPanel() {
        JPanel adjustPanel = new JPanel();
        adjustPanel.setLayout(new GridBagLayout());
        adjustPanel.setBorder(new LineBorder(ColorScheme.MEDIUM_GRAY_COLOR, 1));
        adjustPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JTextField colourNewField = new JTextField();
        JTextField colourOldField = new JTextField();
        final JSpinner xTileSpinner = new JSpinner();
        final JSpinner yTileSpinner = new JSpinner();
        final JSpinner zTileSpinner = new JSpinner();
        final JSpinner xSpinner = new JSpinner();
        final JSpinner ySpinner = new JSpinner();
        final JSpinner zSpinner = new JSpinner();
        final JSpinner xScaleSpinner = new JSpinner();
        final JSpinner yScaleSpinner = new JSpinner();
        final JSpinner zScaleSpinner = new JSpinner();
        final JComboBox<String> rotateBox = new JComboBox<String>();
        this.c.fill = 1;
        this.c.insets = new Insets(2, 4, 2, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 10;
        this.c.gridheight = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        JLabel setLabel = new JLabel("Adjuster");
        setLabel.setToolTipText("Functions here adjust all values of the given Group BY the value entered");
        setLabel.setHorizontalAlignment(0);
        adjustPanel.add((Component)setLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel tileLabel = new JLabel(new ImageIcon(this.TRANSLATE));
        tileLabel.setToolTipText("Translate by full tile");
        tileLabel.setBackground(Color.BLACK);
        adjustPanel.add((Component)tileLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        JLabel translateLabel = new JLabel(new ImageIcon(this.TRANSLATE_SUBTILE));
        translateLabel.setToolTipText("Translate by sub-tile (1/128 of a tile)");
        translateLabel.setBackground(Color.BLACK);
        adjustPanel.add((Component)translateLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 5;
        this.c.gridwidth = 2;
        JLabel scaleLabel = new JLabel(new ImageIcon(this.SCALE));
        scaleLabel.setToolTipText("Scale. 128 is default scale");
        scaleLabel.setBackground(Color.BLACK);
        adjustPanel.add((Component)scaleLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 7;
        this.c.gridwidth = 2;
        JLabel rotateLabel = new JLabel(new ImageIcon(this.ROTATE));
        rotateLabel.setToolTipText("Rotate");
        rotateLabel.setBackground(Color.BLACK);
        adjustPanel.add((Component)rotateLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        adjustPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        JPanel tilePanel = new JPanel();
        tilePanel.setLayout(new GridLayout(3, 0));
        adjustPanel.add((Component)tilePanel, this.c);
        xTileSpinner.setToolTipText("E/W");
        xTileSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        tilePanel.add(xTileSpinner);
        xTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(xTileSpinner, this, GroupOperation.X_TILE_SPINNER);
            }
        });
        yTileSpinner.setToolTipText("N/S");
        tilePanel.add(yTileSpinner);
        yTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(yTileSpinner, this, GroupOperation.Y_TILE_SPINNER);
            }
        });
        zTileSpinner.setToolTipText("U/D");
        tilePanel.add(zTileSpinner);
        zTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(zTileSpinner, this, GroupOperation.Z_TILE_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        adjustPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        JPanel translatePanel = new JPanel();
        translatePanel.setLayout(new GridLayout(3, 0));
        adjustPanel.add((Component)translatePanel, this.c);
        xSpinner.setToolTipText("E/W");
        xSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        translatePanel.add(xSpinner);
        xSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(xSpinner, this, GroupOperation.X_SPINNER);
            }
        });
        ySpinner.setToolTipText("N/S");
        translatePanel.add(ySpinner);
        ySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(ySpinner, this, GroupOperation.Y_SPINNER);
            }
        });
        zSpinner.setToolTipText("U/D");
        translatePanel.add(zSpinner);
        zSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(zSpinner, this, GroupOperation.Z_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        adjustPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 6;
        this.c.gridwidth = 2;
        this.c.weightx = 0.0;
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new GridLayout(3, 0));
        adjustPanel.add((Component)scalePanel, this.c);
        xScaleSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        xScaleSpinner.setToolTipText("E/W");
        scalePanel.add(xScaleSpinner);
        xScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(xScaleSpinner, this, GroupOperation.X_SCALE_SPINNER);
            }
        });
        yScaleSpinner.setToolTipText("N/S");
        scalePanel.add(yScaleSpinner);
        yScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(yScaleSpinner, this, GroupOperation.Y_SCALE_SPINNER);
            }
        });
        zScaleSpinner.setToolTipText("U/D");
        scalePanel.add(zScaleSpinner);
        zScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.adjustValueSpinner(zScaleSpinner, this, GroupOperation.Z_SCALE_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 8;
        this.c.gridwidth = 2;
        JPanel rotatePanel = new JPanel();
        rotatePanel.setBackground(Color.BLACK);
        adjustPanel.add((Component)rotatePanel, this.c);
        rotatePanel.add(rotateBox);
        rotateBox.addItem("Rot");
        rotateBox.addItem("90");
        rotateBox.addItem("180");
        rotateBox.addItem("270");
        rotateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GroupPanel.this.adjustValueComboBox(rotateBox, e, this);
            }
        });
        JFrame swapperFrame = new JFrame("Colour Swapper");
        swapperFrame.setVisible(false);
        swapperFrame.setEnabled(false);
        swapperFrame.setIconImage(this.ICON);
        swapperFrame.setLayout(new FlowLayout());
        JPanel gridMenu = new JPanel();
        gridMenu.setLayout(new GridLayout(0, 2, 2, 2));
        swapperFrame.add(gridMenu);
        adjustPanel.setEnabled(true);
        adjustPanel.setVisible(true);
        return adjustPanel;
    }

    private void adjustValueSpinner(JSpinner spinner, ChangeListener changeListener, GroupOperation operation) {
        int value = (Integer)spinner.getValue();
        for (ComplexPanel complexPanel : this.plugin.getComplexPanels()) {
            if (complexPanel.getGroupSpinner().getValue() != this.groupSpinner.getValue()) continue;
            switch (operation) {
                case X_TILE_SPINNER: {
                    JSpinner s = complexPanel.getXTileSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Y_TILE_SPINNER: {
                    JSpinner s = complexPanel.getYTileSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Z_TILE_SPINNER: {
                    JSpinner s = complexPanel.getZTileSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case X_SPINNER: {
                    JSpinner s = complexPanel.getXSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Y_SPINNER: {
                    JSpinner s = complexPanel.getYSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Z_SPINNER: {
                    JSpinner s = complexPanel.getZSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case X_SCALE_SPINNER: {
                    JSpinner s = complexPanel.getXScaleSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Y_SCALE_SPINNER: {
                    JSpinner s = complexPanel.getYScaleSpinner();
                    s.setValue((Integer)s.getValue() + value);
                    break;
                }
                case Z_SCALE_SPINNER: {
                    JSpinner s = complexPanel.getZScaleSpinner();
                    s.setValue((Integer)s.getValue() + value);
                }
            }
        }
        spinner.removeChangeListener(changeListener);
        spinner.setValue(0);
        spinner.addChangeListener(changeListener);
    }

    private void adjustValueComboBox(JComboBox<String> comboBox, ItemEvent e, ItemListener itemListener) {
        if (e.getItem() == "Rot") {
            return;
        }
        int change = Integer.parseInt((String)e.getItem());
        for (ComplexPanel complexPanel : this.plugin.getComplexPanels()) {
            if (complexPanel.getGroupSpinner().getValue() != this.groupSpinner.getValue()) continue;
            JCheckBox check90 = complexPanel.getCheck90();
            JCheckBox check180 = complexPanel.getCheck180();
            JCheckBox check270 = complexPanel.getCheck270();
            int currentRotation = 0;
            if (check90.isSelected()) {
                currentRotation = 90;
            }
            if (check180.isSelected()) {
                currentRotation = 180;
            }
            if (check270.isSelected()) {
                currentRotation = 270;
            }
            switch (currentRotation + change) {
                case 90: 
                case 450: {
                    complexPanel.getCheck90().setSelected(true);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(false);
                    break;
                }
                case 180: 
                case 540: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(true);
                    complexPanel.getCheck270().setSelected(false);
                    break;
                }
                case 270: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(true);
                    break;
                }
                case 360: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(false);
                }
            }
        }
        comboBox.removeItemListener(itemListener);
        comboBox.setSelectedItem("Rot");
        comboBox.addItemListener(itemListener);
    }

    public JPanel createSetPanel() {
        JPanel setPanel = new JPanel();
        setPanel.setLayout(new GridBagLayout());
        setPanel.setBorder(new LineBorder(ColorScheme.MEDIUM_GRAY_COLOR, 1));
        setPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JTextField colourNewField = new JTextField();
        JTextField colourOldField = new JTextField();
        final JSpinner xTileSpinner = new JSpinner();
        final JSpinner yTileSpinner = new JSpinner();
        final JSpinner zTileSpinner = new JSpinner();
        final JSpinner xSpinner = new JSpinner();
        final JSpinner ySpinner = new JSpinner();
        final JSpinner zSpinner = new JSpinner();
        final JSpinner xScaleSpinner = new JSpinner();
        final JSpinner yScaleSpinner = new JSpinner();
        final JSpinner zScaleSpinner = new JSpinner();
        final JComboBox<String> rotateBox = new JComboBox<String>();
        this.c.fill = 1;
        this.c.insets = new Insets(2, 4, 2, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 10;
        this.c.gridheight = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        JLabel setLabel = new JLabel("Setter");
        setLabel.setToolTipText("Functions here set all values of the given Group TO the value entered");
        setLabel.setHorizontalAlignment(0);
        setPanel.add((Component)setLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        JLabel tileLabel = new JLabel(new ImageIcon(this.TRANSLATE));
        tileLabel.setToolTipText("Translate by full tile");
        tileLabel.setBackground(Color.BLACK);
        setPanel.add((Component)tileLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        JLabel translateLabel = new JLabel(new ImageIcon(this.TRANSLATE_SUBTILE));
        translateLabel.setToolTipText("Translate by sub-tile (1/128 of a tile)");
        translateLabel.setBackground(Color.BLACK);
        setPanel.add((Component)translateLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 5;
        this.c.gridwidth = 2;
        JLabel scaleLabel = new JLabel(new ImageIcon(this.SCALE));
        scaleLabel.setToolTipText("Scale. 128 is default scale");
        scaleLabel.setBackground(Color.BLACK);
        setPanel.add((Component)scaleLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 7;
        this.c.gridwidth = 2;
        JLabel rotateLabel = new JLabel(new ImageIcon(this.ROTATE));
        rotateLabel.setToolTipText("Rotate");
        rotateLabel.setBackground(Color.BLACK);
        setPanel.add((Component)rotateLabel, this.c);
        this.c.gridx = 2;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        setPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        JPanel tilePanel = new JPanel();
        tilePanel.setLayout(new GridLayout(3, 0));
        setPanel.add((Component)tilePanel, this.c);
        xTileSpinner.setToolTipText("E/W");
        xTileSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        xTileSpinner.setUI(this.createEmptySpinner());
        tilePanel.add(xTileSpinner);
        xTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(xTileSpinner, this, GroupOperation.X_TILE_SPINNER);
            }
        });
        yTileSpinner.setToolTipText("N/S");
        yTileSpinner.setUI(this.createEmptySpinner());
        tilePanel.add(yTileSpinner);
        yTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(yTileSpinner, this, GroupOperation.Y_TILE_SPINNER);
            }
        });
        zTileSpinner.setToolTipText("U/D");
        zTileSpinner.setUI(this.createEmptySpinner());
        tilePanel.add(zTileSpinner);
        zTileSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(zTileSpinner, this, GroupOperation.Z_TILE_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        setPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.weightx = 1.0;
        JPanel translatePanel = new JPanel();
        translatePanel.setLayout(new GridLayout(3, 0));
        setPanel.add((Component)translatePanel, this.c);
        xSpinner.setToolTipText("E/W");
        xSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        xSpinner.setUI(this.createEmptySpinner());
        translatePanel.add(xSpinner);
        xSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(xSpinner, this, GroupOperation.X_SPINNER);
            }
        });
        ySpinner.setToolTipText("N/S");
        ySpinner.setUI(this.createEmptySpinner());
        translatePanel.add(ySpinner);
        ySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(ySpinner, this, GroupOperation.Y_SPINNER);
            }
        });
        zSpinner.setToolTipText("U/D");
        zSpinner.setUI(this.createEmptySpinner());
        translatePanel.add(zSpinner);
        zSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(zSpinner, this, GroupOperation.Z_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        setPanel.add((Component)this.createXYZPanel(), this.c);
        this.c.gridx = 3;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.weightx = 0.0;
        JPanel scalePanel = new JPanel();
        scalePanel.setLayout(new GridLayout(3, 0));
        setPanel.add((Component)scalePanel, this.c);
        xScaleSpinner.setPreferredSize(this.SPINNER_DIMENSION);
        xScaleSpinner.setToolTipText("E/W");
        xScaleSpinner.setUI(this.createEmptySpinner());
        scalePanel.add(xScaleSpinner);
        xScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(xScaleSpinner, this, GroupOperation.X_SCALE_SPINNER);
            }
        });
        yScaleSpinner.setToolTipText("N/S");
        yScaleSpinner.setUI(this.createEmptySpinner());
        scalePanel.add(yScaleSpinner);
        yScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(yScaleSpinner, this, GroupOperation.Y_SCALE_SPINNER);
            }
        });
        zScaleSpinner.setToolTipText("U/D");
        zScaleSpinner.setUI(this.createEmptySpinner());
        scalePanel.add(zScaleSpinner);
        zScaleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.setValueSpinner(zScaleSpinner, this, GroupOperation.Z_SCALE_SPINNER);
            }
        });
        this.c.gridx = 2;
        this.c.gridy = 8;
        this.c.gridwidth = 2;
        JPanel rotatePanel = new JPanel();
        rotatePanel.setBackground(Color.BLACK);
        setPanel.add((Component)rotatePanel, this.c);
        rotatePanel.add(rotateBox);
        rotateBox.addItem("Rot");
        rotateBox.addItem("0");
        rotateBox.addItem("90");
        rotateBox.addItem("180");
        rotateBox.addItem("270");
        rotateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GroupPanel.this.setValueComboBox(rotateBox, e, this);
            }
        });
        HashMap colourMap = new HashMap();
        colourNewField.setVisible(false);
        setPanel.add(colourNewField);
        colourOldField.setVisible(false);
        setPanel.add(colourOldField);
        JFrame swapperFrame = new JFrame("Colour Swapper");
        swapperFrame.setVisible(false);
        swapperFrame.setEnabled(false);
        swapperFrame.setIconImage(this.ICON);
        swapperFrame.setLayout(new FlowLayout());
        JPanel gridMenu = new JPanel();
        gridMenu.setLayout(new GridLayout(0, 2, 2, 2));
        swapperFrame.add(gridMenu);
        setPanel.setEnabled(true);
        setPanel.setVisible(true);
        return setPanel;
    }

    private void setValueSpinner(JSpinner spinner, ChangeListener changeListener, GroupOperation operation) {
        int value = (Integer)spinner.getValue();
        for (ComplexPanel complexPanel : this.plugin.getComplexPanels()) {
            if (complexPanel.getGroupSpinner().getValue() != this.groupSpinner.getValue()) continue;
            switch (operation) {
                case X_TILE_SPINNER: {
                    complexPanel.getXTileSpinner().setValue(value);
                    break;
                }
                case Y_TILE_SPINNER: {
                    complexPanel.getYTileSpinner().setValue(value);
                    break;
                }
                case Z_TILE_SPINNER: {
                    complexPanel.getZTileSpinner().setValue(value);
                    break;
                }
                case X_SPINNER: {
                    complexPanel.getXSpinner().setValue(value);
                    break;
                }
                case Y_SPINNER: {
                    complexPanel.getYSpinner().setValue(value);
                    break;
                }
                case Z_SPINNER: {
                    complexPanel.getZSpinner().setValue(value);
                    break;
                }
                case X_SCALE_SPINNER: {
                    complexPanel.getXScaleSpinner().setValue(value);
                    break;
                }
                case Y_SCALE_SPINNER: {
                    complexPanel.getYScaleSpinner().setValue(value);
                    break;
                }
                case Z_SCALE_SPINNER: {
                    complexPanel.getZScaleSpinner().setValue(value);
                }
            }
        }
    }

    private void setValueComboBox(JComboBox<String> comboBox, ItemEvent e, ItemListener itemListener) {
        if (e.getItem() == "Rot") {
            return;
        }
        for (ComplexPanel complexPanel : this.plugin.getComplexPanels()) {
            if (complexPanel.getGroupSpinner().getValue() != this.groupSpinner.getValue()) continue;
            switch (Integer.parseInt((String)e.getItem())) {
                case 0: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(false);
                    break;
                }
                case 90: {
                    complexPanel.getCheck90().setSelected(true);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(false);
                    break;
                }
                case 180: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(true);
                    complexPanel.getCheck270().setSelected(false);
                    break;
                }
                case 270: {
                    complexPanel.getCheck90().setSelected(false);
                    complexPanel.getCheck180().setSelected(false);
                    complexPanel.getCheck270().setSelected(true);
                }
            }
        }
        comboBox.removeItemListener(itemListener);
        comboBox.setSelectedItem("Rot");
        comboBox.addItemListener(itemListener);
    }

    private JPanel createXYZPanel() {
        JPanel xyzPanel = new JPanel();
        xyzPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        xyzPanel.setLayout(new GridLayout(3, 0));
        JLabel xLabel = new JLabel("x:");
        xLabel.setToolTipText("East/West");
        xLabel.setHorizontalAlignment(4);
        xyzPanel.add(xLabel);
        JLabel yLabel = new JLabel("y:");
        yLabel.setToolTipText("North/South");
        yLabel.setHorizontalAlignment(4);
        xyzPanel.add(yLabel);
        JLabel zLabel = new JLabel("z:");
        zLabel.setToolTipText("Up/Down");
        zLabel.setHorizontalAlignment(4);
        xyzPanel.add(zLabel);
        return xyzPanel;
    }

    private BasicSpinnerUI createEmptySpinner() {
        return new BasicSpinnerUI(){

            @Override
            protected Component createNextButton() {
                return null;
            }

            @Override
            protected Component createPreviousButton() {
                return null;
            }
        };
    }
}

