/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.swing;

import com.creatorskit.Character;
import com.creatorskit.CharacterSave;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.SaveFile;
import com.creatorskit.models.CustomModel;
import com.creatorskit.models.CustomModelComp;
import com.creatorskit.models.LightingStyle;
import com.creatorskit.models.ModelStats;
import com.creatorskit.programming.Coordinate;
import com.creatorskit.programming.MovementType;
import com.creatorskit.programming.Program;
import com.creatorskit.programming.ProgramComp;
import com.creatorskit.swing.ModelAnvil;
import com.creatorskit.swing.ModelOrganizer;
import com.creatorskit.swing.ProgramPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatorsPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(CreatorsPanel.class);
    @Inject
    private ClientThread clientThread;
    private final CreatorsPlugin plugin;
    private final ModelAnvil modelAnvil;
    private final ModelOrganizer modelOrganizer;
    private final ProgramPanel programPanel;
    private final JButton addObjectButton = new JButton();
    private final JPanel mainPanel = new JPanel();
    private final GridBagConstraints cNPC = new GridBagConstraints();
    private final Random random = new Random();
    public static final File SETUP_DIR = new File(RuneLite.RUNELITE_DIR, "creatorskit-setups");
    private final Pattern pattern = Pattern.compile("\\(\\d+\\)\\Z");
    private int npcPanels = 0;
    private final ArrayList<JPanel> objectPanels = new ArrayList();
    private final ArrayList<JComboBox<CustomModel>> comboBoxes = new ArrayList();
    private final Dimension spinnerSize = new Dimension(72, 30);
    private final int DEFAULT_TURN_SPEED = 68;
    private final BufferedImage MAXIMIZE = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Maximize.png");
    private final BufferedImage MINIMIZE = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Minimize.png");
    private final BufferedImage DUPLICATE = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Duplicate.png");
    private final BufferedImage CLOSE = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Close.png");
    private final BufferedImage CLEAR = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Clear.png");
    private final BufferedImage LOAD = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Load.png");
    private final BufferedImage SAVE = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Save.png");
    private final BufferedImage CUSTOM_MODEL = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Custom model.png");
    public static final File MODELS_DIR = new File(RuneLite.RUNELITE_DIR, "creatorskit");
    private final LineBorder defaultBorder = new LineBorder(ColorScheme.MEDIUM_GRAY_COLOR, 1);
    private final LineBorder hoveredBorder = new LineBorder(ColorScheme.LIGHT_GRAY_COLOR, 1);
    private final LineBorder selectedBorder = new LineBorder(Color.WHITE, 1);

    @Inject
    public CreatorsPanel(@Nullable Client client, ClientThread clientThread, CreatorsPlugin plugin, ModelOrganizer modelOrganizer, ProgramPanel programPanel, ModelAnvil modelAnvil) {
        this.clientThread = clientThread;
        this.plugin = plugin;
        this.modelOrganizer = modelOrganizer;
        this.programPanel = programPanel;
        this.modelAnvil = modelAnvil;
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        JButton organizerButton = new JButton("Organizer");
        organizerButton.setToolTipText("Opens an interface for managing custom models");
        organizerButton.setFocusable(false);
        organizerButton.addActionListener(e -> {
            modelOrganizer.setVisible(!modelOrganizer.isVisible());
            this.revalidate();
            this.repaint();
        });
        this.add(organizerButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        JButton anvilButton = new JButton("Anvil");
        anvilButton.setToolTipText("Opens an interface for creating custom models");
        anvilButton.setFocusable(false);
        anvilButton.addActionListener(e -> {
            modelAnvil.setVisible(!modelAnvil.isVisible());
            this.revalidate();
            this.repaint();
        });
        this.add(anvilButton, c);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        JButton programmerButton = new JButton("Programmer");
        programmerButton.setToolTipText("Opens an interface for programming object actions");
        programmerButton.setFocusable(false);
        programmerButton.addActionListener(e -> {
            programPanel.setVisible(!programPanel.isVisible());
            this.revalidate();
            this.repaint();
        });
        this.add(programmerButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.addObjectButton.setText("Add Object");
        this.addObjectButton.setToolTipText("Add an new Object to the palette");
        this.addObjectButton.setFocusable(false);
        this.addObjectButton.addActionListener(e -> this.createPanel());
        this.add(this.addObjectButton, c);
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JButton saveButton = new JButton(new ImageIcon(this.SAVE));
        saveButton.setFocusable(false);
        saveButton.setToolTipText("Save this setup");
        this.add(saveButton, c);
        saveButton.addActionListener(this::actionPerformed);
        c.gridx = 4;
        c.gridy = 1;
        JButton loadButton = new JButton(new ImageIcon(this.LOAD));
        loadButton.setFocusable(false);
        loadButton.setToolTipText("Load a previously saved setup");
        this.add(loadButton, c);
        loadButton.addActionListener(e -> this.openLoadSetupDialog());
        c.gridx = 3;
        c.gridy = 2;
        JButton loadCustomModelButton = new JButton(new ImageIcon(this.CUSTOM_MODEL));
        loadCustomModelButton.setFocusable(false);
        loadCustomModelButton.setToolTipText("Load a previously saved Custom Model");
        this.add(loadCustomModelButton, c);
        loadCustomModelButton.addActionListener(e -> this.openLoadCustomModelDialog());
        c.gridx = 4;
        c.gridy = 2;
        JButton clearButton = new JButton(new ImageIcon(this.CLEAR));
        clearButton.setFocusable(false);
        clearButton.setToolTipText("Clears all Objects");
        this.add(clearButton, c);
        clearButton.addActionListener(e -> this.clearPanels());
        c.gridwidth = 5;
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 1.0;
        c.fill = 2;
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add(this.mainPanel, c);
        this.cNPC.fill = 2;
        this.cNPC.insets = new Insets(2, 2, 2, 2);
        this.cNPC.gridx = 0;
        this.cNPC.gridy = 0;
        this.cNPC.weightx = 1.0;
        this.cNPC.weighty = 1.0;
    }

    public JPanel createPanel() {
        return this.createPanel("Object (" + this.npcPanels + ")", 7699, null, false, false, 0, -1, 60, this.createEmptyProgram(), false, null, null, new int[0], -1, false);
    }

    public JPanel createPanel(String name, int modelId, CustomModel customModel, boolean customModeActive, boolean setMinimized, int orientation, int animationId, int radius, Program program, boolean active, WorldPoint worldPoint, LocalPoint localPoint, int[] localPointRegion, int localPointPlane, boolean inInstance) {
        final JPanel masterPanel = new JPanel();
        masterPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        masterPanel.setBorder(this.defaultBorder);
        masterPanel.setLayout(new GridBagLayout());
        masterPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int y = e.getPoint().y;
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        JTextField textField = new JTextField(name);
        masterPanel.add((Component)textField, c);
        c.fill = 1;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        JPanel topButtonsPanel = new JPanel();
        Dimension topButtonsPanelSize = new Dimension(81, 30);
        topButtonsPanel.setMaximumSize(topButtonsPanelSize);
        topButtonsPanel.setPreferredSize(topButtonsPanelSize);
        topButtonsPanel.setMinimumSize(topButtonsPanelSize);
        topButtonsPanel.setLayout(new GridLayout(1, 3, 1, 0));
        masterPanel.add((Component)topButtonsPanel, c);
        JButton duplicateButton = new JButton(new ImageIcon(this.DUPLICATE));
        duplicateButton.setName("Duplicate");
        duplicateButton.setToolTipText("Duplicate object");
        duplicateButton.setFocusable(false);
        topButtonsPanel.add(duplicateButton);
        boolean[] minimized = new boolean[]{setMinimized};
        ImageIcon minimize = new ImageIcon(this.MINIMIZE);
        ImageIcon maximize = new ImageIcon(this.MAXIMIZE);
        JButton minimizeButton = new JButton(minimize);
        minimizeButton.setToolTipText("Minimize");
        minimizeButton.setFocusable(false);
        topButtonsPanel.add(minimizeButton);
        JButton deleteButton = new JButton(new ImageIcon(this.CLOSE));
        deleteButton.setName("Delete");
        deleteButton.setToolTipText("Delete object");
        deleteButton.setFocusable(false);
        topButtonsPanel.add(deleteButton);
        c.fill = 3;
        c.anchor = 10;
        c.ipadx = 0;
        c.ipady = 5;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        JButton modelButton = new JButton();
        modelButton.setFont(FontManager.getRunescapeFont());
        String modelButtonText = customModeActive ? "Custom" : "Id";
        modelButton.setText(modelButtonText);
        modelButton.setText("Custom");
        modelButton.setToolTipText("Toggle between Custom Model and Model ID");
        modelButton.setFocusable(false);
        masterPanel.add((Component)modelButton, c);
        ++c.gridy;
        JButton spawnButton = new JButton();
        spawnButton.setFont(FontManager.getRunescapeFont());
        spawnButton.setText("Spawn");
        spawnButton.setToolTipText("Toggle the NPC on or off");
        spawnButton.setFocusable(false);
        masterPanel.add((Component)spawnButton, c);
        ++c.gridy;
        JButton relocateButton = new JButton();
        relocateButton.setFont(FontManager.getRunescapeFont());
        relocateButton.setText("Relocate");
        relocateButton.setToolTipText("Set the object's location to the selected tile");
        relocateButton.setFocusable(false);
        masterPanel.add((Component)relocateButton, c);
        ++c.gridy;
        JButton animationButton = new JButton();
        animationButton.setFont(FontManager.getRunescapeFont());
        animationButton.setText("Anim Off");
        animationButton.setToolTipText("Toggle the playing animation");
        animationButton.setFocusable(false);
        masterPanel.add((Component)animationButton, c);
        c.fill = 0;
        c.anchor = 22;
        c.ipadx = 0;
        c.ipady = 0;
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        JLabel modelLabel = new JLabel("Model ID:");
        modelLabel.setToolTipText("The ID number of the model to spawn");
        modelLabel.setFont(FontManager.getRunescapeSmallFont());
        masterPanel.add((Component)modelLabel, c);
        ++c.gridy;
        JLabel orientationLabel = new JLabel("Rotation:");
        orientationLabel.setToolTipText("0 = South, 512 = West, 1024 = North, 1736 = East, 2048 = Max");
        orientationLabel.setFont(FontManager.getRunescapeSmallFont());
        masterPanel.add((Component)orientationLabel, c);
        ++c.gridy;
        JLabel radiusLabel = new JLabel("Radius:");
        radiusLabel.setToolTipText("Increasing the radius may prevent clipping issues with the ground");
        radiusLabel.setFont(FontManager.getRunescapeSmallFont());
        masterPanel.add((Component)radiusLabel, c);
        ++c.gridy;
        JLabel animationLabel = new JLabel("Anim ID:");
        animationLabel.setToolTipText("The animation ID number. -1 gives no animation");
        animationLabel.setFont(FontManager.getRunescapeSmallFont());
        masterPanel.add((Component)animationLabel, c);
        boolean[] customMode = new boolean[]{customModeActive};
        c.fill = 1;
        c.anchor = 10;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 1;
        JSpinner modelSpinner = new JSpinner();
        modelSpinner.setValue(modelId);
        modelSpinner.setVisible(!customMode[0]);
        modelSpinner.setMaximumSize(this.spinnerSize);
        modelSpinner.setPreferredSize(this.spinnerSize);
        modelSpinner.setMinimumSize(this.spinnerSize);
        masterPanel.add((Component)modelSpinner, c);
        JComboBox<CustomModel> modelComboBox = new JComboBox<CustomModel>();
        modelComboBox.setFont(FontManager.getRunescapeFont());
        modelComboBox.setVisible(customMode[0]);
        modelComboBox.setFocusable(false);
        modelComboBox.setName("modelComboBox");
        modelComboBox.setMaximumSize(this.spinnerSize);
        modelComboBox.setPreferredSize(this.spinnerSize);
        modelComboBox.setMinimumSize(this.spinnerSize);
        for (CustomModel model : this.plugin.getStoredModels()) {
            modelComboBox.addItem(model);
        }
        if (customModel != null) {
            modelComboBox.setSelectedItem(customModel);
        }
        masterPanel.add(modelComboBox, c);
        ++c.gridy;
        SpinnerNumberModel orientationRange = new SpinnerNumberModel(orientation, 0, 2048, 1);
        JSpinner orientationSpinner = new JSpinner(orientationRange);
        orientationSpinner.setName("orientationSpinner");
        orientationSpinner.setMaximumSize(this.spinnerSize);
        orientationSpinner.setPreferredSize(this.spinnerSize);
        orientationSpinner.setMinimumSize(this.spinnerSize);
        masterPanel.add((Component)orientationSpinner, c);
        ++c.gridy;
        JSpinner radiusSpinner = new JSpinner();
        radiusSpinner.setValue(radius);
        radiusSpinner.setMaximumSize(this.spinnerSize);
        radiusSpinner.setPreferredSize(this.spinnerSize);
        radiusSpinner.setMinimumSize(this.spinnerSize);
        masterPanel.add((Component)radiusSpinner, c);
        ++c.gridy;
        JSpinner animationSpinner = new JSpinner();
        animationSpinner.setValue(animationId);
        animationSpinner.setMaximumSize(this.spinnerSize);
        animationSpinner.setPreferredSize(this.spinnerSize);
        animationSpinner.setMinimumSize(this.spinnerSize);
        masterPanel.add((Component)animationSpinner, c);
        if (setMinimized) {
            customMode[0] = modelComboBox.isVisible();
            relocateButton.setVisible(false);
            modelButton.setVisible(false);
            modelLabel.setVisible(false);
            modelSpinner.setVisible(false);
            modelComboBox.setVisible(false);
            spawnButton.setVisible(false);
            orientationLabel.setVisible(false);
            orientationSpinner.setVisible(false);
            animationButton.setVisible(false);
            animationLabel.setVisible(false);
            animationSpinner.setVisible(false);
            radiusLabel.setVisible(false);
            radiusSpinner.setVisible(false);
            minimizeButton.setIcon(maximize);
            minimizeButton.setToolTipText("Maximize");
            masterPanel.updateUI();
        }
        JLabel programmerNameLabel = program.getNameLabel();
        programmerNameLabel.setText(name);
        JSpinner programmerIdleSpinner = program.getIdleAnimSpinner();
        JPanel programJPanel = new JPanel();
        this.clientThread.invokeLater(() -> {
            final Character character = this.plugin.buildCharacter(textField.getText(), masterPanel, textField, relocateButton, spawnButton, animationButton, modelButton, modelId, modelSpinner, modelComboBox, customMode[0], minimized[0], orientation, orientationSpinner, radius, radiusSpinner, animationId, animationSpinner, program, programmerNameLabel, programmerIdleSpinner, active, worldPoint, localPoint, localPointRegion, localPointPlane, inInstance);
            SwingUtilities.invokeLater(() -> this.programPanel.createProgramPanel(character, programJPanel, programmerNameLabel, programmerIdleSpinner));
            deleteButton.addActionListener(e -> {
                this.mainPanel.remove(masterPanel);
                this.objectPanels.remove(masterPanel);
                SwingUtilities.invokeLater(() -> this.programPanel.removeProgramPanel(programJPanel));
                ArrayList<Character> characters = this.plugin.getCharacters();
                for (Character npc : characters) {
                    if (npc.getMasterPanel() != masterPanel) continue;
                    this.clientThread.invokeLater(() -> npc.getRuneLiteObject().setActive(false));
                    characters.remove(npc);
                    this.plugin.setSelectedCharacter(null);
                    this.mainPanel.updateUI();
                    return;
                }
            });
            duplicateButton.addActionListener(e -> {
                ProgramComp comp = program.getComp();
                WorldPoint[] newSteps = (WorldPoint[])ArrayUtils.clone((Object[])comp.getStepsWP());
                WorldPoint[] newPath = (WorldPoint[])ArrayUtils.clone((Object[])comp.getPathWP());
                LocalPoint[] newStepsLP = (LocalPoint[])ArrayUtils.clone((Object[])comp.getStepsLP());
                LocalPoint[] newPathLP = (LocalPoint[])ArrayUtils.clone((Object[])comp.getPathLP());
                Coordinate[] newCoordinates = (Coordinate[])ArrayUtils.clone((Object[])comp.getCoordinates());
                ProgramComp newComp = new ProgramComp(newSteps, newPath, newStepsLP, newPathLP, newCoordinates, 0, comp.getSpeed(), comp.getTurnSpeed(), comp.getIdleAnim(), comp.getWalkAnim(), comp.getMovementType(), this.getRandomColor(), comp.isLoop(), comp.isProgramActive());
                Object newName = textField.getText();
                Matcher matcher = this.pattern.matcher((CharSequence)newName);
                if (matcher.find()) {
                    String duplicate = matcher.group();
                    duplicate = duplicate.replace("(", "");
                    duplicate = duplicate.replace(")", "");
                    int duplicateNumber = Integer.parseInt(duplicate) + 1;
                    newName = ((String)newName).replaceFirst("(?s)" + duplicate + "(?!.*?" + duplicate + ")", "" + duplicateNumber);
                } else {
                    newName = (String)newName + " (1)";
                }
                Program newProgram = new Program(newComp, new JLabel(), new JSpinner());
                this.createPanel((String)newName, (Integer)modelSpinner.getValue(), (CustomModel)modelComboBox.getSelectedItem(), character.isCustomMode(), minimized[0], (Integer)orientationSpinner.getValue(), (Integer)animationSpinner.getValue(), (Integer)radiusSpinner.getValue(), newProgram, character.getRuneLiteObject().isActive(), character.getNonInstancedPoint(), character.getInstancedPoint(), character.getInstancedRegions(), character.getInstancedPlane(), character.isInInstance());
            });
            minimizeButton.addActionListener(e -> {
                if (!character.isMinimized()) {
                    customMode[0] = modelComboBox.isVisible();
                    relocateButton.setVisible(false);
                    modelButton.setVisible(false);
                    modelLabel.setVisible(false);
                    modelSpinner.setVisible(false);
                    modelComboBox.setVisible(false);
                    spawnButton.setVisible(false);
                    orientationLabel.setVisible(false);
                    orientationSpinner.setVisible(false);
                    animationButton.setVisible(false);
                    animationLabel.setVisible(false);
                    animationSpinner.setVisible(false);
                    radiusLabel.setVisible(false);
                    radiusSpinner.setVisible(false);
                    minimizeButton.setIcon(maximize);
                    character.setMinimized(true);
                    minimizeButton.setToolTipText("Maximize");
                    masterPanel.updateUI();
                    return;
                }
                relocateButton.setVisible(true);
                modelButton.setVisible(true);
                modelLabel.setVisible(true);
                if (customMode[0]) {
                    modelComboBox.setVisible(true);
                } else {
                    modelSpinner.setVisible(true);
                }
                spawnButton.setVisible(true);
                orientationLabel.setVisible(true);
                orientationSpinner.setVisible(true);
                animationButton.setVisible(true);
                animationLabel.setVisible(true);
                animationSpinner.setVisible(true);
                radiusLabel.setVisible(true);
                radiusSpinner.setVisible(true);
                minimizeButton.setIcon(minimize);
                character.setMinimized(false);
                minimizeButton.setToolTipText("Minimize");
                masterPanel.updateUI();
            });
            masterPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    CreatorsPanel.this.setSelectedCharacter(character, masterPanel);
                }
            });
            masterPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    CreatorsPanel.this.setHoveredCharacter(character, masterPanel);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    CreatorsPanel.this.unsetHoveredCharacter(character, masterPanel);
                }
            });
            ArrayList<Component> list = new ArrayList<Component>();
            for (Component component : masterPanel.getComponents()) {
                list.add(component);
                if (!(component instanceof Container)) continue;
                Container container = (Container)component;
                list.addAll(List.of(container.getComponents()));
                for (Component comp : container.getComponents()) {
                    if (!(comp instanceof Container)) continue;
                    Container container1 = (Container)comp;
                    list.addAll(List.of(container1.getComponents()));
                }
            }
            for (Component component : list) {
                component.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        CreatorsPanel.this.setHoveredCharacter(character, masterPanel);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        CreatorsPanel.this.unsetHoveredCharacter(character, masterPanel);
                    }
                });
                String compName = component.getName();
                if (compName != null && (compName.equals("Duplicate") || compName.equals("Delete"))) continue;
                component.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        CreatorsPanel.this.setSelectedCharacter(character, masterPanel);
                    }
                });
            }
            this.setSelectedCharacter(character, masterPanel);
        });
        this.mainPanel.add((Component)masterPanel, this.cNPC);
        this.mainPanel.updateUI();
        this.objectPanels.add(masterPanel);
        this.comboBoxes.add(modelComboBox);
        ++this.npcPanels;
        ++this.cNPC.gridy;
        return masterPanel;
    }

    public void clearPanels() {
        this.objectPanels.clear();
        this.mainPanel.removeAll();
        this.plugin.clearNPCs();
        this.plugin.setSelectedCharacter(null);
        this.mainPanel.updateUI();
        JPanel programmerAllPanel = this.programPanel.getAllPanel();
        Component[] components = programmerAllPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!(component instanceof JPanel)) continue;
            JPanel program = (JPanel)component;
            programmerAllPanel.remove(program);
        }
        this.programPanel.revalidate();
        this.programPanel.repaint();
    }

    public void setSelectedCharacter(Character selected, JPanel jPanel) {
        for (JPanel panel : this.objectPanels) {
            panel.setBorder(this.defaultBorder);
        }
        jPanel.setBorder(this.selectedBorder);
        this.plugin.setSelectedCharacter(selected);
    }

    public void setHoveredCharacter(Character hovered, JPanel jPanel) {
        if (this.plugin.getSelectedCharacter() == hovered) {
            return;
        }
        jPanel.setBorder(this.hoveredBorder);
        this.plugin.setHoveredCharacter(hovered);
    }

    public void unsetHoveredCharacter(Character hoverRemoved, JPanel jPanel) {
        this.plugin.setHoveredCharacter(null);
        if (this.plugin.getSelectedCharacter() == hoverRemoved) {
            return;
        }
        jPanel.setBorder(this.defaultBorder);
    }

    public void addModelOption(CustomModel model, boolean setComboBox) {
        this.modelOrganizer.createModelPanel(model);
        Character selectedNPC = this.plugin.getSelectedCharacter();
        for (JComboBox<CustomModel> comboBox : this.comboBoxes) {
            comboBox.addItem(model);
            if (!setComboBox || selectedNPC == null) continue;
            JComboBox<CustomModel> selectedBox = selectedNPC.getComboBox();
            if (comboBox == selectedBox) {
                comboBox.setSelectedItem(model);
                selectedNPC.setCustomMode(true);
                selectedNPC.getModelButton().setText("Custom");
                if (selectedNPC.getModelSpinner().isVisible() || comboBox.isVisible()) {
                    comboBox.setVisible(true);
                    selectedNPC.getModelSpinner().setVisible(false);
                }
            }
            selectedNPC.setStoredModel(model);
            this.plugin.setModel(selectedNPC, true, -1);
        }
    }

    public void removeModelOption(CustomModel model) {
        for (JComboBox<CustomModel> comboBox : this.comboBoxes) {
            comboBox.removeItem(model);
        }
        this.modelOrganizer.removeModelPanel(model);
    }

    private Color getRandomColor() {
        float r = this.random.nextFloat();
        float g = this.random.nextFloat();
        float b = this.random.nextFloat();
        return new Color(r, g, b);
    }

    private Program createEmptyProgram() {
        ProgramComp comp = new ProgramComp(new WorldPoint[0], new WorldPoint[0], new LocalPoint[0], new LocalPoint[0], new Coordinate[0], 0, 1.0, 68, -1, -1, MovementType.NORMAL, this.getRandomColor(), false, false);
        return new Program(comp, new JLabel(), new JSpinner());
    }

    private void openSaveDialog() {
        File outputDir = SETUP_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getName().endsWith(".json")) {
                    f = new File(f.getPath() + ".json");
                }
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists, overwrite?", "Warning", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File("setup"));
        fileChooser.setDialogTitle("Save current setup");
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith(".json")) {
                selectedFile = new File(selectedFile.getPath() + ".json");
            }
            this.saveToFile(selectedFile);
        }
    }

    public void saveToFile(File file) {
        int i;
        ArrayList<Character> characters = this.plugin.getCharacters();
        CharacterSave[] characterSaves = new CharacterSave[characters.size()];
        ArrayList<CustomModel> customModels = this.plugin.getStoredModels();
        CustomModelComp[] comps = new CustomModelComp[customModels.size()];
        for (i = 0; i < comps.length; ++i) {
            comps[i] = customModels.get(i).getComp();
        }
        for (i = 0; i < characters.size(); ++i) {
            Character character = characters.get(i);
            String name = character.getName();
            boolean locationSet = character.isLocationSet();
            WorldPoint savedWorldPoint = character.getNonInstancedPoint();
            LocalPoint savedLocalPoint = character.getInstancedPoint();
            int[] localPointRegion = character.getInstancedRegions();
            int localPointPlane = character.getInstancedPlane();
            boolean inInstance = character.isInInstance();
            int compId = 0;
            CustomModel storedModel = character.getStoredModel();
            if (storedModel != null) {
                for (int e = 0; e < comps.length; ++e) {
                    CustomModelComp comp = comps[e];
                    if (storedModel.getComp() != comp) continue;
                    compId = e;
                    break;
                }
            }
            boolean customMode = character.isCustomMode();
            boolean minimized = character.isMinimized();
            int modelId = (Integer)character.getModelSpinner().getValue();
            boolean active = character.getRuneLiteObject().isActive();
            int radius = character.getRuneLiteObject().getRadius();
            int rotation = (Integer)character.getOrientationSpinner().getValue();
            int animationId = (Integer)character.getAnimationSpinner().getValue();
            ProgramComp programComp = character.getProgram().getComp();
            characterSaves[i] = new CharacterSave(name, locationSet, savedWorldPoint, savedLocalPoint, localPointRegion, localPointPlane, inInstance, compId, customMode, minimized, modelId, active, radius, rotation, animationId, programComp);
        }
        SaveFile saveFile = new SaveFile(comps, characterSaves);
        try {
            FileWriter writer = new FileWriter(file, false);
            String string = this.plugin.gson.toJson((Object)saveFile);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("Error occurred while writing to file.");
        }
    }

    private void openLoadCustomModelDialog() {
        MODELS_DIR.mkdirs();
        JFileChooser fileChooser = new JFileChooser(MODELS_DIR);
        fileChooser.setDialogTitle("Choose a model to load");
        JCheckBox priorityCheckbox = new JCheckBox("Set Priority?");
        priorityCheckbox.setToolTipText("May resolve some rendering issues by setting all faces to the same priority. Leave off if you're unsure");
        JComboBox<LightingStyle> comboBox = new JComboBox<LightingStyle>();
        comboBox.setToolTipText("Sets the lighting style");
        comboBox.addItem(LightingStyle.DEFAULT);
        comboBox.addItem(LightingStyle.ACTOR);
        comboBox.addItem(LightingStyle.NONE);
        comboBox.setFocusable(false);
        JPanel accessory = new JPanel();
        accessory.setLayout(new GridLayout(0, 1));
        accessory.add(priorityCheckbox);
        accessory.add(comboBox);
        fileChooser.setAccessory(accessory);
        int option = fileChooser.showOpenDialog(fileChooser);
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            String name = selectedFile.getName();
            if (name.endsWith(".json")) {
                name = this.replaceLast(name, ".json");
            }
            if (name.endsWith(".txt")) {
                name = this.replaceLast(name, ".txt");
            }
            this.plugin.loadCustomModel(selectedFile, priorityCheckbox.isSelected(), (LightingStyle)((Object)comboBox.getSelectedItem()), name);
        }
    }

    private String replaceLast(String string, String from) {
        int lastIndex = string.lastIndexOf(from);
        if (lastIndex < 0) {
            return string;
        }
        String tail = string.substring(lastIndex).replaceFirst(from, "");
        return string.substring(0, lastIndex) + tail;
    }

    private void openLoadSetupDialog() {
        File outputDir = SETUP_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir);
        fileChooser.setDialogTitle("Choose a setup to load");
        int option = fileChooser.showOpenDialog((Component)((Object)this));
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            try {
                BufferedReader reader = Files.newBufferedReader(selectedFile.toPath());
                SaveFile saveFile = (SaveFile)this.plugin.gson.fromJson((Reader)reader, SaveFile.class);
                this.clientThread.invokeLater(() -> this.loadSetup(saveFile));
                ((Reader)reader).close();
            }
            catch (Exception e) {
                this.plugin.sendChatMessage("An error occurred while attempting to read this file.");
            }
        }
    }

    public void loadSetup(File file) {
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            SaveFile saveFile = (SaveFile)this.plugin.gson.fromJson((Reader)reader, SaveFile.class);
            this.clientThread.invokeLater(() -> this.loadSetup(saveFile));
            ((Reader)reader).close();
        }
        catch (Exception e) {
            this.plugin.sendChatMessage("An error occurred while attempting to read this file.");
        }
    }

    private void loadSetup(SaveFile saveFile) {
        CustomModelComp[] comps = saveFile.getComps();
        CharacterSave[] characterSaves = saveFile.getSaves();
        CustomModel[] customModels = new CustomModel[comps.length];
        if (comps.length == 0) {
            for (CharacterSave save : characterSaves) {
                SwingUtilities.invokeLater(() -> {
                    Program program = new Program(save.getProgramComp(), new JLabel(), new JSpinner());
                    this.createPanel(save.getName(), save.getModelId(), null, save.isCustomMode(), save.isMinimized(), save.getRotation(), save.getAnimationId(), save.getRadius(), program, save.isActive(), save.getNonInstancedPoint(), save.getInstancedPoint(), save.getInstancedRegions(), save.getInstancedPlane(), save.isInInstance());
                });
            }
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            CustomModel customModel;
            CustomModelComp comp = comps[i];
            switch (comp.getType()) {
                case FORGED: {
                    Model model = this.plugin.createComplexModel(comp.getDetailedModels(), comp.isPriority(), comp.getLightingStyle());
                    customModel = new CustomModel(model, comp);
                    break;
                }
                case CACHE_NPC: {
                    ModelStats[] modelStats = comp.getModelStats();
                    Model model = this.plugin.constructModelFromCache(modelStats, new int[0], false, true);
                    customModel = new CustomModel(model, comp);
                    break;
                }
                case CACHE_PLAYER: {
                    ModelStats[] modelStats = comp.getModelStats();
                    Model model = this.plugin.constructModelFromCache(modelStats, comp.getKitRecolours(), true, true);
                    customModel = new CustomModel(model, comp);
                    break;
                }
                default: {
                    ModelStats[] modelStats = comp.getModelStats();
                    Model model = this.plugin.constructModelFromCache(modelStats, null, false, false);
                    customModel = new CustomModel(model, comp);
                }
            }
            this.plugin.addCustomModel(customModel, false);
            customModels[i] = customModel;
        }
        for (CharacterSave save : characterSaves) {
            SwingUtilities.invokeLater(() -> {
                Program program = new Program(save.getProgramComp(), new JLabel(), new JSpinner());
                this.createPanel(save.getName(), save.getModelId(), customModels[save.getCompId()], save.isCustomMode(), save.isMinimized(), save.getRotation(), save.getAnimationId(), save.getRadius(), program, save.isActive(), save.getNonInstancedPoint(), save.getInstancedPoint(), save.getInstancedRegions(), save.getInstancedPlane(), save.isInInstance());
            });
        }
    }

    private void actionPerformed(ActionEvent e) {
        this.openSaveDialog();
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public CreatorsPlugin getPlugin() {
        return this.plugin;
    }

    public ModelAnvil getModelAnvil() {
        return this.modelAnvil;
    }

    public ModelOrganizer getModelOrganizer() {
        return this.modelOrganizer;
    }

    public ProgramPanel getProgramPanel() {
        return this.programPanel;
    }

    public JButton getAddObjectButton() {
        return this.addObjectButton;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public GridBagConstraints getCNPC() {
        return this.cNPC;
    }

    public Random getRandom() {
        return this.random;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getNpcPanels() {
        return this.npcPanels;
    }

    public ArrayList<JPanel> getObjectPanels() {
        return this.objectPanels;
    }

    public ArrayList<JComboBox<CustomModel>> getComboBoxes() {
        return this.comboBoxes;
    }

    public Dimension getSpinnerSize() {
        return this.spinnerSize;
    }

    public int getDEFAULT_TURN_SPEED() {
        return this.DEFAULT_TURN_SPEED;
    }

    public BufferedImage getMAXIMIZE() {
        return this.MAXIMIZE;
    }

    public BufferedImage getMINIMIZE() {
        return this.MINIMIZE;
    }

    public BufferedImage getDUPLICATE() {
        return this.DUPLICATE;
    }

    public BufferedImage getCLOSE() {
        return this.CLOSE;
    }

    public BufferedImage getCLEAR() {
        return this.CLEAR;
    }

    public BufferedImage getLOAD() {
        return this.LOAD;
    }

    public BufferedImage getSAVE() {
        return this.SAVE;
    }

    public BufferedImage getCUSTOM_MODEL() {
        return this.CUSTOM_MODEL;
    }

    public LineBorder getDefaultBorder() {
        return this.defaultBorder;
    }

    public LineBorder getHoveredBorder() {
        return this.hoveredBorder;
    }

    public LineBorder getSelectedBorder() {
        return this.selectedBorder;
    }
}

