/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.programming;

import com.creatorskit.Character;
import com.creatorskit.CreatorsConfig;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.programming.Coordinate;
import com.creatorskit.programming.MovementType;
import com.creatorskit.programming.Program;
import com.creatorskit.programming.ProgramComp;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.CollisionData;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.apache.commons.lang3.ArrayUtils;

public class PathFinder {
    @Inject
    private CreatorsPlugin plugin;
    @Inject
    private Client client;
    @Inject
    private CreatorsConfig config;
    private final int WATER_OVERLAY = 6;
    private final int REGION_ID_X = 256;
    private final int[] directionColumn = new int[]{1, -1, 0, 0, -1, 1, -1, 1};
    private final int[] directionRow = new int[]{0, 0, -1, 1, -1, -1, 1, 1};
    private final int[][] directionBlocks = new int[][]{{8}, {128}, {32}, {2}, {64, 32, 128}, {16, 32, 8}, {1, 2, 128}, {4, 2, 8}};

    public Coordinate[] getPath(LocalPoint startLocation, LocalPoint destLocation, MovementType movementType) {
        ArrayList<Integer> rowQueue = new ArrayList<Integer>();
        ArrayList<Integer> columnQueue = new ArrayList<Integer>();
        boolean[][] visited = new boolean[104][104];
        Coordinate[][] path = new Coordinate[104][104];
        boolean reachedEnd = false;
        if (startLocation == null || destLocation == null) {
            return null;
        }
        int startX = startLocation.getSceneX();
        int startY = startLocation.getSceneY();
        int endX = destLocation.getSceneX();
        int endY = destLocation.getSceneY();
        rowQueue.add(startY);
        columnQueue.add(startX);
        visited[startX][startY] = true;
        if (this.client.getCollisionMaps() == null) {
            return null;
        }
        CollisionData data = this.client.getCollisionMaps()[this.client.getPlane()];
        short[][] overlays = this.client.getScene().getOverlayIds()[this.client.getPlane()];
        while (!rowQueue.isEmpty() && !columnQueue.isEmpty()) {
            int row = (Integer)rowQueue.get(0);
            int column = (Integer)columnQueue.get(0);
            rowQueue.remove(0);
            columnQueue.remove(0);
            if (row == endY && column == endX) {
                reachedEnd = true;
                break;
            }
            this.exploreNeighbours(row, column, data, overlays, visited, columnQueue, rowQueue, path, movementType);
        }
        if (reachedEnd) {
            return this.reconstructPath(endX, endY, path);
        }
        return null;
    }

    public Coordinate[] getPath(WorldPoint startLocation, WorldPoint destLocation, MovementType movementType) {
        ArrayList<Integer> rowQueue = new ArrayList<Integer>();
        ArrayList<Integer> columnQueue = new ArrayList<Integer>();
        boolean[][] visited = new boolean[104][104];
        Coordinate[][] path = new Coordinate[104][104];
        boolean reachedEnd = false;
        Collection startPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)startLocation);
        WorldPoint startPoint = (WorldPoint)startPoints.iterator().next();
        Collection destPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)destLocation);
        WorldPoint destPoint = (WorldPoint)destPoints.iterator().next();
        LocalPoint startLoc = LocalPoint.fromWorld((Client)this.client, (WorldPoint)startPoint);
        LocalPoint destLoc = LocalPoint.fromWorld((Client)this.client, (WorldPoint)destPoint);
        if (startLoc == null || destLoc == null) {
            return null;
        }
        int startX = startLoc.getSceneX();
        int startY = startLoc.getSceneY();
        int endX = destLoc.getSceneX();
        int endY = destLoc.getSceneY();
        rowQueue.add(startY);
        columnQueue.add(startX);
        visited[startX][startY] = true;
        if (this.client.getCollisionMaps() == null) {
            return null;
        }
        CollisionData data = this.client.getCollisionMaps()[this.client.getPlane()];
        short[][] overlays = this.client.getScene().getOverlayIds()[this.client.getPlane()];
        while (!rowQueue.isEmpty() && !columnQueue.isEmpty()) {
            int row = (Integer)rowQueue.get(0);
            int column = (Integer)columnQueue.get(0);
            rowQueue.remove(0);
            columnQueue.remove(0);
            if (row == endY && column == endX) {
                reachedEnd = true;
                break;
            }
            this.exploreNeighbours(row, column, data, overlays, visited, columnQueue, rowQueue, path, movementType);
        }
        if (reachedEnd) {
            return this.reconstructPath(endX, endY, path);
        }
        return null;
    }

    private Coordinate[] reconstructPath(int endX, int endY, Coordinate[][] coordinates) {
        Coordinate endCoordinate;
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        Coordinate coordinate = endCoordinate = new Coordinate(endX, endY);
        while (coordinate != null) {
            list.add(coordinate);
            coordinate = coordinates[coordinate.getColumn()][coordinate.getRow()];
        }
        Object[] path = new Coordinate[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            path[i] = (Coordinate)list.get(i);
        }
        ArrayUtils.reverse((Object[])path);
        return path;
    }

    private void exploreNeighbours(int row, int column, CollisionData data, short[][] overlays, boolean[][] visited, ArrayList<Integer> columnQueue, ArrayList<Integer> rowQueue, Coordinate[][] path, MovementType movementType) {
        for (int i = 0; i < 8; ++i) {
            int testRow = row + this.directionRow[i];
            int testColumn = column + this.directionColumn[i];
            if (testRow > 104 || testRow < 0 || testColumn > 104 || testColumn < 0) continue;
            if (movementType != MovementType.GHOST) {
                int[] blocks;
                int setting = data.getFlags()[testColumn][testRow];
                int currentSetting = data.getFlags()[column][row];
                if ((setting & 0x240100) != 0 && (movementType != MovementType.WATERBORNE || overlays[testColumn][testRow] != 6 || (setting & 0x100) != 0) || movementType == MovementType.WATERBORNE && (setting & 0x240100) == 0 || (currentSetting & (blocks = this.directionBlocks[i])[0]) != 0) continue;
                if (i >= 4) {
                    int settingEW = data.getFlags()[testColumn][row];
                    int settingNS = data.getFlags()[column][testRow];
                    if ((settingEW & 0x240100) != 0 && (movementType != MovementType.WATERBORNE || overlays[testColumn][row] != 6 || (settingEW & 0x100) != 0) || (settingNS & 0x240100) != 0 && (movementType != MovementType.WATERBORNE || overlays[column][testRow] != 6 || (settingNS & 0x100) != 0) || movementType == MovementType.WATERBORNE && ((settingEW & 0x240100) == 0 || (settingNS & 0x240100) == 0) || (settingEW & blocks[1]) != 0 || (settingNS & blocks[2]) != 0 || (currentSetting & blocks[1]) != 0 || (currentSetting & blocks[2]) != 0) continue;
                }
            }
            if (visited[testColumn][testRow]) continue;
            columnQueue.add(testColumn);
            rowQueue.add(testRow);
            visited[testColumn][testRow] = true;
            path[testColumn][testRow] = new Coordinate(column, row);
        }
    }

    public void transplantSteps(Character character, int newX, int newY, boolean fromInstance, boolean toInstance) {
        if (toInstance) {
            this.transplantInstancedSteps(character, newX, newY, fromInstance);
            return;
        }
        this.transplantNonInstancedSteps(character, newX, newY, fromInstance);
    }

    public void transplantNonInstancedSteps(Character character, int newX, int newY, boolean fromInstance) {
        Program program = character.getProgram();
        ProgramComp comp = program.getComp();
        if (!fromInstance) {
            WorldPoint[] steps = comp.getStepsWP();
            if (steps.length == 0) {
                return;
            }
            int changeX = newX - steps[0].getX();
            int changeY = newY - steps[0].getY();
            WorldPoint[] newSteps = new WorldPoint[steps.length];
            for (int i = 0; i < steps.length; ++i) {
                WorldPoint point;
                WorldPoint wp = steps[i];
                newSteps[i] = point = new WorldPoint(wp.getX() + changeX, wp.getY() + changeY, this.client.getPlane());
            }
            comp.setStepsWP(newSteps);
            comp.setCurrentStep(0);
            return;
        }
        LocalPoint[] steps = comp.getStepsLP();
        if (steps.length == 0) {
            return;
        }
        WorldPoint[] newSteps = new WorldPoint[steps.length];
        newSteps[0] = new WorldPoint(newX, newY, this.client.getPlane());
        int[] changeXArray = new int[steps.length];
        int[] changeYArray = new int[steps.length];
        changeXArray[0] = 0;
        changeYArray[0] = 0;
        if (steps.length > 1) {
            int i;
            for (i = 1; i < steps.length; ++i) {
                changeXArray[i] = changeXArray[i - 1] + steps[i].getSceneX() - steps[i - 1].getSceneX();
                changeYArray[i] = changeYArray[i - 1] + steps[i].getSceneY() - steps[i - 1].getSceneY();
            }
            for (i = 1; i < steps.length; ++i) {
                WorldPoint point;
                newSteps[i] = point = new WorldPoint(newX + changeXArray[i], newY + changeYArray[i], this.client.getPlane());
            }
        }
        comp.setStepsWP(newSteps);
        comp.setCurrentStep(0);
    }

    public void transplantInstancedSteps(Character character, int newX, int newY, boolean fromInstance) {
        Program program = character.getProgram();
        ProgramComp comp = program.getComp();
        if (fromInstance) {
            LocalPoint[] steps = comp.getStepsLP();
            if (steps.length == 0) {
                return;
            }
            int changeX = newX - steps[0].getSceneX();
            int changeY = newY - steps[0].getSceneY();
            LocalPoint[] newSteps = new LocalPoint[steps.length];
            for (int i = 0; i < steps.length; ++i) {
                LocalPoint point;
                LocalPoint lp = steps[i];
                newSteps[i] = point = LocalPoint.fromScene((int)(lp.getSceneX() + changeX), (int)(lp.getSceneY() + changeY));
            }
            comp.setStepsLP(newSteps);
            comp.setCurrentStep(0);
            return;
        }
        WorldPoint[] steps = comp.getStepsWP();
        if (steps.length == 0) {
            return;
        }
        LocalPoint[] newSteps = new LocalPoint[steps.length];
        newSteps[0] = LocalPoint.fromScene((int)newX, (int)newY);
        int[] changeXArray = new int[steps.length];
        int[] changeYArray = new int[steps.length];
        changeXArray[0] = 0;
        changeYArray[0] = 0;
        if (steps.length > 1) {
            int i;
            for (i = 1; i < steps.length; ++i) {
                changeXArray[i] = changeXArray[i - 1] + steps[i].getX() - steps[i - 1].getX();
                changeYArray[i] = changeYArray[i - 1] + steps[i].getY() - steps[i - 1].getY();
            }
            for (i = 1; i < steps.length; ++i) {
                LocalPoint point;
                newSteps[i] = point = LocalPoint.fromScene((int)(newX + changeXArray[i]), (int)(newY + changeYArray[i]));
            }
        }
        comp.setStepsLP(newSteps);
        comp.setCurrentStep(0);
    }
}

