/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.models;

import com.creatorskit.CreatorsConfig;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.models.CustomModel;
import com.creatorskit.models.CustomModelComp;
import com.creatorskit.models.CustomModelType;
import com.creatorskit.models.LightingStyle;
import com.creatorskit.models.ModelFinder;
import com.creatorskit.models.ModelStats;
import com.creatorskit.swing.ModelOrganizer;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.util.Text;

public class ModelGetter {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CreatorsPlugin plugin;
    @Inject
    private ModelFinder modelFinder;
    @Inject
    private ModelOrganizer modelOrganizer;
    @Inject
    private CreatorsConfig config;

    public void storeNPC(int index, String target, NPC npc, String option, boolean setTransmog) {
        if (setTransmog && !this.config.transmogRightClick()) {
            return;
        }
        this.client.createMenuEntry(index).setOption(option).setTarget(target).setType(MenuAction.RUNELITE).onClick(e -> {
            Thread thread = new Thread(() -> {
                ModelStats[] modelStats = this.modelFinder.findModelsForNPC(npc.getId());
                this.clientThread.invokeLater(() -> {
                    Model model = this.plugin.constructModelFromCache(modelStats, new int[0], false, true);
                    CustomModelComp comp = new CustomModelComp(0, CustomModelType.CACHE_NPC, npc.getId(), modelStats, null, null, LightingStyle.ACTOR, false, npc.getName());
                    CustomModel customModel = new CustomModel(model, comp);
                    this.plugin.addCustomModel(customModel, false);
                    this.plugin.sendChatMessage("Model stored: " + npc.getName());
                    if (setTransmog) {
                        this.modelOrganizer.setTransmog(customModel);
                    }
                });
            });
            thread.start();
        });
    }

    public void sendToAnvilNPC(int index, String target, NPC npc) {
        this.client.createMenuEntry(index).setOption("Anvil").setTarget(target).setType(MenuAction.RUNELITE).onClick(e -> {
            Thread thread = new Thread(() -> {
                ModelStats[] modelStats = this.modelFinder.findModelsForNPC(npc.getId());
                this.clientThread.invokeLater(() -> {
                    this.plugin.cacheToAnvil(modelStats, new int[0], false);
                    this.plugin.sendChatMessage("Model sent to Anvil: " + npc.getName());
                });
            });
            thread.start();
        });
    }

    public void addPlayerGetter(int index, String target, String option, Player player, boolean sendToAnvil, boolean setTransmog) {
        if (setTransmog && !this.config.transmogRightClick()) {
            return;
        }
        this.client.createMenuEntry(index).setOption(option).setTarget(target).setType(MenuAction.RUNELITE).onClick(e -> {
            PlayerComposition comp = player.getPlayerComposition();
            int[] items = comp.getEquipmentIds();
            if (sendToAnvil) {
                Thread thread = new Thread(() -> {
                    ModelStats[] modelStats = this.modelFinder.findModelsForPlayer(false, comp.getGender() == 0, items);
                    this.clientThread.invokeLater(() -> {
                        this.plugin.cacheToAnvil(modelStats, comp.getColors(), true);
                        this.plugin.sendChatMessage("Model sent to Anvil: " + Text.removeTags((String)target));
                    });
                });
                thread.start();
                return;
            }
            Thread thread = new Thread(() -> {
                ModelStats[] modelStats = this.modelFinder.findModelsForPlayer(false, comp.getGender() == 0, items);
                this.clientThread.invokeLater(() -> {
                    Model model = this.plugin.constructModelFromCache(modelStats, comp.getColors(), true, true);
                    CustomModelComp composition = new CustomModelComp(0, CustomModelType.CACHE_PLAYER, -1, modelStats, comp.getColors(), null, LightingStyle.ACTOR, false, player.getName());
                    CustomModel customModel = new CustomModel(model, composition);
                    this.plugin.addCustomModel(customModel, false);
                    this.plugin.sendChatMessage("Model stored: " + Text.removeTags((String)target));
                    if (setTransmog) {
                        this.modelOrganizer.setTransmog(customModel);
                    }
                });
            });
            thread.start();
        });
    }

    public void addGameObjectGetter(int index, String option, String target, String name, Model model, int objectId, CustomModelType type, boolean setTransmog) {
        if (setTransmog && !this.config.transmogRightClick()) {
            return;
        }
        this.client.createMenuEntry(index).setOption(option).setTarget(target).setType(MenuAction.RUNELITE).onClick(e -> {
            Thread thread = new Thread(() -> {
                ModelStats[] modelStats = this.modelFinder.findModelsForObject(objectId);
                CustomModelComp comp = new CustomModelComp(0, type, objectId, modelStats, null, null, LightingStyle.DEFAULT, false, name);
                CustomModel customModel = new CustomModel(model, comp);
                this.plugin.addCustomModel(customModel, false);
                this.plugin.sendChatMessage("Model stored: " + name);
                if (setTransmog) {
                    this.modelOrganizer.setTransmog(customModel);
                }
            });
            thread.start();
        });
    }

    public void addObjectGetterToAnvil(String target, String name, int objectId) {
        this.client.createMenuEntry(-2).setOption("Anvil").setTarget(target).setType(MenuAction.RUNELITE).onClick(e -> {
            Thread thread = new Thread(() -> {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                ModelStats[] modelStats = this.modelFinder.findModelsForObject(objectId);
                this.clientThread.invokeLater(() -> {
                    this.plugin.cacheToAnvil(modelStats, new int[0], false);
                    this.plugin.sendChatMessage("Model sent to Anvil: " + name);
                });
            });
            thread.start();
        });
    }
}

