/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit.models;

import com.creatorskit.models.BodyPart;
import com.creatorskit.models.ModelStats;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelFinder {
    private static final Logger log = LoggerFactory.getLogger(ModelFinder.class);
    @Inject
    OkHttpClient httpClient;
    String lastFound;

    public ModelStats[] findModelsForPlayer(final boolean groundItem, final boolean maleItem, int[] items) {
        int[] ids = new int[items.length];
        ArrayList<Integer> itemList = new ArrayList<Integer>();
        ArrayList<Integer> kitList = new ArrayList<Integer>();
        for (int i = 0; i < ids.length; ++i) {
            int item = items[i];
            if (item >= 256 && item <= 512) {
                kitList.add(item - 256);
            }
            if (item <= 256) continue;
            itemList.add(item - 512);
        }
        final Pattern recolFrom = Pattern.compile("recol\\ds=.+");
        final Pattern recolTo = Pattern.compile("recol\\dd=.+");
        final ArrayList modelStatsArray = new ArrayList();
        final int[] itemId = new int[itemList.size()];
        for (int i = 0; i < itemList.size(); ++i) {
            itemId[i] = (Integer)itemList.get(i);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        Request itemRequest = new Request.Builder().url("https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.obj").build();
        Call itemCall = this.httpClient.newCall(itemRequest);
        itemCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to access URL: https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.obj");
                countDownLatch.countDown();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful() || response.body() == null) {
                    return;
                }
                ModelFinder.getPlayerItems(response, modelStatsArray, groundItem, maleItem, itemId, recolFrom, recolTo);
                countDownLatch.countDown();
                response.body().close();
            }
        });
        final int[] kitId = new int[kitList.size()];
        for (int i = 0; i < kitList.size(); ++i) {
            kitId[i] = (Integer)kitList.get(i);
        }
        Request kitRequest = new Request.Builder().url("https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.idk").build();
        Call kitCall = this.httpClient.newCall(kitRequest);
        kitCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to access URL: https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.idk");
                countDownLatch.countDown();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful() || response.body() == null) {
                    return;
                }
                ModelFinder.getPlayerKit(response, modelStatsArray, kitId, recolFrom, recolTo);
                countDownLatch.countDown();
                response.body().close();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            log.debug("CountDownLatch failed to wait at findModelsForPlayers");
        }
        return modelStatsArray.toArray(new ModelStats[0]);
    }

    public static void getPlayerItems(Response response, ArrayList<ModelStats> modelStatsArray, boolean groundItem, boolean maleItem, int[] itemId, Pattern recolFrom, Pattern recolTo) {
        InputStream inputStream = response.body().byteStream();
        Scanner scanner = new Scanner(inputStream);
        Pattern[] patterns = new Pattern[itemId.length];
        for (int i = 0; i < itemId.length; ++i) {
            Pattern itemPattern;
            int item = itemId[i];
            patterns[i] = itemPattern = Pattern.compile("\\[.+_" + item + "]");
        }
        block1: while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            for (int i = 0; i < patterns.length; ++i) {
                Pattern pattern = patterns[i];
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                int[] modelIds = new int[3];
                ArrayList<Integer> recolourFrom = new ArrayList<Integer>();
                ArrayList<Integer> recolourTo = new ArrayList<Integer>();
                while (!string.isEmpty()) {
                    String[] split;
                    string = scanner.nextLine();
                    if (groundItem && string.startsWith("model=")) {
                        split = string.split("_");
                        modelIds[0] = Integer.parseInt(split[split.length - 1]);
                    } else {
                        String[] split2;
                        String replaced;
                        if (maleItem && string.startsWith("manwear=")) {
                            replaced = string.replace(",", "_");
                            split2 = replaced.split("_");
                            modelIds[0] = Integer.parseInt(split2[split2.length - 2]);
                            continue;
                        }
                        if (maleItem && string.startsWith("manwear2=")) {
                            split = string.split("_");
                            modelIds[1] = Integer.parseInt(split[split.length - 1]);
                            continue;
                        }
                        if (maleItem && string.startsWith("manwear3=")) {
                            split = string.split("_");
                            modelIds[2] = Integer.parseInt(split[split.length - 1]);
                            continue;
                        }
                        if (!maleItem && string.startsWith("womanwear=")) {
                            replaced = string.replace(",", "_");
                            split2 = replaced.split("_");
                            modelIds[0] = Integer.parseInt(split2[split2.length - 2]);
                            continue;
                        }
                        if (!maleItem && string.startsWith("womanwear2=")) {
                            split = string.split("_");
                            modelIds[1] = Integer.parseInt(split[split.length - 1]);
                            continue;
                        }
                        if (!maleItem && string.startsWith("womanwear3=")) {
                            split = string.split("_");
                            modelIds[2] = Integer.parseInt(split[split.length - 1]);
                            continue;
                        }
                    }
                    matcher = recolFrom.matcher(string);
                    if (matcher.matches()) {
                        split = string.split("=");
                        recolourFrom.add(Integer.parseInt(split[1]));
                        continue;
                    }
                    matcher = recolTo.matcher(string);
                    if (!matcher.matches()) continue;
                    split = string.split("=");
                    recolourTo.add(Integer.parseInt(split[1]));
                }
                int size = recolourFrom.size();
                short[] recolourFromArray = new short[size];
                short[] recolourToArray = new short[size];
                for (int e = 0; e < size; ++e) {
                    int from = (Integer)recolourFrom.get(e);
                    if (from > Short.MAX_VALUE) {
                        from -= 65536;
                    }
                    recolourFromArray[e] = (short)from;
                    int to = (Integer)recolourTo.get(e);
                    if (to > Short.MAX_VALUE) {
                        to -= 65536;
                    }
                    recolourToArray[e] = (short)to;
                }
                for (int id : modelIds) {
                    if (id <= 0) continue;
                    modelStatsArray.add(new ModelStats(id, BodyPart.NA, recolourFromArray, recolourToArray));
                }
                if (i == patterns.length - 1) continue block1;
            }
        }
    }

    public static void getPlayerKit(Response response, ArrayList<ModelStats> modelStatsArray, int[] kitId, Pattern recolFrom, Pattern recolTo) {
        InputStream inputStream = response.body().byteStream();
        Scanner scanner = new Scanner(inputStream);
        Pattern[] patterns = new Pattern[kitId.length];
        for (int i = 0; i < kitId.length; ++i) {
            Pattern kitPattern;
            int item = kitId[i];
            patterns[i] = kitPattern = Pattern.compile("\\[.+_" + item + "]");
        }
        block1: while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            for (int i = 0; i < patterns.length; ++i) {
                Pattern pattern = patterns[i];
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                int[] modelIds = new int[2];
                ArrayList<Integer> recolourFrom = new ArrayList<Integer>();
                ArrayList<Integer> recolourTo = new ArrayList<Integer>();
                BodyPart bodyPart = BodyPart.NA;
                while (!string.isEmpty()) {
                    String[] split;
                    string = scanner.nextLine();
                    if (string.startsWith("model1=")) {
                        split = string.split("_");
                        modelIds[0] = Integer.parseInt(split[split.length - 1]);
                        continue;
                    }
                    if (string.startsWith("model2=")) {
                        split = string.split("_");
                        modelIds[1] = Integer.parseInt(split[split.length - 1]);
                        continue;
                    }
                    if (string.endsWith("hair")) {
                        bodyPart = BodyPart.HAIR;
                    }
                    if (string.endsWith("jaw")) {
                        bodyPart = BodyPart.JAW;
                    }
                    if (string.endsWith("torso")) {
                        bodyPart = BodyPart.TORSO;
                    }
                    if (string.endsWith("arms")) {
                        bodyPart = BodyPart.ARMS;
                    }
                    if (string.endsWith("hands")) {
                        bodyPart = BodyPart.HANDS;
                    }
                    if (string.endsWith("legs")) {
                        bodyPart = BodyPart.LEGS;
                    }
                    if (string.endsWith("feet")) {
                        bodyPart = BodyPart.FEET;
                    }
                    if ((matcher = recolFrom.matcher(string)).matches()) {
                        split = string.split("=");
                        recolourFrom.add(Integer.parseInt(split[1]));
                        continue;
                    }
                    matcher = recolTo.matcher(string);
                    if (!matcher.matches()) continue;
                    split = string.split("=");
                    recolourTo.add(Integer.parseInt(split[1]));
                }
                int size = recolourFrom.size();
                short[] recolourFromArray = new short[size];
                short[] recolourToArray = new short[size];
                for (int e = 0; e < size; ++e) {
                    int from = (Integer)recolourFrom.get(e);
                    if (from > Short.MAX_VALUE) {
                        from -= 65536;
                    }
                    recolourFromArray[e] = (short)from;
                    int to = (Integer)recolourTo.get(e);
                    if (to > Short.MAX_VALUE) {
                        to -= 65536;
                    }
                    recolourToArray[e] = (short)to;
                }
                for (int id : modelIds) {
                    if (id <= 0) continue;
                    modelStatsArray.add(new ModelStats(id, bodyPart, recolourFromArray, recolourToArray));
                }
                if (i == patterns.length - 1) continue block1;
            }
        }
    }

    public ModelStats[] findModelsForNPC(final int npcId) {
        final Pattern recolFrom = Pattern.compile("recol\\ds=.+");
        final Pattern recolTo = Pattern.compile("recol\\dd=.+");
        final ArrayList modelIds = new ArrayList();
        final ArrayList recolourFrom = new ArrayList();
        final ArrayList recolourTo = new ArrayList();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Request request = new Request.Builder().url("https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.npc").build();
        Call call = this.httpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to access URL: https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.npc");
                countDownLatch.countDown();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful() || response.body() == null) {
                    return;
                }
                InputStream inputStream = response.body().byteStream();
                Scanner scanner = new Scanner(inputStream);
                Pattern npcPattern = Pattern.compile("\\[.+_" + npcId + "]");
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    Matcher match = npcPattern.matcher(string);
                    if (!match.matches()) continue;
                    ModelFinder.this.lastFound = string;
                    while (!string.isEmpty()) {
                        int i;
                        String[] split;
                        string = scanner.nextLine();
                        if (string.startsWith("model")) {
                            split = string.split("_");
                            modelIds.add(Integer.parseInt(split[split.length - 1]));
                        }
                        if (string.startsWith("name=")) {
                            ModelFinder.this.lastFound = string.replaceAll("name=", "");
                        }
                        if ((match = recolFrom.matcher(string)).matches()) {
                            split = string.split("=");
                            i = Integer.parseInt(split[1]);
                            if (i > Short.MAX_VALUE) {
                                i -= 65536;
                            }
                            recolourFrom.add((short)i);
                        }
                        if (!(match = recolTo.matcher(string)).matches()) continue;
                        split = string.split("=");
                        i = Integer.parseInt(split[1]);
                        if (i > Short.MAX_VALUE) {
                            i -= 65536;
                        }
                        recolourTo.add((short)i);
                    }
                }
                countDownLatch.countDown();
                response.body().close();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            log.debug("CountDownLatch failed to await at findModelsForNPCs");
        }
        short[] rf = new short[recolourFrom.size()];
        short[] rt = new short[recolourTo.size()];
        for (int i = 0; i < recolourFrom.size(); ++i) {
            rf[i] = (Short)recolourFrom.get(i);
            rt[i] = (Short)recolourTo.get(i);
        }
        ModelStats[] modelStats = new ModelStats[modelIds.size()];
        for (int i = 0; i < modelIds.size(); ++i) {
            modelStats[i] = new ModelStats((Integer)modelIds.get(i), BodyPart.NA, rf, rt);
        }
        return modelStats;
    }

    public ModelStats[] findModelsForObject(final int objectId) {
        final Pattern recolFrom = Pattern.compile("recol\\ds=.+");
        final Pattern recolTo = Pattern.compile("recol\\dd=.+");
        final ArrayList modelIds = new ArrayList();
        final ArrayList recolourFrom = new ArrayList();
        final ArrayList recolourTo = new ArrayList();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Request request = new Request.Builder().url("https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.loc").build();
        Call call = this.httpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Failed to access URL: https://gitlab.com/waliedyassen/cache-dumps/-/raw/master/dump.loc");
                countDownLatch.countDown();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful() || response.body() == null) {
                    return;
                }
                InputStream inputStream = response.body().byteStream();
                Scanner scanner = new Scanner(inputStream);
                Pattern npcPattern = Pattern.compile("\\[.+_" + objectId + "]");
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    Matcher match = npcPattern.matcher(string);
                    if (!match.matches()) continue;
                    ModelFinder.this.lastFound = string;
                    while (!string.isEmpty()) {
                        String[] split;
                        string = scanner.nextLine();
                        if (string.startsWith("model")) {
                            split = string.split("_");
                            if (split[split.length - 1].contains(",")) {
                                String split2 = split[split.length - 1].split(",")[0];
                                modelIds.add(Integer.parseInt(split2));
                            } else {
                                modelIds.add(Integer.parseInt(split[split.length - 1]));
                            }
                        }
                        if (string.startsWith("name=")) {
                            ModelFinder.this.lastFound = string.replaceAll("name=", "");
                        }
                        if ((match = recolFrom.matcher(string)).matches()) {
                            split = string.split("=");
                            int i = Integer.parseInt(split[1]);
                            if (i > Short.MAX_VALUE) {
                                i -= 65536;
                            }
                            recolourFrom.add((short)i);
                        }
                        if (!(match = recolTo.matcher(string)).matches()) continue;
                        split = string.split("=");
                        int i = Integer.parseInt(split[1]);
                        if (i > Short.MAX_VALUE) {
                            i -= 65536;
                        }
                        recolourTo.add((short)i);
                    }
                }
                countDownLatch.countDown();
                response.body().close();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            log.debug("CountDownLatch failed to await at findModelsForObject");
        }
        short[] rf = new short[recolourFrom.size()];
        short[] rt = new short[recolourTo.size()];
        for (int i = 0; i < recolourFrom.size(); ++i) {
            rf[i] = (Short)recolourFrom.get(i);
            rt[i] = (Short)recolourTo.get(i);
        }
        ModelStats[] modelStats = new ModelStats[modelIds.size()];
        for (int i = 0; i < modelIds.size(); ++i) {
            modelStats[i] = new ModelStats((Integer)modelIds.get(i), BodyPart.NA, rf, rt);
        }
        return modelStats;
    }

    public static String shortArrayToString(short[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            short s = array[i];
            stringBuilder.append(s);
            if (i >= array.length - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String getLastFound() {
        return this.lastFound;
    }
}

