/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit;

import com.creatorskit.AutoRotate;
import com.creatorskit.Character;
import com.creatorskit.CreatorsConfig;
import com.creatorskit.CreatorsOverlay;
import com.creatorskit.models.BodyPart;
import com.creatorskit.models.CustomModel;
import com.creatorskit.models.CustomModelComp;
import com.creatorskit.models.CustomModelType;
import com.creatorskit.models.DetailedModel;
import com.creatorskit.models.KitRecolourer;
import com.creatorskit.models.LightingStyle;
import com.creatorskit.models.ModelFinder;
import com.creatorskit.models.ModelGetter;
import com.creatorskit.models.ModelStats;
import com.creatorskit.programming.Coordinate;
import com.creatorskit.programming.Direction;
import com.creatorskit.programming.Orientation;
import com.creatorskit.programming.PathFinder;
import com.creatorskit.programming.Program;
import com.creatorskit.programming.ProgramComp;
import com.creatorskit.swing.ComplexPanel;
import com.creatorskit.swing.CreatorsPanel;
import com.creatorskit.swing.ModelAnvil;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.MenuAction;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Creator's Kit", description="A suite of tools for creators", tags={"tool", "creator", "content", "kit", "camera", "immersion"})
public class CreatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CreatorsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CreatorsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CreatorsOverlay overlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ModelGetter modelGetter;
    @Inject
    private PathFinder pathFinder;
    @Inject
    public Gson gson;
    @Inject
    private ModelFinder modelFinder;
    private CreatorsPanel creatorsPanel;
    private NavigationButton navigationButton;
    private boolean overlaysActive = false;
    private final ArrayList<Character> characters = new ArrayList();
    private final ArrayList<CustomModel> storedModels = new ArrayList();
    private Character selectedCharacter;
    private Character hoveredCharacter;
    private RuneLiteObject transmog;
    private CustomModel transmogModel;
    private int savedRegion = -1;
    private int savedPlane = -1;
    private AutoRotate autoRotateYaw = AutoRotate.OFF;
    private AutoRotate autoRotatePitch = AutoRotate.OFF;
    private final int BRIGHT_AMBIENT = 64;
    private final int BRIGHT_CONTRAST = 850;
    private final int DARK_AMBIENT = 128;
    private final int DARK_CONTRAST = 4000;
    private boolean pauseMode = true;
    private boolean autoSetupPathFound = true;
    private int[] poseAnimations = new int[]{244, 808, 809, 813, 847, 1421, 1461, 1652, 1662, 1713, 1824, 1832, 1837, 2061, 2065, 2074, 2148, 2316, 2561, 2911, 3040, 3175, 3296, 3677, 4193, 4646, 5160, 5246, 5253, 5363, 5869, 6297, 6604, 6657, 6936, 7053, 7220, 7271, 7508, 7518, 7538, 8009, 8057, 8208, 8521, 9018, 9341, 9460, 9494, 9814, 9857, 10032};
    private final HotkeyListener overlayKeyListener = new HotkeyListener(() -> this.config.toggleOverlaysHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.overlaysActive = !CreatorsPlugin.this.overlaysActive;
        }
    };
    private final HotkeyListener oculusOrbListener = new HotkeyListener(() -> this.config.toggleOrbHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.client.getOculusOrbState() == 1) {
                CreatorsPlugin.this.client.setOculusOrbState(0);
                CreatorsPlugin.this.client.setOculusOrbNormalSpeed(12);
                return;
            }
            CreatorsPlugin.this.client.setOculusOrbState(1);
            CreatorsPlugin.this.client.setOculusOrbNormalSpeed(CreatorsPlugin.this.config.orbSpeed());
        }
    };
    private final HotkeyListener quickSpawnListener = new HotkeyListener(() -> this.config.quickSpawnHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                CreatorsPlugin.this.toggleSpawn(CreatorsPlugin.this.selectedCharacter.getSpawnButton(), CreatorsPlugin.this.selectedCharacter);
            }
        }
    };
    private final HotkeyListener quickLocationListener = new HotkeyListener(() -> this.config.quickLocationHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, true, false, true, false);
            }
        }
    };
    private final HotkeyListener quickRotateCWListener = new HotkeyListener(() -> this.config.quickRotateCWHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                CreatorsPlugin.this.addOrientation(CreatorsPlugin.this.selectedCharacter, -512);
            }
        }
    };
    private final HotkeyListener quickRotateCCWListener = new HotkeyListener(() -> this.config.quickRotateCCWHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                CreatorsPlugin.this.addOrientation(CreatorsPlugin.this.selectedCharacter, 512);
            }
        }
    };
    private final HotkeyListener autoLeftListener = new HotkeyListener(() -> this.config.rotateLeftHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.autoRotateYaw = CreatorsPlugin.this.autoRotateYaw == AutoRotate.OFF ? AutoRotate.LEFT : AutoRotate.OFF;
        }
    };
    private final HotkeyListener autoRightListener = new HotkeyListener(() -> this.config.rotateRightHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.autoRotateYaw = CreatorsPlugin.this.autoRotateYaw == AutoRotate.OFF ? AutoRotate.RIGHT : AutoRotate.OFF;
        }
    };
    private final HotkeyListener autoUpListener = new HotkeyListener(() -> this.config.rotateUpHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.autoRotatePitch = CreatorsPlugin.this.autoRotatePitch == AutoRotate.OFF ? AutoRotate.UP : AutoRotate.OFF;
        }
    };
    private final HotkeyListener autoDownListener = new HotkeyListener(() -> this.config.rotateDownHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.autoRotatePitch = CreatorsPlugin.this.autoRotatePitch == AutoRotate.OFF ? AutoRotate.DOWN : AutoRotate.OFF;
        }
    };
    private final HotkeyListener addProgramStepListener = new HotkeyListener(() -> this.config.addProgramStepHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                Tile tile = CreatorsPlugin.this.client.getSelectedSceneTile();
                if (tile == null) {
                    return;
                }
                Program program = CreatorsPlugin.this.selectedCharacter.getProgram();
                boolean isInScene = CreatorsPlugin.this.isInScene(CreatorsPlugin.this.selectedCharacter);
                if (isInScene && CreatorsPlugin.this.client.isInInstancedRegion()) {
                    Object[] steps = program.getComp().getStepsLP();
                    if (steps.length == 0) {
                        CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, true, false, true, false);
                    }
                    steps = (LocalPoint[])ArrayUtils.add((Object[])steps, (Object)tile.getLocalLocation());
                    program.getComp().setStepsLP((LocalPoint[])steps);
                    CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                    return;
                }
                if (!isInScene && CreatorsPlugin.this.client.isInInstancedRegion()) {
                    program.getComp().setStepsLP(new LocalPoint[]{tile.getLocalLocation()});
                    program.getComp().setStepsWP(new WorldPoint[0]);
                    CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, true, false, true, false);
                    CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                    return;
                }
                if (isInScene && !CreatorsPlugin.this.client.isInInstancedRegion()) {
                    Object[] steps = program.getComp().getStepsWP();
                    if (steps.length == 0) {
                        CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, true, false, true, false);
                    }
                    WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)CreatorsPlugin.this.client, (LocalPoint)tile.getLocalLocation());
                    steps = (WorldPoint[])ArrayUtils.add((Object[])steps, (Object)worldPoint);
                    program.getComp().setStepsWP((WorldPoint[])steps);
                    CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                    return;
                }
                if (!isInScene && !CreatorsPlugin.this.client.isInInstancedRegion()) {
                    WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)CreatorsPlugin.this.client, (LocalPoint)tile.getLocalLocation());
                    program.getComp().setStepsWP(new WorldPoint[]{worldPoint});
                    program.getComp().setStepsLP(new LocalPoint[0]);
                    CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, true, false, true, false);
                    CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                }
            }
        }
    };
    private final HotkeyListener removeProgramStepListener = new HotkeyListener(() -> this.config.removeProgramStepHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                if (!CreatorsPlugin.this.isInScene(CreatorsPlugin.this.selectedCharacter)) {
                    return;
                }
                Tile tile = CreatorsPlugin.this.client.getSelectedSceneTile();
                if (tile == null) {
                    return;
                }
                Program program = CreatorsPlugin.this.selectedCharacter.getProgram();
                ProgramComp comp = program.getComp();
                if (CreatorsPlugin.this.client.isInInstancedRegion()) {
                    Object[] steps = comp.getStepsLP();
                    steps = (LocalPoint[])ArrayUtils.removeElement((Object[])steps, (Object)tile.getLocalLocation());
                    comp.setStepsLP((LocalPoint[])steps);
                } else {
                    WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)CreatorsPlugin.this.client, (LocalPoint)tile.getLocalLocation());
                    Object[] steps = comp.getStepsWP();
                    steps = (WorldPoint[])ArrayUtils.removeElement((Object[])steps, (Object)worldPoint);
                    comp.setStepsWP((WorldPoint[])steps);
                }
                comp.setCurrentStep(0);
                CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, false, false, false, true);
            }
        }
    };
    private final HotkeyListener clearProgramStepListener = new HotkeyListener(() -> this.config.clearProgramStepHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                Program program = CreatorsPlugin.this.selectedCharacter.getProgram();
                program.getComp().setStepsWP(new WorldPoint[0]);
                program.getComp().setStepsLP(new LocalPoint[0]);
                program.getComp().setProgramActive(false);
                CreatorsPlugin.this.updateProgramPath(program, false, CreatorsPlugin.this.selectedCharacter.isInInstance());
                CreatorsPlugin.this.setLocation(CreatorsPlugin.this.selectedCharacter, false, false, false, false);
            }
        }
    };
    private final HotkeyListener playPauseListener = new HotkeyListener(() -> this.config.playPauseHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                ProgramComp comp;
                comp.setProgramActive(!(comp = CreatorsPlugin.this.selectedCharacter.getProgram().getComp()).isProgramActive());
            }
        }
    };
    private final HotkeyListener playPauseAllListener = new HotkeyListener(() -> this.config.playPauseAllHotkey()){

        public void hotkeyPressed() {
            CreatorsPlugin.this.pauseMode = !CreatorsPlugin.this.pauseMode;
            for (Character character : CreatorsPlugin.this.characters) {
                character.getProgram().getComp().setProgramActive(!CreatorsPlugin.this.pauseMode);
            }
        }
    };
    private final HotkeyListener resetListener = new HotkeyListener(() -> this.config.resetHotkey()){

        public void hotkeyPressed() {
            if (CreatorsPlugin.this.selectedCharacter != null) {
                CreatorsPlugin.this.resetProgram(CreatorsPlugin.this.selectedCharacter, false);
            }
        }
    };
    private final HotkeyListener resetAllListener = new HotkeyListener(() -> this.config.resetAllHotkey()){

        public void hotkeyPressed() {
            for (Character character : CreatorsPlugin.this.characters) {
                CreatorsPlugin.this.resetProgram(character, false);
            }
        }
    };

    protected void startUp() throws Exception {
        this.creatorsPanel = (CreatorsPanel)((Object)this.injector.getInstance(CreatorsPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/panelicon.png");
        this.navigationButton = NavigationButton.builder().tooltip("Creator's Kit").icon(icon).priority(10).panel((PluginPanel)this.creatorsPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.overlayManager.add((Overlay)this.overlay);
        this.keyManager.registerKeyListener((KeyListener)this.overlayKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.oculusOrbListener);
        this.keyManager.registerKeyListener((KeyListener)this.quickSpawnListener);
        this.keyManager.registerKeyListener((KeyListener)this.quickLocationListener);
        this.keyManager.registerKeyListener((KeyListener)this.quickRotateCWListener);
        this.keyManager.registerKeyListener((KeyListener)this.quickRotateCCWListener);
        this.keyManager.registerKeyListener((KeyListener)this.autoLeftListener);
        this.keyManager.registerKeyListener((KeyListener)this.autoRightListener);
        this.keyManager.registerKeyListener((KeyListener)this.autoUpListener);
        this.keyManager.registerKeyListener((KeyListener)this.autoDownListener);
        this.keyManager.registerKeyListener((KeyListener)this.addProgramStepListener);
        this.keyManager.registerKeyListener((KeyListener)this.removeProgramStepListener);
        this.keyManager.registerKeyListener((KeyListener)this.clearProgramStepListener);
        this.keyManager.registerKeyListener((KeyListener)this.resetListener);
        this.keyManager.registerKeyListener((KeyListener)this.playPauseListener);
        this.keyManager.registerKeyListener((KeyListener)this.playPauseAllListener);
        this.keyManager.registerKeyListener((KeyListener)this.resetAllListener);
        File SETUP_DIR = new File(this.config.setupPath() + ".json");
        if (this.config.autoSetup()) {
            if (SETUP_DIR.exists()) {
                this.creatorsPanel.loadSetup(SETUP_DIR);
            } else {
                this.autoSetupPathFound = false;
            }
        }
    }

    protected void shutDown() throws Exception {
        this.creatorsPanel.clearPanels();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.overlayKeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.oculusOrbListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.quickSpawnListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.quickLocationListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.quickRotateCWListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.quickRotateCCWListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.autoLeftListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.autoRightListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.autoUpListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.autoDownListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.addProgramStepListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.removeProgramStepListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.clearProgramStepListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.resetListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.playPauseListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.playPauseAllListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.resetAllListener);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int plane;
        int region;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (!this.autoSetupPathFound) {
            this.autoSetupPathFound = true;
            this.sendChatMessage("Creator's Kit auto-setup has failed to find the file at the path: " + this.config.setupPath());
            this.sendChatMessage("Please ensure the config menu has the appropriate file path.");
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        WorldPoint worldPoint = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
        int n = region = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint).getRegionID() : worldPoint.getRegionID();
        if (this.savedRegion != region) {
            this.savedRegion = region;
        }
        if (this.savedPlane != (plane = this.client.getPlane())) {
            this.savedPlane = plane;
            for (Character character : this.characters) {
                this.setLocation(character, false, false, false, true);
                this.resetProgram(character, character.getProgram().getComp().isProgramActive());
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        switch (this.autoRotateYaw) {
            case LEFT: {
                this.client.setCameraYawTarget(this.client.getCameraYaw() - this.config.rotateHorizontalSpeed());
                break;
            }
            case RIGHT: {
                this.client.setCameraYawTarget(this.client.getCameraYaw() + this.config.rotateHorizontalSpeed());
            }
        }
        switch (this.autoRotatePitch) {
            case UP: {
                this.client.setCameraPitchTarget(this.client.getCameraPitch() + this.config.rotateVerticalSpeed());
                break;
            }
            case DOWN: {
                this.client.setCameraPitchTarget(this.client.getCameraPitch() - this.config.rotateVerticalSpeed());
            }
        }
        for (Character character : this.characters) {
            int change;
            int pathLength;
            Program program = character.getProgram();
            ProgramComp comp = program.getComp();
            RuneLiteObject runeLiteObject = character.getRuneLiteObject();
            boolean instance = this.client.isInInstancedRegion();
            if (!this.isInScene(character)) continue;
            if (!comp.isProgramActive()) {
                Animation animation = runeLiteObject.getAnimation();
                if (animation == null || animation.getId() == comp.getIdleAnim()) continue;
                runeLiteObject.setAnimation(this.client.loadAnimation(comp.getIdleAnim()));
                continue;
            }
            double speed = 128.0 * (comp.getSpeed() * 20.0 / 600.0);
            int currentStep = comp.getCurrentStep();
            int n2 = pathLength = instance ? comp.getPathLP().length : comp.getPathWP().length;
            if (currentStep >= pathLength) {
                if (comp.isLoop()) {
                    this.resetProgram(character, true);
                    continue;
                }
                if (runeLiteObject.getAnimation() == null || runeLiteObject.getAnimation().getId() == comp.getIdleAnim()) continue;
                runeLiteObject.setAnimation(this.client.loadAnimation(comp.getIdleAnim()));
                continue;
            }
            Animation currentAnim = runeLiteObject.getAnimation();
            if (currentAnim != null && currentAnim.getId() != comp.getWalkAnim()) {
                int walkAnimId = comp.getWalkAnim();
                if (walkAnimId == -1) {
                    walkAnimId = comp.getIdleAnim();
                }
                if (currentAnim.getId() != walkAnimId) {
                    runeLiteObject.setAnimation(this.client.loadAnimation(comp.getWalkAnim()));
                }
            }
            LocalPoint start = runeLiteObject.getLocation();
            LocalPoint destination = instance ? comp.getPathLP()[currentStep] : LocalPoint.fromWorld((Client)this.client, (WorldPoint)comp.getPathWP()[currentStep]);
            if (destination == null) continue;
            int startX = start.getX();
            int startY = start.getY();
            int destX = destination.getX();
            int destY = destination.getY();
            int endX = startX;
            int endY = startY;
            double changeX = destX - startX;
            double changeY = destY - startY;
            double angle = Orientation.radiansToJAngle(Math.atan(changeY / changeX), changeX, changeY);
            character.setTargetOrientation((int)angle);
            if (destX != startX) {
                change = (int)speed * Orientation.orientationX(angle);
                endX = startX + change;
            }
            if (destY != startY) {
                change = (int)speed * Orientation.orientationY(angle);
                endY = startY + change;
            }
            if (endX == destX && endY == destY) {
                int nextStep = currentStep + 1;
                comp.setCurrentStep(nextStep);
                if (nextStep < pathLength) {
                    LocalPoint nextPath = instance ? comp.getPathLP()[currentStep] : LocalPoint.fromWorld((Client)this.client, (WorldPoint)comp.getPathWP()[currentStep]);
                    if (nextPath == null) continue;
                    int nextX = nextPath.getSceneX();
                    int nextY = nextPath.getSceneY();
                    double nextChangeX = nextX - start.getSceneX();
                    double nextChangeY = nextY - start.getSceneY();
                    double nextAngle = Orientation.radiansToJAngle(Math.atan(nextChangeY / nextChangeX), nextChangeX, nextChangeY);
                    character.setTargetOrientation((int)nextAngle);
                }
            }
            int orientation = runeLiteObject.getOrientation();
            int targetOrientation = character.getTargetOrientation();
            int turnSpeed = comp.getTurnSpeed();
            if (orientation != targetOrientation) {
                int difference = Orientation.subtract(targetOrientation, orientation);
                int newOrientation = difference > turnSpeed * -1 && difference < turnSpeed ? targetOrientation : (difference > 0 ? Orientation.boundOrientation(orientation + turnSpeed) : Orientation.boundOrientation(orientation - turnSpeed));
                runeLiteObject.setOrientation(newOrientation);
            }
            LocalPoint finalPoint = new LocalPoint(endX, endY);
            runeLiteObject.setLocation(finalPoint, this.client.getPlane());
        }
        if (this.config.enableTransmog() && this.transmog != null) {
            Player player = this.client.getLocalPlayer();
            if (player == null) {
                return;
            }
            LocalPoint localPoint = player.getLocalLocation();
            this.transmog.setLocation(localPoint, this.client.getPlane());
            this.transmog.setOrientation(player.getCurrentOrientation());
            if (!this.transmog.isActive()) {
                this.transmog.setActive(true);
            }
            int playerAnimation = player.getAnimation();
            int playerPose = player.getPoseAnimation();
            Animation animation = this.transmog.getAnimation();
            int transmogAnimation = -1;
            if (animation != null) {
                transmogAnimation = animation.getId();
            }
            if (this.config.transmogAnimations() == CreatorsConfig.TransmogAnimation.PLAYER) {
                if (playerAnimation == -1) {
                    if (transmogAnimation != playerPose) {
                        this.transmog.setAnimation(this.client.loadAnimation(playerPose));
                    }
                } else if (transmogAnimation != playerAnimation) {
                    this.transmog.setAnimation(this.client.loadAnimation(playerAnimation));
                }
            }
            if (this.config.transmogAnimations() == CreatorsConfig.TransmogAnimation.CONFIG) {
                if (playerAnimation == -1) {
                    if (Arrays.stream(this.poseAnimations).anyMatch(n -> playerPose == n)) {
                        if (transmogAnimation != this.config.transmogPose()) {
                            this.transmog.setAnimation(this.client.loadAnimation(this.config.transmogPose()));
                        }
                    } else if (transmogAnimation != this.config.transmogWalk()) {
                        this.transmog.setAnimation(this.client.loadAnimation(this.config.transmogWalk()));
                    }
                } else if (transmogAnimation != this.config.transmogAction()) {
                    this.transmog.setAnimation(this.client.loadAnimation(this.config.transmogAction()));
                }
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            boolean instance = this.client.isInInstancedRegion();
            for (Character character : this.characters) {
                this.setLocation(character, false, false, false, true);
                this.resetProgram(character, character.getProgram().getComp().isProgramActive());
                if ((!character.isInInstance() || !instance || this.client.getPlane() != character.getInstancedPlane()) && (character.isInInstance() || instance)) continue;
                this.updateProgramPath(character.getProgram(), true, character.isInInstance());
            }
            if (this.config.enableTransmog() && this.transmog != null) {
                this.transmog.setActive(false);
                this.transmog.setActive(true);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("orbSpeed")) {
            this.client.setOculusOrbNormalSpeed(this.config.orbSpeed());
        }
        if (event.getKey().equals("enableTransmog")) {
            if (this.transmog == null) {
                return;
            }
            this.clientThread.invokeLater(() -> {
                boolean enableTransmog = this.config.enableTransmog();
                this.transmog.setActive(enableTransmog);
                if (!enableTransmog) {
                    this.transmog.setAnimation(this.client.loadAnimation(-1));
                }
            });
        }
        if (event.getKey().equals("transmogAnimation")) {
            if (this.transmog == null || !this.config.enableTransmog()) {
                return;
            }
            if (this.config.transmogAnimations() != CreatorsConfig.TransmogAnimation.NONE) {
                return;
            }
            this.clientThread.invokeLater(() -> this.transmog.setAnimation(this.client.loadAnimation(-1)));
        }
        if (event.getKey().equals("transmogRadius")) {
            if (this.transmog == null) {
                return;
            }
            this.clientThread.invokeLater(() -> this.transmog.setRadius(this.config.transmogRadius()));
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Player localPlayer;
        Player player;
        if (!this.config.rightClick()) {
            return;
        }
        String target = event.getTarget();
        String option = event.getOption();
        Tile tile = this.client.getSelectedSceneTile();
        NPC npc = event.getMenuEntry().getNpc();
        if (npc != null && option.equals("Examine")) {
            this.modelGetter.storeNPC(-1, target, npc, "Store", false);
            this.modelGetter.sendToAnvilNPC(-2, target, npc);
            this.modelGetter.storeNPC(-3, target, npc, "Transmog", true);
        }
        if (tile != null && option.equals("Walk here")) {
            List tileItems;
            Renderable renderable;
            WallObject wallObject;
            Renderable renderable2;
            DecorativeObject decorativeObject;
            Renderable renderable3;
            GroundObject groundObject = tile.getGroundObject();
            if (groundObject != null && (renderable3 = groundObject.getRenderable()) instanceof Model) {
                Model model = (Model)groundObject.getRenderable();
                this.modelGetter.addGameObjectGetter(-1, "Store", "<col=FFFF>GroundObject", "GroundObject", model, groundObject.getId(), CustomModelType.CACHE_OBJECT, false);
                this.modelGetter.addObjectGetterToAnvil("<col=FFFF>GroundObject", "GroundObject", groundObject.getId());
                this.modelGetter.addGameObjectGetter(-3, "Transmog", "<col=FFFF>GroundObject", "GroundObject", model, groundObject.getId(), CustomModelType.CACHE_OBJECT, true);
            }
            if ((decorativeObject = tile.getDecorativeObject()) != null && (renderable2 = decorativeObject.getRenderable()) instanceof Model) {
                Model model = (Model)decorativeObject.getRenderable();
                this.modelGetter.addGameObjectGetter(-1, "Store", "<col=FFFF>DecorativeObject", "DecorativeObject", model, decorativeObject.getId(), CustomModelType.CACHE_OBJECT, false);
                this.modelGetter.addObjectGetterToAnvil("<col=FFFF>DecorativeObject", "DecorativeObject", decorativeObject.getId());
                this.modelGetter.addGameObjectGetter(-3, "Transmog", "<col=FFFF>DecorativeObject", "DecorativeObject", model, decorativeObject.getId(), CustomModelType.CACHE_OBJECT, true);
            }
            if ((wallObject = tile.getWallObject()) != null && (renderable = wallObject.getRenderable1()) instanceof Model) {
                Model model = (Model)renderable;
                this.modelGetter.addGameObjectGetter(-1, "Store", "<col=FFFF>WallObject", "WallObject", model, wallObject.getId(), CustomModelType.CACHE_OBJECT, false);
                this.modelGetter.addObjectGetterToAnvil("<col=FFFF>WallObject", "WallObject", wallObject.getId());
                this.modelGetter.addGameObjectGetter(-3, "Transmog", "<col=FFFF>WallObject", "WallObject", model, wallObject.getId(), CustomModelType.CACHE_OBJECT, true);
            }
            if ((tileItems = tile.getGroundItems()) != null) {
                for (TileItem tileItem : tileItems) {
                    Model model = tileItem.getModel();
                    this.modelGetter.addGameObjectGetter(-1, "Store", "<col=FFFF>Item", "Item", model, tileItem.getId(), CustomModelType.CACHE_GROUND_ITEM, false);
                    this.modelGetter.addObjectGetterToAnvil("<col=FFFF>Item", "Item", tileItem.getId());
                    this.modelGetter.addGameObjectGetter(-3, "Transmog", "<col=FFFF>Item", "Item", model, tileItem.getId(), CustomModelType.CACHE_GROUND_ITEM, true);
                }
            }
            GameObject[] gameObjects = tile.getGameObjects();
            for (GameObject gameObject : gameObjects) {
                Renderable renderable4;
                if (gameObject == null || (renderable4 = gameObject.getRenderable()) == null || !(renderable4 instanceof Model)) continue;
                Model model = (Model)renderable4;
                this.modelGetter.addGameObjectGetter(-1, "Store", "<col=FFFF>GameObject", "GameObject", model, gameObject.getId(), CustomModelType.CACHE_OBJECT, false);
                this.modelGetter.addObjectGetterToAnvil("<col=FFFF>GameObject", "GameObject", gameObject.getId());
                this.modelGetter.addGameObjectGetter(-3, "Transmog", "<col=FFFF>GameObject", "GameObject", model, gameObject.getId(), CustomModelType.CACHE_OBJECT, true);
            }
            for (Character character : this.characters) {
                if (!character.isActive() || !character.getRuneLiteObject().getLocation().equals((Object)tile.getLocalLocation())) continue;
                this.client.createMenuEntry(-1).setOption("Select").setTarget(ColorUtil.colorTag((Color)Color.GREEN) + character.getName()).setType(MenuAction.RUNELITE).onClick(e -> this.creatorsPanel.setSelectedCharacter(character, character.getMasterPanel()));
            }
        }
        if ((player = event.getMenuEntry().getPlayer()) != null && option.equals("Trade with")) {
            this.modelGetter.addPlayerGetter(-1, target, "Store", player, false, false);
            this.modelGetter.addPlayerGetter(-2, target, "Anvil", player, true, false);
            this.modelGetter.addPlayerGetter(-3, target, "Transmog", player, false, true);
        }
        if ((localPlayer = this.client.getLocalPlayer()) != null && tile != null && option.equals("Walk here") && tile.getLocalLocation().equals((Object)localPlayer.getLocalLocation())) {
            this.modelGetter.addPlayerGetter(-1, localPlayer.getName(), "Store", localPlayer, false, false);
            this.modelGetter.addPlayerGetter(-2, localPlayer.getName(), "Anvil", localPlayer, true, false);
        }
    }

    public void setLocation(Character character, boolean newLocation, boolean setToPlayer, boolean setToHoveredTile, boolean setToPathStart) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean instance = this.client.isInInstancedRegion();
        if (!newLocation && !this.isInScene(character)) {
            return;
        }
        if (instance) {
            this.setLocationInstance(character, setToPlayer, setToHoveredTile, setToPathStart);
            return;
        }
        this.setLocationNonInstance(character, setToPlayer, setToHoveredTile, setToPathStart);
    }

    public void setLocationNonInstance(Character character, boolean setToPlayer, boolean setToHoveredTile, boolean setToPathStart) {
        this.clientThread.invoke(() -> {
            LocalPoint localPoint;
            WorldPoint[] steps = character.getProgram().getComp().getStepsWP();
            if (setToPlayer) {
                localPoint = this.client.getLocalPlayer().getLocalLocation();
            } else if (setToHoveredTile) {
                Tile tile = this.client.getSelectedSceneTile();
                if (tile == null) {
                    return;
                }
                localPoint = tile.getLocalLocation();
            } else {
                localPoint = setToPathStart && steps.length > 0 ? LocalPoint.fromWorld((Client)this.client, (WorldPoint)steps[0]) : (character.getNonInstancedPoint() == null ? this.client.getLocalPlayer().getLocalLocation() : LocalPoint.fromWorld((Client)this.client, (WorldPoint)character.getNonInstancedPoint()));
            }
            if (localPoint == null) {
                return;
            }
            WorldPoint newLocation = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
            character.setLocationSet(true);
            if (newLocation != null) {
                this.pathFinder.transplantSteps(character, newLocation.getX(), newLocation.getY(), character.isInInstance(), false);
                character.setInInstance(false);
                character.setNonInstancedPoint(newLocation);
                this.updateProgramPath(character.getProgram(), false, false);
            }
            RuneLiteObject runeLiteObject = character.getRuneLiteObject();
            runeLiteObject.setActive(false);
            runeLiteObject.setLocation(localPoint, this.client.getPlane());
            runeLiteObject.setActive(true);
            runeLiteObject.setOrientation(((Integer)character.getOrientationSpinner().getValue()).intValue());
            character.setActive(true);
            character.getSpawnButton().setText("Despawn");
        });
    }

    public void setLocationInstance(Character character, boolean setToPlayer, boolean setToHoveredTile, boolean setToPathStart) {
        this.clientThread.invoke(() -> {
            LocalPoint localPoint;
            LocalPoint[] steps = character.getProgram().getComp().getStepsLP();
            if (setToPlayer) {
                localPoint = this.client.getLocalPlayer().getLocalLocation();
            } else if (setToHoveredTile) {
                Tile tile = this.client.getSelectedSceneTile();
                if (tile == null) {
                    return;
                }
                localPoint = tile.getLocalLocation();
            } else {
                localPoint = setToPathStart && steps.length > 0 ? steps[0] : character.getInstancedPoint();
            }
            if (localPoint == null) {
                return;
            }
            character.setInstancedPoint(localPoint);
            this.pathFinder.transplantSteps(character, localPoint.getSceneX(), localPoint.getSceneY(), character.isInInstance(), true);
            character.setLocationSet(true);
            character.setInInstance(true);
            character.setInstancedRegions(this.client.getMapRegions());
            character.setInstancedPlane(this.client.getPlane());
            this.updateProgramPath(character.getProgram(), false, true);
            RuneLiteObject runeLiteObject = character.getRuneLiteObject();
            runeLiteObject.setActive(false);
            runeLiteObject.setLocation(localPoint, this.client.getPlane());
            runeLiteObject.setActive(true);
            runeLiteObject.setOrientation(((Integer)character.getOrientationSpinner().getValue()).intValue());
            character.setActive(true);
            character.getSpawnButton().setText("Despawn");
        });
    }

    public boolean isInScene(Character character) {
        int[] mapRegions = this.client.getMapRegions();
        if (this.client.isInInstancedRegion() && character.isInInstance()) {
            if (character.getInstancedPoint() == null) {
                return false;
            }
            if (character.getInstancedPlane() != this.client.getPlane()) {
                return false;
            }
            Object[] mapRegionsObjects = new Object[]{mapRegions};
            Object[] instancedRegionObjects = new Object[]{character.getInstancedRegions()};
            return Arrays.deepEquals(mapRegionsObjects, instancedRegionObjects);
        }
        if (!this.client.isInInstancedRegion() && !character.isInInstance()) {
            WorldPoint worldPoint = character.getNonInstancedPoint();
            if (worldPoint == null) {
                return false;
            }
            return worldPoint.isInScene(this.client);
        }
        return false;
    }

    public void toggleSpawn(JButton spawnButton, Character character) {
        if (character.getRuneLiteObject().isActive()) {
            this.despawnCharacter(character);
            spawnButton.setText("Spawn");
            return;
        }
        this.spawnCharacter(character);
        spawnButton.setText("Despawn");
        if (!character.isLocationSet()) {
            this.setLocation(character, true, true, false, false);
        }
    }

    public void spawnCharacter(Character character) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        character.setActive(true);
        this.clientThread.invoke(() -> runeLiteObject.setActive(true));
    }

    public void despawnCharacter(Character character) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        character.setActive(false);
        this.clientThread.invoke(() -> runeLiteObject.setActive(false));
    }

    public void setModel(Character character, boolean modelMode, int modelId) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        this.clientThread.invoke(() -> {
            if (modelMode) {
                CustomModel customModel = character.getStoredModel();
                Model model = customModel == null ? this.client.loadModel(29757) : customModel.getModel();
                runeLiteObject.setModel(model);
                return;
            }
            Model model = this.client.loadModel(modelId);
            runeLiteObject.setModel(model);
        });
    }

    public void setAnimation(Character character, int animationId) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        this.clientThread.invoke(() -> {
            Animation animation = this.client.loadAnimation(animationId);
            runeLiteObject.setAnimation(animation);
        });
    }

    public void unsetAnimation(Character character) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        this.clientThread.invoke(() -> {
            Animation animation = this.client.loadAnimation(-1);
            runeLiteObject.setAnimation(animation);
        });
    }

    public void setRadius(Character character, int radius) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        this.clientThread.invoke(() -> runeLiteObject.setRadius(radius));
    }

    public void addOrientation(Character character, int addition) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        int orientation = runeLiteObject.getOrientation();
        if ((orientation += addition) >= 2048) {
            orientation -= 2048;
        }
        if (orientation < 0) {
            orientation += 2048;
        }
        this.setOrientation(character, orientation);
        JPanel masterPanel = character.getMasterPanel();
        for (Component component : masterPanel.getComponents()) {
            JSpinner spinner;
            if (!(component instanceof JSpinner) || (spinner = (JSpinner)component).getName() == null || !spinner.getName().equals("orientationSpinner")) continue;
            spinner.setValue(orientation);
            return;
        }
    }

    public void setOrientation(Character character, int orientation) {
        RuneLiteObject runeLiteObject = character.getRuneLiteObject();
        this.clientThread.invoke(() -> runeLiteObject.setOrientation(orientation));
    }

    public Character buildCharacter(String name, JPanel panel, JTextField nameTextField, JButton setLocationButton, JButton spawnButton, JButton animationButton, JButton modelButton, int modelId, JSpinner modelSpinner, JComboBox<CustomModel> modelComboBox, boolean customModelMode, boolean minimized, int orientation, JSpinner orientationSpinner, int radius, JSpinner radiusSpinner, int animationId, JSpinner animationSpinner, Program program, JLabel programmerNameLabel, JSpinner programmerIdleSpinner, boolean active, WorldPoint savedWorldPoint, LocalPoint savedLocalPoint, int[] localPointRegion, int localPointPlane, boolean locatedInInstance) {
        RuneLiteObject runeLiteObject = this.client.createRuneLiteObject();
        runeLiteObject.setRadius(radius);
        runeLiteObject.setOrientation(orientation);
        CustomModel customModel = (CustomModel)modelComboBox.getSelectedItem();
        Character character = new Character(name, active, savedWorldPoint != null || savedLocalPoint != null, minimized, program, savedWorldPoint, savedLocalPoint, localPointRegion, localPointPlane, locatedInInstance, customModel, panel, customModelMode, modelComboBox, spawnButton, modelButton, modelSpinner, animationSpinner, orientationSpinner, programmerNameLabel, programmerIdleSpinner, runeLiteObject, 0);
        this.characters.add(character);
        runeLiteObject.setDrawFrontTilesFirst(true);
        runeLiteObject.setShouldLoop(true);
        this.setAnimation(character, animationId);
        this.setModel(character, customModelMode, modelId);
        this.setLocation(character, !character.isLocationSet(), false, false, false);
        runeLiteObject.setActive(active);
        nameTextField.addActionListener(e -> {
            character.setName(nameTextField.getText());
            programmerNameLabel.setText(nameTextField.getText());
        });
        setLocationButton.addActionListener(e -> this.setLocation(character, !character.isLocationSet(), false, false, false));
        spawnButton.addActionListener(e -> this.toggleSpawn(spawnButton, character));
        animationButton.addActionListener(e -> {
            Animation anim = runeLiteObject.getAnimation();
            if (anim == null) {
                animationButton.setText("Anim Off");
                programmerIdleSpinner.setValue((int)((Integer)animationSpinner.getValue()));
                this.setAnimation(character, (Integer)animationSpinner.getValue());
                return;
            }
            int animId = anim.getId();
            if (animId == -1) {
                animationButton.setText("Anim Off");
                programmerIdleSpinner.setValue((int)((Integer)animationSpinner.getValue()));
                this.setAnimation(character, (Integer)animationSpinner.getValue());
                return;
            }
            animationButton.setText("Anim On");
            this.unsetAnimation(character);
        });
        modelButton.addActionListener(e -> {
            if (character.isCustomMode()) {
                character.setCustomMode(false);
                modelButton.setText("Custom");
                modelSpinner.setVisible(true);
                modelComboBox.setVisible(false);
                this.setModel(character, false, (Integer)modelSpinner.getValue());
            } else {
                character.setCustomMode(true);
                modelButton.setText("Id");
                modelSpinner.setVisible(false);
                modelComboBox.setVisible(true);
                this.setModel(character, true, -1);
            }
        });
        modelSpinner.addChangeListener(e -> {
            int modelNumber = (Integer)modelSpinner.getValue();
            this.setModel(character, false, modelNumber);
        });
        modelComboBox.addItemListener(e -> {
            CustomModel m = (CustomModel)modelComboBox.getSelectedItem();
            character.setStoredModel(m);
            if (modelComboBox.isVisible() && character == this.selectedCharacter) {
                this.setModel(character, true, -1);
            }
        });
        orientationSpinner.addChangeListener(e -> {
            int orient = (Integer)orientationSpinner.getValue();
            this.setOrientation(character, orient);
        });
        animationSpinner.addChangeListener(e -> {
            animationButton.setText("Anim Off");
            int animationNumber = (Integer)animationSpinner.getValue();
            this.setAnimation(character, animationNumber);
            programmerIdleSpinner.setValue(animationNumber);
        });
        radiusSpinner.addChangeListener(e -> {
            int rad = (Integer)radiusSpinner.getValue();
            this.setRadius(character, rad);
        });
        return character;
    }

    public void clearNPCs() {
        this.clientThread.invokeLater(() -> {
            for (Character character : this.characters) {
                RuneLiteObject runeLiteObject = character.getRuneLiteObject();
                runeLiteObject.setActive(false);
            }
            this.characters.clear();
        });
    }

    public void sendChatMessage(String chatMessage) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message).build());
    }

    public Model createComplexModel(DetailedModel[] detailedModels, boolean setPriority, LightingStyle lightingStyle) {
        byte[] renderPriorities;
        Model model;
        ModelData[] models = new ModelData[detailedModels.length];
        for (int e = 0; e < detailedModels.length; ++e) {
            int i;
            DetailedModel detailedModel = detailedModels[e];
            ModelData modelData = this.client.loadModelData(detailedModel.getModelId());
            if (modelData == null) {
                return null;
            }
            modelData.cloneVertices().cloneColors();
            switch (detailedModel.getRotate()) {
                case 0: {
                    break;
                }
                case 1: {
                    modelData.rotateY270Ccw();
                    break;
                }
                case 2: {
                    modelData.rotateY180Ccw();
                    break;
                }
                case 3: {
                    modelData.rotateY90Ccw();
                }
            }
            modelData.translate(detailedModel.getXTranslate() + detailedModel.getXTile() * 128, -1 * (detailedModel.getZTranslate() + detailedModel.getZTile() * 128), detailedModel.getYTranslate() + detailedModel.getYTile() * 128);
            modelData.scale(detailedModel.getXScale(), detailedModel.getZScale(), detailedModel.getYScale());
            String[] newColoursArray = detailedModel.getRecolourNew().split(",");
            short[] newColours = new short[newColoursArray.length];
            String[] oldColoursArray = detailedModel.getRecolourOld().split(",");
            short[] oldColours = new short[oldColoursArray.length];
            if (!detailedModel.getRecolourNew().isEmpty() && !detailedModel.getRecolourOld().isEmpty()) {
                if (newColoursArray.length != oldColoursArray.length) {
                    this.clientThread.invokeLater(() -> this.sendChatMessage("Please ensure that each model has the same number of New Colours as Old Colours"));
                    return null;
                }
                try {
                    for (i = 0; i < oldColours.length; ++i) {
                        oldColours[i] = Short.parseShort(oldColoursArray[i]);
                        newColours[i] = Short.parseShort(newColoursArray[i]);
                    }
                }
                catch (Exception exception) {
                    this.clientThread.invokeLater(() -> this.sendChatMessage("Please reformat your colour entry to CSV format (ex. 123,987,456"));
                    return null;
                }
            }
            for (i = 0; i < newColours.length; ++i) {
                modelData.recolor(oldColours[i], newColours[i]);
            }
            models[e] = modelData;
        }
        switch (lightingStyle) {
            default: {
                model = this.client.mergeModels(models).light();
                break;
            }
            case ACTOR: {
                model = this.client.mergeModels(models).light(64, 850, -30, -50, -30);
                break;
            }
            case NONE: {
                model = this.client.mergeModels(models).light(128, 4000, -50, -10, -50);
            }
        }
        if (model == null) {
            return null;
        }
        if (setPriority && (renderPriorities = model.getFaceRenderPriorities()) != null && renderPriorities.length > 0) {
            Arrays.fill(renderPriorities, (byte)0);
        }
        this.sendChatMessage("Model forged. Faces: " + model.getFaceCount() + ", Vertices: " + model.getVerticesCount());
        if (model.getFaceCount() >= 6200 && model.getVerticesCount() >= 3900) {
            this.sendChatMessage("You've exceeded the max face count of 6200 or vertex count of 3900 in this model; any additional faces or vertices will not render");
        }
        return model;
    }

    public void cacheToAnvil(ModelStats[] modelStatsArray, int[] kitRecolours, boolean player) {
        SwingUtilities.invokeLater(() -> {
            for (ModelStats modelStats : modelStatsArray) {
                if (player) {
                    String name = "Item";
                    if (modelStats.getBodyPart() != BodyPart.NA) {
                        name = modelStats.getBodyPart().toString();
                    }
                    StringBuilder recolourNew = new StringBuilder();
                    StringBuilder recolourOld = new StringBuilder();
                    String itemRecolourNew = ModelFinder.shortArrayToString(modelStats.getRecolourTo());
                    String itemRecolourOld = ModelFinder.shortArrayToString(modelStats.getRecolourFrom());
                    String kitRecolourNew = KitRecolourer.getKitRecolourNew(modelStats.getBodyPart(), kitRecolours);
                    String kitRecolourOld = KitRecolourer.getKitRecolourOld(modelStats.getBodyPart());
                    recolourNew.append(itemRecolourNew);
                    recolourOld.append(itemRecolourOld);
                    if (!kitRecolourNew.equals("")) {
                        if (!itemRecolourNew.equals("")) {
                            recolourNew.append(",");
                        }
                        recolourNew.append(kitRecolourNew);
                    }
                    if (!kitRecolourOld.equals("")) {
                        if (!itemRecolourOld.equals("")) {
                            recolourOld.append(",");
                        }
                        recolourOld.append(kitRecolourOld);
                    }
                    this.creatorsPanel.getModelAnvil().createComplexPanel(name, modelStats.getModelId(), 9, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, recolourNew.toString(), recolourOld.toString());
                    continue;
                }
                this.creatorsPanel.getModelAnvil().createComplexPanel("Name", modelStats.getModelId(), 8, 0, 0, 0, 0, 0, 0, 128, 128, 128, 0, ModelFinder.shortArrayToString(modelStats.getRecolourTo()), ModelFinder.shortArrayToString(modelStats.getRecolourFrom()));
            }
        });
    }

    public void cacheToAnvil(CustomModelType type, int id) {
        Thread thread = new Thread(() -> {
            String name;
            ModelStats[] modelStats;
            switch (type) {
                case CACHE_NPC: {
                    modelStats = this.modelFinder.findModelsForNPC(id);
                    name = this.modelFinder.getLastFound();
                    break;
                }
                default: {
                    modelStats = this.modelFinder.findModelsForObject(id);
                    name = this.modelFinder.getLastFound();
                }
            }
            this.cacheToAnvil(modelStats, new int[0], false);
            this.sendChatMessage("Model sent to Anvil: " + name);
        });
        thread.start();
    }

    public void cacheToCustomModel(CustomModelType type, int id) {
        Thread thread = new Thread(() -> {
            CustomModelComp comp;
            String name;
            ModelStats[] modelStats;
            switch (type) {
                case CACHE_NPC: {
                    modelStats = this.modelFinder.findModelsForNPC(id);
                    name = this.modelFinder.getLastFound();
                    comp = new CustomModelComp(0, CustomModelType.CACHE_NPC, id, modelStats, null, null, LightingStyle.ACTOR, false, name);
                    break;
                }
                default: {
                    modelStats = this.modelFinder.findModelsForObject(id);
                    name = this.modelFinder.getLastFound();
                    comp = new CustomModelComp(0, CustomModelType.CACHE_OBJECT, id, modelStats, null, null, LightingStyle.DEFAULT, false, name);
                }
            }
            this.clientThread.invokeLater(() -> {
                Model model = this.constructModelFromCache(modelStats, new int[0], false, true);
                CustomModel customModel = new CustomModel(model, comp);
                this.addCustomModel(customModel, false);
                this.sendChatMessage("Model stored: " + name);
            });
        });
        thread.start();
    }

    public Model constructModelFromCache(ModelStats[] modelStatsArray, int[] kitRecolours, boolean player, boolean actorLighting) {
        ModelData[] mds = new ModelData[modelStatsArray.length];
        for (int i = 0; i < modelStatsArray.length; ++i) {
            ModelStats modelStats = modelStatsArray[i];
            ModelData modelData = this.client.loadModelData(modelStats.getModelId());
            if (modelData == null) continue;
            modelData.cloneColors();
            for (int s = 0; s < modelStats.getRecolourFrom().length; s = (int)((short)(s + 1))) {
                modelData.recolor(modelStats.getRecolourFrom()[s], modelStats.getRecolourTo()[s]);
            }
            if (player) {
                KitRecolourer.recolourKitModel(modelData, modelStats.getBodyPart(), kitRecolours);
            }
            mds[i] = modelData;
        }
        if (actorLighting) {
            return this.client.mergeModels(mds).light(64, 850, -30, -50, -30);
        }
        return this.client.mergeModels(mds).light();
    }

    public void customModelToAnvil(CustomModel customModel) {
        SwingUtilities.invokeLater(() -> {
            CustomModelComp comp = customModel.getComp();
            this.sendChatMessage("Model sent to Anvil: " + comp.getName());
            ModelAnvil modelAnvil = this.creatorsPanel.getModelAnvil();
            if (comp.getModelStats() == null) {
                DetailedModel[] detailedModels;
                for (DetailedModel detailedModel : detailedModels = comp.getDetailedModels()) {
                    modelAnvil.createComplexPanel(detailedModel);
                }
                return;
            }
            switch (comp.getType()) {
                case FORGED: 
                case CACHE_NPC: 
                case CACHE_OBJECT: 
                case CACHE_GROUND_ITEM: {
                    this.cacheToAnvil(comp.getModelStats(), comp.getKitRecolours(), false);
                    break;
                }
                case CACHE_PLAYER: {
                    this.cacheToAnvil(comp.getModelStats(), comp.getKitRecolours(), true);
                }
            }
        });
    }

    public void loadCustomModelToAnvil(File file) {
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            DetailedModel[] detailedModels = (DetailedModel[])this.gson.fromJson((Reader)reader, DetailedModel[].class);
            SwingUtilities.invokeLater(() -> {
                for (DetailedModel detailedModel : detailedModels) {
                    this.creatorsPanel.getModelAnvil().createComplexPanel(detailedModel);
                }
            });
            ((Reader)reader).close();
            return;
        }
        catch (Exception e) {
            this.sendChatMessage("The file chosen is not a valid .json file. Attempting conversion...");
            this.convertTextToJson(file);
            return;
        }
    }

    public void loadCustomModel(File file, boolean priority, LightingStyle lightingStyle, String name) {
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath());
            DetailedModel[] detailedModels = (DetailedModel[])this.gson.fromJson((Reader)reader, DetailedModel[].class);
            this.clientThread.invokeLater(() -> {
                CustomModelComp comp = new CustomModelComp(0, CustomModelType.FORGED, -1, null, null, detailedModels, lightingStyle, priority, name);
                Model model = this.createComplexModel(detailedModels, priority, lightingStyle);
                CustomModel customModel = new CustomModel(model, comp);
                this.addCustomModel(customModel, false);
            });
            ((Reader)reader).close();
            return;
        }
        catch (Exception e) {
            this.sendChatMessage("The file chosen is not a valid .json file. Attempting conversion...");
            this.convertTextToJson(file);
            return;
        }
    }

    private void convertTextToJson(File file) {
        ArrayList<DetailedModel> list = new ArrayList<DetailedModel>();
        try {
            String name;
            Scanner myReader = new Scanner(file);
            myReader.nextLine();
            String s = "";
            while ((s = myReader.nextLine()) != null) {
                name = "";
                int modelId = 0;
                int group = 1;
                int xTile = 0;
                int yTile = 0;
                int zTile = 0;
                int xTranslate = 0;
                int yTranslate = 0;
                int zTranslate = 0;
                int xScale = 0;
                int yScale = 0;
                int zScale = 0;
                int rotate = 0;
                String newColours = "";
                String oldColours = "";
                boolean setBreak = false;
                String data = "";
                try {
                    while (!(data = myReader.nextLine()).equals("")) {
                        String[] split;
                        if (data.startsWith("name=") && (split = data.split("=")).length > 1) {
                            name = split[1];
                        }
                        if (data.startsWith("modelid=")) {
                            modelId = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("group=")) {
                            group = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("xtile=")) {
                            xTile = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("ytile=")) {
                            yTile = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("ztile=")) {
                            zTile = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("xt=")) {
                            xTranslate = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("yt=")) {
                            yTranslate = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("zt=")) {
                            zTranslate = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("xs=")) {
                            xScale = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("ys=")) {
                            yScale = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("zs=")) {
                            zScale = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("r=")) {
                            rotate = Integer.parseInt(data.split("=")[1]);
                        }
                        if (data.startsWith("n=")) {
                            newColours = data.replaceAll("n=", "");
                        }
                        if (!data.startsWith("o=")) continue;
                        oldColours = data.replaceAll("o=", "");
                    }
                }
                catch (NoSuchElementException e) {
                    setBreak = true;
                }
                DetailedModel detailedModel = new DetailedModel(name, modelId, group, xTile, yTile, zTile, xTranslate, yTranslate, zTranslate, xScale, yScale, zScale, rotate, newColours, oldColours);
                list.add(detailedModel);
                if (!setBreak) continue;
                break;
            }
            myReader.close();
            SwingUtilities.invokeLater(() -> {
                for (DetailedModel detailedModel : list) {
                    this.creatorsPanel.getModelAnvil().createComplexPanel(detailedModel.getName(), detailedModel.getModelId(), detailedModel.getGroup(), detailedModel.getXTile(), detailedModel.getYTile(), detailedModel.getZTile(), detailedModel.getXTranslate(), detailedModel.getYTranslate(), detailedModel.getZTranslate(), detailedModel.getXScale(), detailedModel.getYScale(), detailedModel.getZScale(), detailedModel.getRotate(), detailedModel.getRecolourNew(), detailedModel.getRecolourOld());
                }
            });
            try {
                name = file.getPath();
                if (name.endsWith(".txt")) {
                    name = name.substring(0, name.length() - 4);
                }
                File newFile = new File(name + ".json");
                FileWriter writer = new FileWriter(newFile, false);
                String string = this.gson.toJson(list);
                writer.write(string);
                writer.close();
                file.delete();
                this.sendChatMessage("The chosen .txt file has been successfully updated to a .json file for future use.");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.sendChatMessage("An error occurred while trying to convert this file to a .json file.");
            }
        }
        catch (FileNotFoundException e) {
            this.sendChatMessage("An error occurred while trying to convert this file to a .json file.");
            e.printStackTrace();
        }
    }

    public void addCustomModel(CustomModel customModel, boolean setComboBox) {
        SwingUtilities.invokeLater(() -> this.creatorsPanel.addModelOption(customModel, setComboBox));
        this.storedModels.add(customModel);
    }

    public void removeCustomModel(CustomModel customModel) {
        SwingUtilities.invokeLater(() -> this.creatorsPanel.removeModelOption(customModel));
        this.storedModels.remove(customModel);
    }

    public void updateProgramPath(Program program, boolean gameStateChanged, boolean instanced) {
        if (instanced) {
            this.updateInstancedProgramPath(program, gameStateChanged);
            return;
        }
        this.updateNonInstancedProgramPath(program, gameStateChanged);
    }

    public void updateInstancedProgramPath(Program program, boolean gameStateChanged) {
        ProgramComp comp = program.getComp();
        LocalPoint[] stepsLP = comp.getStepsLP();
        Object[] pathLP = new LocalPoint[]{};
        Object[] allCoordinates = new Coordinate[]{};
        if (stepsLP.length < 2) {
            comp.setPathLP((LocalPoint[])pathLP);
            comp.setCoordinates((Coordinate[])allCoordinates);
            return;
        }
        for (int i = 0; i < stepsLP.length - 1; ++i) {
            Object[] coordinates = this.pathFinder.getPath(stepsLP[i], stepsLP[i + 1], comp.getMovementType());
            if (coordinates == null) {
                if (!gameStateChanged) {
                    this.sendChatMessage("A path could not be found.");
                }
                comp.setPathLP(new LocalPoint[0]);
                comp.setCoordinates(new Coordinate[0]);
                return;
            }
            allCoordinates = (Coordinate[])ArrayUtils.addAll((Object[])allCoordinates, (Object[])coordinates);
            Direction direction = Direction.UNSET;
            for (int c = 0; c < coordinates.length - 1; ++c) {
                int x = ((Coordinate)coordinates[c]).getColumn();
                int y = ((Coordinate)coordinates[c]).getRow();
                int nextX = ((Coordinate)coordinates[c + 1]).getColumn();
                int nextY = ((Coordinate)coordinates[c + 1]).getRow();
                int changeX = nextX - x;
                int changeY = nextY - y;
                Direction newDirection = Direction.getDirection(changeX, changeY);
                if (direction != Direction.UNSET && direction == newDirection) continue;
                direction = newDirection;
                LocalPoint localPoint = LocalPoint.fromScene((int)x, (int)y);
                pathLP = (LocalPoint[])ArrayUtils.add((Object[])pathLP, (Object)localPoint);
            }
        }
        pathLP = (LocalPoint[])ArrayUtils.add((Object[])pathLP, (Object)stepsLP[stepsLP.length - 1]);
        comp.setPathLP((LocalPoint[])pathLP);
        comp.setCoordinates((Coordinate[])allCoordinates);
    }

    public void updateNonInstancedProgramPath(Program program, boolean gameStateChanged) {
        ProgramComp comp = program.getComp();
        WorldPoint[] stepsWP = comp.getStepsWP();
        Object[] pathWP = new WorldPoint[]{};
        Object[] allCoordinates = new Coordinate[]{};
        if (stepsWP.length < 2) {
            comp.setPathWP((WorldPoint[])pathWP);
            comp.setCoordinates((Coordinate[])allCoordinates);
            return;
        }
        for (int i = 0; i < stepsWP.length - 1; ++i) {
            Object[] coordinates = this.pathFinder.getPath(stepsWP[i], stepsWP[i + 1], comp.getMovementType());
            if (coordinates == null) {
                if (!gameStateChanged) {
                    this.sendChatMessage("A path could not be found.");
                }
                comp.setPathWP(new WorldPoint[0]);
                comp.setCoordinates(new Coordinate[0]);
                return;
            }
            allCoordinates = (Coordinate[])ArrayUtils.addAll((Object[])allCoordinates, (Object[])coordinates);
            Direction direction = Direction.UNSET;
            for (int c = 0; c < coordinates.length - 1; ++c) {
                int x = ((Coordinate)coordinates[c]).getColumn();
                int y = ((Coordinate)coordinates[c]).getRow();
                int nextX = ((Coordinate)coordinates[c + 1]).getColumn();
                int nextY = ((Coordinate)coordinates[c + 1]).getRow();
                int changeX = nextX - x;
                int changeY = nextY - y;
                Direction newDirection = Direction.getDirection(changeX, changeY);
                if (direction != Direction.UNSET && direction == newDirection) continue;
                direction = newDirection;
                LocalPoint localPoint = LocalPoint.fromScene((int)x, (int)y);
                pathWP = (WorldPoint[])ArrayUtils.add((Object[])pathWP, (Object)WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint));
            }
        }
        pathWP = (WorldPoint[])ArrayUtils.add((Object[])pathWP, (Object)stepsWP[stepsWP.length - 1]);
        comp.setPathWP((WorldPoint[])pathWP);
        comp.setCoordinates((Coordinate[])allCoordinates);
    }

    public void resetProgram(Character character, boolean restart) {
        int arrayLength;
        Program program = character.getProgram();
        ProgramComp comp = program.getComp();
        comp.setCurrentStep(0);
        if (!this.isInScene(character)) {
            return;
        }
        boolean resetLocation = true;
        if (character.isInInstance()) {
            if (comp.getStepsLP().length == 0) {
                return;
            }
            LocalPoint lp = comp.getStepsLP()[0];
            if (lp == null) {
                return;
            }
            if (!lp.isInScene()) {
                return;
            }
            arrayLength = comp.getStepsLP().length;
            if (restart && lp.distanceTo(comp.getStepsLP()[arrayLength - 1]) == 0) {
                resetLocation = false;
            }
        }
        if (!character.isInInstance()) {
            if (comp.getStepsWP().length == 0) {
                return;
            }
            WorldPoint wp = comp.getStepsWP()[0];
            if (wp == null) {
                return;
            }
            arrayLength = comp.getStepsWP().length;
            if (restart && wp.distanceTo(comp.getStepsWP()[arrayLength - 1]) == 0) {
                resetLocation = false;
            }
        }
        if (resetLocation) {
            this.setLocation(character, false, false, false, true);
        }
        comp.setProgramActive(restart);
    }

    public void updatePanelComboBoxes() {
        SwingUtilities.invokeLater(() -> {
            for (JComboBox<CustomModel> comboBox : this.creatorsPanel.getComboBoxes()) {
                comboBox.updateUI();
            }
        });
    }

    public ArrayList<ComplexPanel> getComplexPanels() {
        return this.creatorsPanel.getModelAnvil().getComplexPanels();
    }

    @Provides
    CreatorsConfig provideConfig(ConfigManager configManager) {
        return (CreatorsConfig)configManager.getConfig(CreatorsConfig.class);
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public CreatorsConfig getConfig() {
        return this.config;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ClientToolbar getClientToolbar() {
        return this.clientToolbar;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public CreatorsOverlay getOverlay() {
        return this.overlay;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public ChatMessageManager getChatMessageManager() {
        return this.chatMessageManager;
    }

    public ModelGetter getModelGetter() {
        return this.modelGetter;
    }

    public PathFinder getPathFinder() {
        return this.pathFinder;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ModelFinder getModelFinder() {
        return this.modelFinder;
    }

    public CreatorsPanel getCreatorsPanel() {
        return this.creatorsPanel;
    }

    public NavigationButton getNavigationButton() {
        return this.navigationButton;
    }

    public boolean isOverlaysActive() {
        return this.overlaysActive;
    }

    public ArrayList<Character> getCharacters() {
        return this.characters;
    }

    public ArrayList<CustomModel> getStoredModels() {
        return this.storedModels;
    }

    public Character getSelectedCharacter() {
        return this.selectedCharacter;
    }

    public Character getHoveredCharacter() {
        return this.hoveredCharacter;
    }

    public RuneLiteObject getTransmog() {
        return this.transmog;
    }

    public CustomModel getTransmogModel() {
        return this.transmogModel;
    }

    public int getSavedRegion() {
        return this.savedRegion;
    }

    public int getSavedPlane() {
        return this.savedPlane;
    }

    public AutoRotate getAutoRotateYaw() {
        return this.autoRotateYaw;
    }

    public AutoRotate getAutoRotatePitch() {
        return this.autoRotatePitch;
    }

    public int getBRIGHT_AMBIENT() {
        return this.BRIGHT_AMBIENT;
    }

    public int getBRIGHT_CONTRAST() {
        return this.BRIGHT_CONTRAST;
    }

    public int getDARK_AMBIENT() {
        return this.DARK_AMBIENT;
    }

    public int getDARK_CONTRAST() {
        return this.DARK_CONTRAST;
    }

    public boolean isPauseMode() {
        return this.pauseMode;
    }

    public boolean isAutoSetupPathFound() {
        return this.autoSetupPathFound;
    }

    public int[] getPoseAnimations() {
        return this.poseAnimations;
    }

    public HotkeyListener getOverlayKeyListener() {
        return this.overlayKeyListener;
    }

    public HotkeyListener getOculusOrbListener() {
        return this.oculusOrbListener;
    }

    public HotkeyListener getQuickSpawnListener() {
        return this.quickSpawnListener;
    }

    public HotkeyListener getQuickLocationListener() {
        return this.quickLocationListener;
    }

    public HotkeyListener getQuickRotateCWListener() {
        return this.quickRotateCWListener;
    }

    public HotkeyListener getQuickRotateCCWListener() {
        return this.quickRotateCCWListener;
    }

    public HotkeyListener getAutoLeftListener() {
        return this.autoLeftListener;
    }

    public HotkeyListener getAutoRightListener() {
        return this.autoRightListener;
    }

    public HotkeyListener getAutoUpListener() {
        return this.autoUpListener;
    }

    public HotkeyListener getAutoDownListener() {
        return this.autoDownListener;
    }

    public HotkeyListener getAddProgramStepListener() {
        return this.addProgramStepListener;
    }

    public HotkeyListener getRemoveProgramStepListener() {
        return this.removeProgramStepListener;
    }

    public HotkeyListener getClearProgramStepListener() {
        return this.clearProgramStepListener;
    }

    public HotkeyListener getPlayPauseListener() {
        return this.playPauseListener;
    }

    public HotkeyListener getPlayPauseAllListener() {
        return this.playPauseAllListener;
    }

    public HotkeyListener getResetListener() {
        return this.resetListener;
    }

    public HotkeyListener getResetAllListener() {
        return this.resetAllListener;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setClientThread(ClientThread clientThread) {
        this.clientThread = clientThread;
    }

    public void setConfig(CreatorsConfig config) {
        this.config = config;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setClientToolbar(ClientToolbar clientToolbar) {
        this.clientToolbar = clientToolbar;
    }

    public void setOverlayManager(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
    }

    public void setOverlay(CreatorsOverlay overlay) {
        this.overlay = overlay;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setChatMessageManager(ChatMessageManager chatMessageManager) {
        this.chatMessageManager = chatMessageManager;
    }

    public void setModelGetter(ModelGetter modelGetter) {
        this.modelGetter = modelGetter;
    }

    public void setPathFinder(PathFinder pathFinder) {
        this.pathFinder = pathFinder;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setModelFinder(ModelFinder modelFinder) {
        this.modelFinder = modelFinder;
    }

    public void setCreatorsPanel(CreatorsPanel creatorsPanel) {
        this.creatorsPanel = creatorsPanel;
    }

    public void setNavigationButton(NavigationButton navigationButton) {
        this.navigationButton = navigationButton;
    }

    public void setOverlaysActive(boolean overlaysActive) {
        this.overlaysActive = overlaysActive;
    }

    public void setSelectedCharacter(Character selectedCharacter) {
        this.selectedCharacter = selectedCharacter;
    }

    public void setHoveredCharacter(Character hoveredCharacter) {
        this.hoveredCharacter = hoveredCharacter;
    }

    public void setTransmog(RuneLiteObject transmog) {
        this.transmog = transmog;
    }

    public void setTransmogModel(CustomModel transmogModel) {
        this.transmogModel = transmogModel;
    }

    public void setSavedRegion(int savedRegion) {
        this.savedRegion = savedRegion;
    }

    public void setSavedPlane(int savedPlane) {
        this.savedPlane = savedPlane;
    }

    public void setAutoRotateYaw(AutoRotate autoRotateYaw) {
        this.autoRotateYaw = autoRotateYaw;
    }

    public void setAutoRotatePitch(AutoRotate autoRotatePitch) {
        this.autoRotatePitch = autoRotatePitch;
    }

    public void setPauseMode(boolean pauseMode) {
        this.pauseMode = pauseMode;
    }

    public void setAutoSetupPathFound(boolean autoSetupPathFound) {
        this.autoSetupPathFound = autoSetupPathFound;
    }

    public void setPoseAnimations(int[] poseAnimations) {
        this.poseAnimations = poseAnimations;
    }
}

