/*
 * Decompiled with CFR 0.152.
 */
package com.creatorskit;

import com.creatorskit.Character;
import com.creatorskit.CreatorsConfig;
import com.creatorskit.CreatorsPlugin;
import com.creatorskit.programming.Coordinate;
import com.creatorskit.programming.Program;
import com.creatorskit.programming.ProgramComp;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class CreatorsOverlay
extends Overlay {
    private final Client client;
    private final CreatorsPlugin plugin;
    private final CreatorsConfig config;
    private static final Color HOVERED_COLOUR = new Color(146, 206, 193, 255);
    private static final Color SELECTED_COLOUR = new Color(220, 253, 245);
    private static final Color MY_OBJECT_COLOUR = new Color(35, 208, 187);
    private static final Color GAME_OBJECT_COLOUR = new Color(255, 138, 18);
    private static final Color GROUND_OBJECT_COLOUR = new Color(73, 255, 0);
    private static final Color WALL_OBJECT_COLOUR = new Color(255, 70, 70);
    private static final Color DECORATIVE_OBJECT_COLOUR = new Color(183, 126, 255);
    private static final Color NPC_COLOUR = new Color(188, 198, 255);
    private static final Color PLAYER_COLOUR = new Color(221, 133, 255);
    private static final int MAX_DISTANCE = 2400;

    @Inject
    private CreatorsOverlay(Client client, CreatorsPlugin plugin, CreatorsConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getGameState() != GameState.LOGGED_IN || !this.plugin.isOverlaysActive()) {
            return null;
        }
        this.renderObjectsOverlay(graphics);
        if (this.config.pathOverlay()) {
            if (this.client.isInInstancedRegion()) {
                this.renderInstancedProgramOverlay(graphics);
            } else {
                this.renderNonInstancedProgramOverlay(graphics);
            }
        }
        if (this.config.npcOverlay()) {
            this.renderNPCOverlay(graphics);
        }
        if (this.config.playerOverlay()) {
            this.renderPlayerOverlay(graphics);
        }
        return null;
    }

    public void renderNonInstancedProgramOverlay(Graphics2D graphics) {
        for (int e = 0; e < this.plugin.getCharacters().size(); ++e) {
            Program program;
            Character character = this.plugin.getCharacters().get(e);
            if (!this.plugin.isInScene(character) || (program = character.getProgram()) == null) continue;
            ProgramComp comp = program.getComp();
            Coordinate[] coordinates = comp.getCoordinates();
            for (int i = 0; i < coordinates.length - 1; ++i) {
                if (coordinates[i] == null) continue;
                LocalPoint lpStart = LocalPoint.fromScene((int)coordinates[i].getColumn(), (int)coordinates[i].getRow());
                LocalPoint lpEnd = LocalPoint.fromScene((int)coordinates[i + 1].getColumn(), (int)coordinates[i + 1].getRow());
                Point startPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)lpStart, (int)this.client.getPlane());
                Point endPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)lpEnd, (int)this.client.getPlane());
                if (startPoint == null || endPoint == null) continue;
                graphics.setColor(comp.getColor());
                graphics.setStroke(new BasicStroke(1.0f));
                graphics.drawLine(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
            }
            WorldPoint[] points = comp.getStepsWP();
            String name = character.getName();
            String abbreviation = "";
            int abbreviationLength = 3;
            int nameLength = name.length();
            abbreviation = abbreviationLength > nameLength ? character.getName().substring(0, nameLength) : character.getName().substring(0, 3);
            for (int i = 0; i < points.length; ++i) {
                Point textPoint;
                LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)points[i]);
                if (localPoint == null || (textPoint = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)abbreviation, (int)0)) == null) continue;
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPoint, (String)abbreviation, (Color)comp.getColor());
            }
        }
    }

    public void renderInstancedProgramOverlay(Graphics2D graphics) {
        for (int e = 0; e < this.plugin.getCharacters().size(); ++e) {
            Program program;
            LocalPoint savedLocation;
            Character character = this.plugin.getCharacters().get(e);
            if (!this.plugin.isInScene(character) || (savedLocation = character.getInstancedPoint()) == null || !savedLocation.isInScene() || (program = character.getProgram()) == null) continue;
            ProgramComp comp = program.getComp();
            Coordinate[] coordinates = comp.getCoordinates();
            for (int i = 0; i < coordinates.length - 1; ++i) {
                if (coordinates[i] == null) continue;
                LocalPoint lpStart = LocalPoint.fromScene((int)coordinates[i].getColumn(), (int)coordinates[i].getRow());
                LocalPoint lpEnd = LocalPoint.fromScene((int)coordinates[i + 1].getColumn(), (int)coordinates[i + 1].getRow());
                Point startPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)lpStart, (int)this.client.getPlane());
                Point endPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)lpEnd, (int)this.client.getPlane());
                if (startPoint == null || endPoint == null) continue;
                graphics.setColor(comp.getColor());
                graphics.setStroke(new BasicStroke(1.0f));
                graphics.drawLine(startPoint.getX(), startPoint.getY(), endPoint.getX(), endPoint.getY());
            }
            LocalPoint[] points = comp.getStepsLP();
            String name = character.getName();
            String abbreviation = "";
            int abbreviationLength = 3;
            int nameLength = name.length();
            abbreviation = abbreviationLength > nameLength ? character.getName().substring(0, nameLength - 1) : character.getName().substring(0, 3);
            for (int i = 0; i < points.length; ++i) {
                Point textPoint;
                LocalPoint localPoint = points[i];
                if (localPoint == null || (textPoint = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)abbreviation, (int)0)) == null) continue;
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPoint, (String)abbreviation, (Color)comp.getColor());
            }
        }
    }

    public void renderPlayerOverlay(Graphics2D graphics) {
        for (Player player : this.client.getPlayers()) {
            LocalPoint localPoint = player.getLocalLocation();
            if (localPoint == null) continue;
            OverlayUtil.renderActorOverlay((Graphics2D)graphics, (Actor)player, (String)("A: " + player.getAnimation() + ", P: " + player.getPoseAnimation()), (Color)PLAYER_COLOUR);
        }
    }

    public void renderNPCOverlay(Graphics2D graphics) {
        for (NPC npc : this.client.getNpcs()) {
            LocalPoint localPoint = npc.getLocalLocation();
            if (localPoint == null) continue;
            OverlayUtil.renderActorOverlay((Graphics2D)graphics, (Actor)npc, (String)("ID: " + npc.getId() + ", A: " + npc.getAnimation() + ", P: " + npc.getPoseAnimation()), (Color)NPC_COLOUR);
        }
    }

    public void renderObjectsOverlay(Graphics2D graphics) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Player player;
                Tile tile = tiles[z][x][y];
                if (tile == null || (player = this.client.getLocalPlayer()) == null) continue;
                if (this.config.gameObjectOverlay() || this.config.myObjectOverlay()) {
                    this.renderGameObjects(graphics, tile, player);
                }
                if (this.config.groundObjectOverlay()) {
                    this.renderGroundObjects(graphics, tile, player);
                }
                if (this.config.wallObjectOverlay()) {
                    this.renderWallObjects(graphics, tile, player);
                }
                if (!this.config.decorativeObjectOverlay()) continue;
                this.renderDecorativeObjects(graphics, tile, player);
            }
        }
    }

    public void renderGameObjects(Graphics2D graphics, Tile tile, Player player) {
        GameObject[] gameObjects = tile.getGameObjects();
        if (gameObjects != null) {
            for (GameObject gameObject : gameObjects) {
                if (gameObject == null || !gameObject.getSceneMinLocation().equals((Object)tile.getSceneLocation()) || gameObject.getRenderable() instanceof Actor) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (gameObject.getRenderable() instanceof RuneLiteObject && this.config.myObjectOverlay()) {
                    RuneLiteObject runeLiteObject = (RuneLiteObject)gameObject.getRenderable();
                    for (int i = 0; i < this.plugin.getCharacters().size(); ++i) {
                        Character character = this.plugin.getCharacters().get(i);
                        if (character.getRuneLiteObject() != runeLiteObject) continue;
                        stringBuilder.append(character.getName());
                        if (this.plugin.getSelectedCharacter() == character) {
                            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)gameObject, (String)stringBuilder.toString(), (Color)SELECTED_COLOUR);
                            continue;
                        }
                        if (this.plugin.getHoveredCharacter() == character) {
                            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)gameObject, (String)stringBuilder.toString(), (Color)HOVERED_COLOUR);
                            continue;
                        }
                        OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)gameObject, (String)stringBuilder.toString(), (Color)MY_OBJECT_COLOUR);
                    }
                    continue;
                }
                LocalPoint camera = new LocalPoint(this.client.getCameraX(), this.client.getCameraY());
                if (gameObject.getLocalLocation().distanceTo(camera) > 2400 || !this.config.gameObjectOverlay()) continue;
                stringBuilder.append("ID: ").append(gameObject.getId());
                if (gameObject.getRenderable() instanceof DynamicObject) {
                    Animation animation = ((DynamicObject)gameObject.getRenderable()).getAnimation();
                    if (animation != null) {
                        stringBuilder.append(" A: ").append(animation.getId());
                    } else {
                        stringBuilder.append(" A: -1");
                    }
                } else {
                    stringBuilder.append(" A: -1");
                }
                OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)gameObject, (String)stringBuilder.toString(), (Color)GAME_OBJECT_COLOUR);
            }
        }
    }

    public void renderGroundObjects(Graphics2D graphics, Tile tile, Player player) {
        GroundObject groundObject = tile.getGroundObject();
        if (groundObject != null && player.getLocalLocation().distanceTo(groundObject.getLocalLocation()) <= 2400) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)groundObject, (String)("ID: " + groundObject.getId()), (Color)GROUND_OBJECT_COLOUR);
        }
    }

    public void renderWallObjects(Graphics2D graphics, Tile tile, Player player) {
        WallObject tileObject = tile.getWallObject();
        if (tileObject != null && player.getLocalLocation().distanceTo(tileObject.getLocalLocation()) <= 2400) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)tileObject, (String)("ID: " + tileObject.getId()), (Color)WALL_OBJECT_COLOUR);
        }
    }

    public void renderDecorativeObjects(Graphics2D graphics, Tile tile, Player player) {
        DecorativeObject tileObject = tile.getDecorativeObject();
        if (tileObject != null && player.getLocalLocation().distanceTo(tileObject.getLocalLocation()) <= 2400) {
            OverlayUtil.renderTileOverlay((Graphics2D)graphics, (TileObject)tileObject, (String)("ID: " + tileObject.getId()), (Color)DECORATIVE_OBJECT_COLOUR);
        }
    }
}

