/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.currentworld;

import com.brooklyn.currentworld.CurrentWorldConfig;
import com.brooklyn.currentworld.CurrentWorldOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Current World", description="Pins activity to the world switcher, overlays your current world", tags={"hub", "world", "overlay", "pvp", "brooklyn", "activity", "switcher"})
public class CurrentWorldPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CurrentWorldPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CurrentWorldConfig config;
    @Inject
    private CurrentWorldOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldService worldService;
    private String activity;

    @Provides
    CurrentWorldConfig getConfig(ConfigManager configManager) {
        return (CurrentWorldConfig)configManager.getConfig(CurrentWorldConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.getWorld();
        this.setWorldListTitle();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.unsetWorldListTitle();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("currentworld")) {
            if (this.config.worldSwitcherActivity()) {
                this.setWorldListTitle();
            } else {
                this.unsetWorldListTitle();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.getWorld();
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 841) {
            this.setWorldListTitle();
        }
    }

    private void getWorld() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult != null) {
            World world = worldResult.findWorld(this.client.getWorld());
            this.activity = world.getActivity();
        }
    }

    private void setWorldListTitle() {
        Widget worldListTitleWidget = this.client.getWidget(69, 2);
        if (worldListTitleWidget != null && this.config.worldSwitcherActivity()) {
            worldListTitleWidget.setText(this.activity.equals("-") ? "World " + this.client.getWorld() : "World " + this.client.getWorld() + "<br>" + this.activity);
        }
    }

    private void unsetWorldListTitle() {
        Widget worldListTitleWidget = this.client.getWidget(69, 2);
        if (worldListTitleWidget != null) {
            worldListTitleWidget.setText("Current world - " + this.client.getWorld());
        }
    }
}

