/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.currentworld;

import com.brooklyn.currentworld.CurrentWorldConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.WorldType;
import net.runelite.client.game.WorldService;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;

public class CurrentWorldOverlay
extends OverlayPanel {
    private final Client client;
    private final CurrentWorldConfig config;
    private final WorldService worldService;

    @Inject
    private CurrentWorldOverlay(Client client, CurrentWorldConfig config, WorldService worldService) {
        this.client = client;
        this.config = config;
        this.worldService = worldService;
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.TOP_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        World currentWorld;
        if (!this.config.showOverlay()) {
            return null;
        }
        if (!this.panelComponent.getChildren().isEmpty()) {
            this.panelComponent.getChildren().remove(0);
        }
        WorldResult worldResult = this.worldService.getWorlds();
        boolean pvpWorld = this.client.getWorldType().contains(WorldType.PVP) || this.client.getWorldType().contains(WorldType.DEADMAN);
        boolean highRiskWorld = this.client.getWorldType().contains(WorldType.HIGH_RISK);
        Color textColor = pvpWorld ? this.config.pvpWorldColor() : (highRiskWorld ? this.config.highRiskWorldColor() : this.config.safeWorldColor());
        ArrayList<String> textToDisplay = new ArrayList<String>();
        if (!this.config.overlayActivity() && (pvpWorld || highRiskWorld)) {
            textToDisplay.add(pvpWorld ? "PVP WORLD" : "HIGH RISK");
        }
        textToDisplay.add("World " + this.client.getWorld());
        if (this.config.overlayActivity() && worldResult != null && !"-".equals((currentWorld = worldResult.findWorld(this.client.getWorld())).getActivity())) {
            textToDisplay.add(currentWorld.getActivity());
        }
        int overlayWidth = this.calculateWidth(graphics, textToDisplay) + 10;
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.setPreferredSize(new Dimension(overlayWidth, 0));
        for (String text : textToDisplay) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(text).color(textColor).build());
        }
        return super.render(graphics);
    }

    private int calculateWidth(Graphics2D graphics, Collection<String> textToDisplay) {
        return textToDisplay.stream().mapToInt(line -> graphics.getFontMetrics().stringWidth((String)line)).max().orElseThrow(() -> new IllegalArgumentException("Can't calculate overlay width"));
    }
}

