/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.panels;

import com.InfernalFC.helpers.DataManager;
import com.InfernalFC.helpers.InventoryManager;
import com.InfernalFC.helpers.ResourceManager;
import com.InfernalFC.models.ItemData;
import com.InfernalFC.models.RankData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class RanksPanel
extends JPanel {
    private final DataManager dataManager;
    private final ResourceManager resourceManager;
    private final InventoryManager inventoryManager;
    private JPanel cmButtonPanel = new JPanel();
    private JPanel itemPanel = new JPanel();
    private JPanel pointsPanel = new JPanel();
    private RankData selectedRank;
    private JLabel rankName = new JLabel("");

    @Inject
    private RanksPanel(DataManager dataManager, ResourceManager resourceManager, InventoryManager inventoryManager) {
        this.dataManager = dataManager;
        this.resourceManager = resourceManager;
        this.inventoryManager = inventoryManager;
        this.cmButtonPanel.add((Component)this.createRankButton("Trial_icon.png", "Trial"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Recruit_icon.png", "Recruit"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Peon_icon.png", "Pawn"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Corporal_icon.png", "Corporal"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Sergeant_icon.png", "Sergeant"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Cadet_icon.png", "Cadet"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Officer_icon.png", "Officer"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Commander_icon.png", "Commander"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Colonel_icon.png", "Colonel"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Brigadier_icon.png", "Brigadier"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Admiral_icon.png", "Admiral"), "West");
        this.cmButtonPanel.add((Component)this.createRankButton("Marshal_icon.png", "Marshal"), "West");
        this.itemPanel.setLayout(new GridLayout(0, 4));
        this.pointsPanel.setLayout(new GridLayout(0, 2));
        this.cmButtonPanel.setLayout(new GridLayout(0, 6));
        this.rankName.setFont(new Font("Arial", 1, 18));
        this.add(this.cmButtonPanel);
        this.add(this.rankName);
        this.add(this.itemPanel);
        this.add(this.pointsPanel);
        this.setPreferredSize(new Dimension(200, 860));
    }

    public void rankChange(String rankName) {
        this.rankName.setText(rankName);
        RankData[] ranks = this.dataManager.GetRankData();
        this.selectedRank = Arrays.stream(ranks).filter(rank -> rankName.equals(rank.getName())).findFirst().orElse(null);
        int height = (int)Math.ceil((double)this.selectedRank.items.length / 4.0) * 50;
        this.itemPanel.setPreferredSize(new Dimension(200, height));
        this.itemPanel.removeAll();
        this.inventoryManager.UpdateInventoryItems();
        Arrays.sort(this.selectedRank.getItems(), Comparator.comparing(ItemData::getName));
        for (ItemData item : this.selectedRank.getItems()) {
            this.itemPanel.add(this.createItemLabel(item));
        }
        this.pointsPanel.removeAll();
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createHeaderLabel("Points"));
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createIconLabel("Total_points.png", this.selectedRank.getTotal() + " Total"));
        this.pointsPanel.add(this.createIconLabel("Pvm_points.png", this.selectedRank.getPvm() + " PvM"));
        this.pointsPanel.add(this.createIconLabel("Ehb_points.png", this.selectedRank.getTasks() + " Diaries tier 4"));
        this.pointsPanel.add(this.createIconLabel("Community_points.png", this.selectedRank.getCommunity() + " Community"));
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createHeaderLabel("Skills"));
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createIconLabel("Req_level.png", this.selectedRank.getCombat() + " Combat"));
        this.pointsPanel.add(this.createIconLabel("Req_total.png", "1750+ Total"));
        this.pointsPanel.add(this.createIconLabel("Req_ranged.png", "99 Ranged"));
        this.pointsPanel.add(this.createIconLabel("Req_magic.png", this.selectedRank.getMagic() + " Magic"));
        this.pointsPanel.add(this.createIconLabel("Req_herb.png", this.selectedRank.getHerblore() + " Herblore"));
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createHeaderLabel("Misc"));
        this.pointsPanel.add(new JLabel());
        this.pointsPanel.add(this.createIconLabel("Req_box.png", "<html>Ornate Jewellery <br/>Box</html>"));
        this.pointsPanel.add(this.createIconLabel("Req_pool.png", "Ornate Pool"));
        this.pointsPanel.add(this.createIconLabel("Req_piety.png", "Piety"));
        this.pointsPanel.add(this.createIconLabel("Req_rigour.png", "Rigour"));
        this.pointsPanel.add(this.createIconLabel("Req_augury.png", "Augury"));
        this.pointsPanel.add(this.createIconLabel("Req_gold.png", this.selectedRank.getCoins() + "m PvM Gear"));
        this.pointsPanel.add(this.createIconLabel("Req_time.png", this.selectedRank.getMonths() + " Months in clan"));
        this.itemPanel.updateUI();
        this.updateUI();
    }

    public void updateItems() {
        this.inventoryManager.UpdateInventoryItems();
        for (Component component : this.itemPanel.getComponents()) {
            JLabel label = (JLabel)component;
            if (this.inventoryManager.HasItem(label.getToolTipText())) {
                label.setOpaque(false);
                continue;
            }
            label.setOpaque(true);
        }
        this.itemPanel.updateUI();
    }

    private JLabel createItemLabel(ItemData item) {
        JLabel label = new JLabel();
        label.setToolTipText(item.getName());
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        label.setBackground(new Color(39, 25, 25));
        if (this.inventoryManager.HasItem(item.getName())) {
            label.setOpaque(false);
        } else {
            label.setOpaque(true);
        }
        try {
            Runnable task = () -> label.setIcon(this.resourceManager.GetItemImage(item.getName()));
            Thread thread = new Thread(task);
            thread.start();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return label;
    }

    private JLabel createIconLabel(String name, String title) {
        JLabel label = new JLabel(title);
        label.setFont(new Font("Arial", 1, 10));
        try {
            Runnable task = () -> label.setIcon(this.resourceManager.GetIconImage(name, 20));
            Thread thread = new Thread(task);
            thread.start();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return label;
    }

    private JLabel createHeaderLabel(String name) {
        JLabel label = new JLabel(name);
        label.setFont(new Font("Arial", 1, 16));
        return label;
    }

    private JButton createRankButton(String iconName, final String tooltip) {
        Icon icon = this.resourceManager.GetIconImage(iconName, 0);
        final JButton button = new JButton(icon);
        button.setToolTipText(tooltip);
        button.setPreferredSize(new Dimension(38, 38));
        button.setFocusable(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    RanksPanel.this.rankChange(tooltip);
                }
            }
        });
        return button;
    }
}

