/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.panels;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.helpers.DataManager;
import com.InfernalFC.models.PlayerData;
import com.InfernalFC.models.RankData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class LookupPanel
extends JPanel {
    private final DataManager dataManager;
    private final JLabel ssText = new JLabel();
    private final JComboBox combobox = new JComboBox();
    private PlayerData[] playerData = new PlayerData[0];
    private String color1;
    private String color2;

    @Inject
    public LookupPanel(InfernalFCConfig config, DataManager dataManager) {
        this.dataManager = dataManager;
        this.color1 = "#" + Integer.toHexString(config.col1color().getRGB()).substring(2);
        this.color2 = "#" + Integer.toHexString(config.col2color().getRGB()).substring(2);
        this.combobox.setEditable(true);
        this.combobox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                String searchString;
                if (event.getKeyChar() == '\n' && !(searchString = ((JTextComponent)((JComboBox)((Component)event.getSource()).getParent()).getEditor().getEditorComponent()).getText()).isEmpty()) {
                    LookupPanel.this.Search(searchString);
                }
            }
        });
        this.combobox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String selection = e.getItem().toString();
                PlayerData player = Arrays.stream(this.playerData).filter(data -> selection.equals(data.getUsername())).findFirst().orElse(null);
                Runnable task = () -> this.SetPlayerStats(player);
                Thread thread = new Thread(task);
                thread.start();
            }
        });
        this.setPreferredSize(new Dimension(200, 700));
        this.add(this.combobox);
        this.add(this.ssText);
    }

    public void Search(String input) {
        String searchString = input.replaceAll("\u00a0", " ");
        Runnable task = () -> {
            this.playerData = this.dataManager.GetPlayerData(searchString);
            String[] dropdownData = (String[])Arrays.stream(this.playerData).map(PlayerData::getUsername).toArray(String[]::new);
            this.combobox.setModel(new DefaultComboBoxModel<String>(dropdownData));
            this.combobox.setSelectedIndex(-1);
            this.combobox.getEditor().setItem(searchString);
            this.combobox.showPopup();
        };
        Thread thread = new Thread(task);
        thread.start();
    }

    public void SearchExact(String input) {
        String searchString = input.replaceAll("\u00a0", " ");
        Runnable task = () -> {
            this.playerData = this.dataManager.GetPlayerData(searchString);
            String[] dropdownData = (String[])Arrays.stream(this.playerData).map(PlayerData::getUsername).toArray(String[]::new);
            this.combobox.setModel(new DefaultComboBoxModel<String>(dropdownData));
            this.combobox.setSelectedIndex(-1);
            this.combobox.getEditor().setItem(searchString);
            PlayerData player = Arrays.stream(this.playerData).filter(data -> searchString.equalsIgnoreCase(data.getUsername())).findFirst().orElse(null);
            this.SetPlayerStats(player);
        };
        Thread thread = new Thread(task);
        thread.start();
    }

    private void SetPlayerStats(PlayerData playerData) {
        Object data = "";
        if (playerData != null) {
            RankData[] ranks = this.dataManager.GetRankData();
            RankData rank = Arrays.stream(ranks).filter(r -> playerData.getRank_id() == r.getId()).findFirst().orElse(null);
            data = (String)data + "<html><table width=230>";
            data = (String)data + "<tr>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='yellow'><b>General</b></font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Username</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getUsername();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Rank</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + rank.getName();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Active</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + (playerData.getActive() != false ? "Yes" : "No");
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='yellow'><b>Points Section</b></font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>PvM Points</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getPvmPoints();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Community Points</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getNonPvmPoints();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Total Points</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getOverallPoints();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='yellow'><b>Loot Section</b></font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Amount Split</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getValueSplit();
            data = (String)data + "<font color='" + this.color2 + "'>M</td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Amount Tanked</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getValueTanked();
            data = (String)data + "<font color='" + this.color2 + "'>M</td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='yellow'><b>Mentor Section</b></font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Mentor Points</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getMentorPoints();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td><font color='" + this.color1 + "'>Helper Points</font></td>";
            data = (String)data + "<td><font color='" + this.color2 + "'>";
            data = (String)data + playerData.getHelperPoints();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr></tr>";
            if (playerData.parentAccount == 0) {
                PlayerData[] alts = this.dataManager.GetAltData(playerData.getId());
                data = (String)data + "<tr>";
                data = (String)data + "<td><font color='yellow'><b>Alt Section</b></font></td>";
                data = (String)data + "<td><font color='" + this.color2 + "'>";
                data = (String)data + "</font></td>";
                data = (String)data + "</tr>";
                if (alts.length > 0) {
                    int altIndex = 0;
                    for (PlayerData alt : alts) {
                        data = (String)data + "<tr>";
                        data = altIndex == 0 ? (String)data + "<td><font color='" + this.color1 + "'>Usernames</font></td>" : (String)data + "<td></td>";
                        data = (String)data + "<td><font color='" + this.color2 + "'>";
                        data = (String)data + alt.getUsername();
                        data = (String)data + "</font></td>";
                        data = (String)data + "</tr>";
                        ++altIndex;
                    }
                } else {
                    data = (String)data + "<tr><td><font color='" + this.color1 + "'>No registered alts</font></td></tr>";
                }
            } else {
                PlayerData parent = this.dataManager.GetParentData(playerData.parentAccount);
                data = (String)data + "<tr>";
                data = (String)data + "<td><font color='yellow'><b>Main Account</b></font></td>";
                data = (String)data + "<td><font color='" + this.color2 + "'>";
                data = (String)data + "</font></td>";
                data = (String)data + "</tr>";
                data = (String)data + "<tr>";
                data = (String)data + "<td><font color='" + this.color1 + "'>Username</font></td>";
                data = (String)data + "<td><font color='" + this.color2 + "'>";
                data = (String)data + parent.getUsername();
                data = (String)data + "</font></td>";
                data = (String)data + "</tr>";
            }
            data = (String)data + "</table></html>";
        }
        this.ssText.setText((String)data);
    }
}

