/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.panels;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.helpers.DataManager;
import com.InfernalFC.models.EventData;
import com.InfernalFC.models.PointsData;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class HomePanel
extends JPanel {
    private final DataManager dataManager;
    private JPanel buttonPanel = new JPanel();
    private final JLabel ssText = new JLabel();
    private String color1;
    private String color2;

    @Inject
    private HomePanel(InfernalFCConfig config, DataManager dataManager) {
        this.dataManager = dataManager;
        this.color1 = "#" + Integer.toHexString(config.col1color().getRGB()).substring(2);
        this.color2 = "#" + Integer.toHexString(config.col2color().getRGB()).substring(2);
        this.setPreferredSize(new Dimension(200, 950));
        this.buttonPanel.setLayout(new GridLayout(0, 3));
        this.buttonPanel.add(this.createLinkButton("Website", "https://infernal-fc.com/"));
        this.buttonPanel.add(this.createLinkButton("Forum", "http://services.runescape.com/m=forum/c=IKL-JSzhrmo/users.ws?searchname=Infernal+Fc&lookup=view"));
        this.buttonPanel.add(this.createLinkButton("Discord", "https://discord.gg/ABYs3VK"));
        this.add(this.buttonPanel);
        this.add(this.ssText);
    }

    public void Load() {
        Runnable task = this::SetPointsStats;
        Thread thread = new Thread(task);
        thread.start();
    }

    private JButton createLinkButton(String name, final String url) {
        final JButton button = new JButton(name);
        button.setPreferredSize(new Dimension(74, 33));
        button.setFont(new Font("Arial", 0, 12));
        button.setFocusable(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    HomePanel.this.OpenUrl(url);
                }
            }
        });
        return button;
    }

    private void OpenUrl(String url) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void SetPointsStats() {
        PointsData overall = this.dataManager.GetOverallPoints();
        PointsData kc = this.dataManager.GetKcPoints();
        PointsData pets = this.dataManager.GetPetPoints();
        EventData[] events = this.dataManager.GetEvents();
        String pattern = "dd/MM/yyyy";
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Object data = "";
        data = (String)data + "<html><table width=230>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center; font-size:30px;'><font color='yellow'><b>Highscores</b></font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'><b>Overall Points:</b></font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'>";
        data = (String)data + overall.getMember().getUsername();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='yellow'>";
        data = (String)data + (int)overall.getSum();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'><b>KC:</b></font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'>";
        data = (String)data + kc.getMember().getUsername();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='yellow'>";
        data = (String)data + (int)kc.getSum();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'><b>Most Pets:</b></font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'>";
        data = (String)data + pets.getMember().getUsername();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center;'><font color='yellow'>";
        data = (String)data + pets.getCount();
        data = (String)data + "</font></td>";
        data = (String)data + "</tr>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "</table><hr></hr><table width=230>";
        data = (String)data + "<tr></tr>";
        data = (String)data + "<tr>";
        data = (String)data + "<td colspan='2' style='text-align: center; font-size:30px;'><font color='yellow'><b>Events</b></font></td>";
        data = (String)data + "</tr>";
        for (EventData event : events) {
            data = (String)data + "<tr></tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'><b>";
            data = (String)data + df.format(event.getDate());
            data = (String)data + "</b></font></td>";
            data = (String)data + "</tr>";
            data = (String)data + "<tr>";
            data = (String)data + "<td colspan='2' style='text-align: center;'><font color='" + this.color1 + "'>";
            data = (String)data + event.getName();
            data = (String)data + "</font></td>";
            data = (String)data + "</tr>";
        }
        data = (String)data + "</table></html>";
        this.ssText.setText((String)data);
    }
}

