/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.panels;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.InfernalFCPanel;
import com.InfernalFC.helpers.InventoryManager;
import com.InfernalFC.helpers.ResourceManager;
import com.InfernalFC.models.CmManData;
import com.InfernalFC.models.CmRoleEquipment;
import com.InfernalFC.models.ItemData;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class CmManRolePanel
extends JPanel {
    @Inject
    private Provider<InfernalFCPanel> infernalFCPanel;
    private final InventoryManager inventoryManager;
    private final ResourceManager resourceManager;
    private String role = "Surge BGS";
    private JPanel titlePanel = new JPanel();
    private JPanel equipmentPanel = new JPanel();
    private JPanel inventoryPannel = new JPanel();
    private JPanel runePanel = new JPanel();
    private JPanel prepotPanel = new JPanel();
    private JLabel notes = new JLabel("", 2);
    private String color1;
    private String color2;
    private CmManData data;

    @Inject
    private CmManRolePanel(InfernalFCConfig config, CmManData data, ResourceManager resourceManager, InventoryManager inventoryManager) {
        this.resourceManager = resourceManager;
        this.inventoryManager = inventoryManager;
        this.data = data;
        this.color1 = "#" + Integer.toHexString(config.col1color().getRGB()).substring(2);
        this.color2 = "#" + Integer.toHexString(config.col2color().getRGB()).substring(2);
        this.setPreferredSize(new Dimension(200, 1200));
        this.equipmentPanel.setLayout(new GridLayout(5, 3));
        this.equipmentPanel.setPreferredSize(new Dimension(150, 250));
        this.inventoryPannel.setLayout(new GridLayout(0, 4));
        this.inventoryPannel.setPreferredSize(new Dimension(200, 350));
        this.runePanel.setLayout(new GridLayout(1, 3));
        this.runePanel.setPreferredSize(new Dimension(150, 50));
        this.prepotPanel.setLayout(new GridLayout(2, 3));
        this.prepotPanel.setPreferredSize(new Dimension(150, 100));
        this.notes.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.notes.setOpaque(true);
        this.add(this.titlePanel);
        this.add(this.createTitleLabel("Equipment"));
        this.add(this.equipmentPanel);
        this.add(this.createTitleLabel("Inventory"));
        this.add(this.inventoryPannel);
        this.add(this.createTitleLabel("Runes"));
        this.add(this.runePanel);
        this.add(this.createTitleLabel("Prepot"));
        this.add(this.prepotPanel);
        this.add(this.createTitleLabel("Notes"));
        this.add(this.notes);
        this.updateUI();
    }

    public void setRole(String role) {
        this.role = role;
        this.setTitleRow();
        this.setEquipmentPanel();
        this.setInventoryPannel();
        this.setRunePannel();
        this.setPrepotPanel();
        this.setNotes();
    }

    private JButton createBackButton() {
        final JButton label = new JButton("<");
        label.setToolTipText("Back");
        label.setPreferredSize(new Dimension(26, 26));
        label.setFont(new Font("Arial", 0, 9));
        label.setFocusable(false);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ((InfernalFCPanel)((Object)CmManRolePanel.this.infernalFCPanel.get())).SwitchPanel("cmman");
                }
            }
        });
        return label;
    }

    private void setEquipmentPanel() {
        this.equipmentPanel.removeAll();
        CmRoleEquipment equipment = this.data.roleGearMapping.get(this.role);
        this.equipmentPanel.add(this.createDummyLabel());
        this.equipmentPanel.add(this.createItemLabel(equipment.helmet.name));
        this.equipmentPanel.add(this.createDummyLabel());
        this.equipmentPanel.add(this.createItemLabel(equipment.cape.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.necklace.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.ammo.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.weapon.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.torso.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.shield.name));
        this.equipmentPanel.add(this.createDummyLabel());
        this.equipmentPanel.add(this.createItemLabel(equipment.pants.name));
        this.equipmentPanel.add(this.createDummyLabel());
        this.equipmentPanel.add(this.createItemLabel(equipment.gloves.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.boots.name));
        this.equipmentPanel.add(this.createItemLabel(equipment.ring.name));
        this.equipmentPanel.updateUI();
    }

    private void setTitleRow() {
        this.titlePanel.removeAll();
        this.titlePanel.add(this.createBackButton());
        JLabel title = new JLabel(this.role, 0);
        title.setPreferredSize(new Dimension(150, 26));
        title.setForeground(Color.yellow);
        title.setFont(new Font("Serif", 1, 14));
        this.titlePanel.add(title);
        JLabel dummy = new JLabel();
        dummy.setPreferredSize(new Dimension(26, 26));
        this.titlePanel.add(dummy);
    }

    private void setInventoryPannel() {
        ItemData[] items;
        this.inventoryPannel.removeAll();
        for (ItemData item : items = this.data.roleInventoryMapping.get(this.role)) {
            this.inventoryPannel.add(this.createItemLabel(item.name));
        }
        int rest = 28 - items.length;
        for (int i = 0; i < rest; ++i) {
            this.inventoryPannel.add(this.createEmptyLabel());
        }
        this.inventoryPannel.updateUI();
    }

    private void setRunePannel() {
        ItemData[] items;
        this.runePanel.removeAll();
        for (ItemData item : items = this.data.roleRuneMapping.get(this.role)) {
            this.runePanel.add(this.createItemLabel(item.name));
        }
        this.runePanel.updateUI();
    }

    private void setPrepotPanel() {
        ItemData[] items;
        this.prepotPanel.removeAll();
        for (ItemData item : items = this.data.rolePrepotMapping.get(this.role)) {
            this.prepotPanel.add(this.createItemLabel(item.name));
        }
        int rest = 6 - items.length;
        for (int i = 0; i < rest; ++i) {
            this.prepotPanel.add(this.createEmptyLabel());
        }
        this.prepotPanel.updateUI();
    }

    private void setNotes() {
        String note = this.data.roleNoteMapping.get(this.role);
        this.notes.setText("<html><p style=\"width:150px\">" + note + "</p></html>");
    }

    private JLabel createTitleLabel(String title) {
        JLabel label = new JLabel(title, 0);
        label.setPreferredSize(new Dimension(200, 20));
        label.setForeground(Color.yellow);
        return label;
    }

    private JLabel createDummyLabel() {
        JLabel label = new JLabel();
        label.setMinimumSize(new Dimension(30, 30));
        label.setMaximumSize(new Dimension(30, 30));
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        return label;
    }

    private JLabel createEmptyLabel() {
        JLabel label = new JLabel();
        label.setMinimumSize(new Dimension(30, 30));
        label.setMaximumSize(new Dimension(30, 30));
        label.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        label.setOpaque(true);
        return label;
    }

    private JLabel createItemLabel(String name) {
        JLabel label = new JLabel();
        label.setToolTipText(name);
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        label.setOpaque(true);
        if (this.inventoryManager.HasItem(name)) {
            label.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        } else {
            label.setBackground(new Color(39, 25, 25));
        }
        try {
            Runnable task = () -> label.setIcon(this.resourceManager.GetItemImage(name));
            Thread thread = new Thread(task);
            thread.start();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return label;
    }
}

